/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.util.AnnotationModelLoader;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyAbstractFactory.class);
    protected Set<Class> models;
    protected Map<String, Field> mapAnnotedLinkField = new LinkedHashMap<String, Field>();
    protected String crlf;
    private AnnotationModelLoader modelsLoader;
    private String packageName;

    public BindyAbstractFactory(PackageScanClassResolver resolver, String packageName) throws Exception {
        this.modelsLoader = new AnnotationModelLoader(resolver);
        this.packageName = packageName;
        this.initModel();
    }

    @Override
    public void initModel() throws Exception {
        this.initModelClasses(this.packageName);
    }

    private void initModelClasses(String packageName) throws Exception {
        this.models = this.modelsLoader.loadModels(packageName);
    }

    public abstract void initAnnotedFields() throws Exception;

    @Override
    public abstract void bind(List<String> var1, Map<String, Object> var2) throws Exception;

    @Override
    public abstract String unbind(Map<String, Object> var1) throws Exception;

    public void link(Map<String, Object> model) throws Exception {
        for (String link : this.mapAnnotedLinkField.keySet()) {
            Field field = this.mapAnnotedLinkField.get(link);
            field.setAccessible(true);
            String toClassName = field.getType().getName();
            Object to = model.get(toClassName);
            ObjectHelper.notNull((Object)to, (String)"No @link annotation has been defined for the oject to link");
            field.set(model.get(field.getDeclaringClass().getName()), to);
        }
    }

    public Map<String, Object> factory() throws Exception {
        HashMap<String, Object> mapModel = new HashMap<String, Object>();
        for (Class cl : this.models) {
            Object obj = ObjectHelper.newInstance((Class)cl);
            mapModel.put(obj.getClass().getName(), obj);
        }
        return mapModel;
    }

    public String getCarriageReturn() {
        return this.crlf;
    }
}

