/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.dataformat.beanio.BeanIOConfiguration;
import org.apache.camel.dataformat.beanio.BeanIOHeader;
import org.apache.camel.dataformat.beanio.BeanIOHelper;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.BeanWriter;
import org.beanio.StreamFactory;
import org.beanio.Unmarshaller;

@Dataformat(value="beanio")
public class BeanIODataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private transient CamelContext camelContext;
    private transient StreamFactory factory;
    private transient BeanIOConfiguration configuration;
    private String streamName;
    private String mapping;
    private boolean ignoreUnidentifiedRecords;
    private boolean ignoreUnexpectedRecords;
    private boolean ignoreInvalidRecords;
    private Charset encoding = Charset.defaultCharset();
    private Properties properties;
    private BeanReaderErrorHandler beanReaderErrorHandler;
    private String beanReaderErrorHandlerType;
    private boolean unmarshalSingleObject;

    public BeanIODataFormat() {
    }

    public BeanIODataFormat(String mapping, String streamName) {
        this.setMapping(mapping);
        this.setStreamName(streamName);
    }

    public String getDataFormatName() {
        return "beanio";
    }

    protected void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull((Object)this.getStreamName(), (String)"Stream name not configured.");
        if (this.factory == null) {
            this.factory = StreamFactory.newInstance();
            if (ResourceHelper.isClasspathUri((String)this.getMapping())) {
                this.loadMappingResource();
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!ResourceHelper.isClasspathUri((String)this.getMapping())) {
            this.loadMappingResource();
        }
        this.configuration = new BeanIOConfiguration();
        this.configuration.setStreamName(this.streamName);
        this.configuration.setMapping(this.mapping);
        this.configuration.setIgnoreUnidentifiedRecords(this.ignoreUnidentifiedRecords);
        this.configuration.setIgnoreUnexpectedRecords(this.ignoreUnexpectedRecords);
        this.configuration.setIgnoreInvalidRecords(this.ignoreInvalidRecords);
        this.configuration.setEncoding(this.encoding);
        this.configuration.setProperties(this.properties);
        this.configuration.setBeanReaderErrorHandler(this.beanReaderErrorHandler);
        this.configuration.setBeanReaderErrorHandlerType(this.beanReaderErrorHandlerType);
        this.configuration.setUnmarshalSingleObject(this.unmarshalSingleObject);
    }

    protected void doStop() throws Exception {
        this.factory = null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    StreamFactory getFactory() {
        return this.factory;
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        List<Object> models = this.getModels(exchange, body);
        this.writeModels(stream, models);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        if (this.isUnmarshalSingleObject()) {
            return this.readSingleModel(exchange, stream);
        }
        return this.readModels(exchange, stream);
    }

    private void loadMappingResource() throws Exception {
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getMapping());
        try {
            if (this.getProperties() != null) {
                this.factory.load(is, this.getProperties());
            } else {
                this.factory.load(is);
            }
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    private List<Object> getModels(Exchange exchange, Object body) {
        List models;
        if (body instanceof Map && this.isUnmarshalSingleObject()) {
            models = new ArrayList<Object>();
            models.add(body);
        } else {
            models = (List)exchange.getContext().getTypeConverter().convertTo(List.class, body);
            if (models == null) {
                models = new ArrayList();
                for (Object model : org.apache.camel.support.ObjectHelper.createIterable((Object)body)) {
                    models.add(model);
                }
            }
        }
        return models;
    }

    private void writeModels(OutputStream stream, List<Object> models) {
        BufferedWriter streamWriter = IOHelper.buffered((Writer)new OutputStreamWriter(stream, this.getEncoding()));
        BeanWriter out = this.factory.createWriter(this.getStreamName(), (Writer)streamWriter);
        for (Object obj : models) {
            out.write(obj);
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readModels(Exchange exchange, InputStream stream) throws Exception {
        ArrayList<Object> results = new ArrayList<Object>();
        BufferedReader streamReader = IOHelper.buffered((Reader)new InputStreamReader(stream, this.getEncoding()));
        BeanReader in = this.factory.createReader(this.getStreamName(), (Reader)streamReader);
        BeanReaderErrorHandler errorHandler = BeanIOHelper.getOrCreateBeanReaderErrorHandler(this.configuration, exchange, results, null);
        in.setErrorHandler(errorHandler);
        try {
            Object readObject;
            while ((readObject = in.read()) != null) {
                if (readObject instanceof BeanIOHeader) {
                    exchange.getOut().getHeaders().putAll(((BeanIOHeader)readObject).getHeaders());
                }
                results.add(readObject);
            }
        }
        finally {
            in.close();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readSingleModel(Exchange exchange, InputStream stream) throws NoTypeConversionAvailableException {
        BufferedReader streamReader = IOHelper.buffered((Reader)new InputStreamReader(stream, this.getEncoding()));
        try {
            String data = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, (Object)streamReader);
            Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.getStreamName());
            Object object = unmarshaller.unmarshal(data);
            return object;
        }
        finally {
            IOHelper.close((Closeable)stream);
        }
    }

    public void setFactory(StreamFactory factory) {
        this.factory = factory;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public boolean isIgnoreUnidentifiedRecords() {
        return this.ignoreUnidentifiedRecords;
    }

    public void setIgnoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
        this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords;
    }

    public boolean isIgnoreUnexpectedRecords() {
        return this.ignoreUnexpectedRecords;
    }

    public void setIgnoreUnexpectedRecords(boolean ignoreUnexpectedRecords) {
        this.ignoreUnexpectedRecords = ignoreUnexpectedRecords;
    }

    public boolean isIgnoreInvalidRecords() {
        return this.ignoreInvalidRecords;
    }

    public void setIgnoreInvalidRecords(boolean ignoreInvalidRecords) {
        this.ignoreInvalidRecords = ignoreInvalidRecords;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public BeanReaderErrorHandler getBeanReaderErrorHandler() {
        return this.beanReaderErrorHandler;
    }

    public void setBeanReaderErrorHandler(BeanReaderErrorHandler beanReaderErrorHandler) {
        this.beanReaderErrorHandler = beanReaderErrorHandler;
    }

    public String getBeanReaderErrorHandlerType() {
        return this.beanReaderErrorHandlerType;
    }

    public void setBeanReaderErrorHandlerType(String beanReaderErrorHandlerType) {
        this.beanReaderErrorHandlerType = beanReaderErrorHandlerType;
    }

    public void setBeanReaderErrorHandlerType(Class<?> beanReaderErrorHandlerType) {
        this.beanReaderErrorHandlerType = beanReaderErrorHandlerType.getName();
    }

    public boolean isUnmarshalSingleObject() {
        return this.unmarshalSingleObject;
    }

    public void setUnmarshalSingleObject(boolean unmarshalSingleObject) {
        this.unmarshalSingleObject = unmarshalSingleObject;
    }
}

