/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantStaticTypeBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.component.bean.RequestBeanHolder;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultBeanProcessorFactory
implements BeanProcessorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanProcessorFactory.class);

    public Processor createBeanProcessor(CamelContext camelContext, Object bean, Method method) throws Exception {
        BeanInfo info = new BeanInfo(camelContext, method);
        return new BeanProcessor(bean, info);
    }

    public Processor createBeanProcessor(CamelContext camelContext, Object bean, String beanType, Class<?> beanClass, String ref, String method, BeanScope scope) throws Exception {
        BeanProcessor answer;
        BeanHolder beanHolder;
        Class clazz;
        Class clazz2 = clazz = bean != null ? bean.getClass() : null;
        if (ObjectHelper.isNotEmpty((Object)ref)) {
            if (scope == BeanScope.Singleton) {
                beanHolder = new RegistryBean(camelContext, ref).createCacheHolder();
                bean = beanHolder.getBean(null);
            } else {
                beanHolder = new RegistryBean(camelContext, ref);
            }
            if (scope == BeanScope.Request) {
                beanHolder = new RequestBeanHolder(beanHolder);
            }
            answer = new BeanProcessor(beanHolder);
        } else {
            if (bean == null) {
                if (beanType == null && beanClass == null) {
                    throw new IllegalArgumentException("bean, ref or beanType must be provided");
                }
                if (beanType != null) {
                    try {
                        clazz = camelContext.getClassResolver().resolveMandatoryClass(beanType);
                    }
                    catch (ClassNotFoundException e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                } else {
                    clazz = beanClass;
                }
                if (scope == BeanScope.Singleton && camelContext.getInjector().supportsAutoWiring()) {
                    try {
                        LOG.debug("Attempting to create new bean instance from class: {} via auto-wiring enabled", (Object)clazz);
                        bean = CamelContextHelper.newInstance((CamelContext)camelContext, (Class)clazz);
                    }
                    catch (Throwable e) {
                        LOG.debug("Error creating new bean instance from class: " + clazz + ". This exception is ignored", e);
                    }
                }
                if (bean == null && scope == BeanScope.Singleton && ObjectHelper.hasDefaultPublicNoArgConstructor((Class)clazz)) {
                    LOG.debug("Class has default no-arg constructor so creating a new bean instance: {}", (Object)clazz);
                    bean = CamelContextHelper.newInstance((CamelContext)camelContext, (Class)clazz);
                    ObjectHelper.notNull((Object)bean, (String)"bean", (Object)this);
                }
            }
            if (bean instanceof String) {
                throw new IllegalArgumentException("The bean instance is a java.lang.String type: " + bean + ". We suppose you want to refer to a bean instance by its id instead. Please use ref.");
            }
            beanHolder = bean != null ? new ConstantBeanHolder(bean, camelContext) : (scope == BeanScope.Singleton && ObjectHelper.hasDefaultPublicNoArgConstructor((Class)clazz) ? new ConstantTypeBeanHolder(clazz, camelContext).createCacheHolder() : (ObjectHelper.hasDefaultPublicNoArgConstructor((Class)clazz) ? new ConstantTypeBeanHolder(clazz, camelContext) : new ConstantStaticTypeBeanHolder(clazz, camelContext)));
            if (scope == BeanScope.Request) {
                beanHolder = new RequestBeanHolder(beanHolder);
            }
            answer = new BeanProcessor(beanHolder);
        }
        if (method != null) {
            answer.setMethod(method);
            if (scope == BeanScope.Singleton) {
                BeanInfo beanInfo = beanHolder.getBeanInfo();
                if (bean != null) {
                    if (!beanInfo.hasMethod(method)) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, bean, method)));
                    }
                } else if (clazz != null && !beanInfo.hasStaticMethod(method)) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, clazz, method, true)));
                }
            }
        }
        return answer;
    }
}

