/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.support.CamelContextHelper;

public class ExceptionPolicy {
    private String id;
    private String routeId;
    private boolean useOriginalInMessage;
    private boolean useOriginalInBody;
    private boolean hasOutputs;
    private Predicate handledPolicy;
    private Predicate continuedPolicy;
    private Predicate retryWhilePolicy;
    private Processor onRedelivery;
    private Processor onExceptionOccurred;
    private String redeliveryPolicyRef;
    private Map<RedeliveryOption, String> redeliveryPolicy;
    private List<String> exceptions;

    public ExceptionPolicy(String id, String routeId, boolean useOriginalInMessage, boolean useOriginalInBody, boolean hasOutputs, Predicate handledPolicy, Predicate continuedPolicy, Predicate retryWhilePolicy, Processor onRedelivery, Processor onExceptionOccurred, String redeliveryPolicyRef, Map<RedeliveryOption, String> redeliveryPolicy, List<String> exceptions) {
        this.id = id;
        this.routeId = routeId;
        this.useOriginalInMessage = useOriginalInMessage;
        this.useOriginalInBody = useOriginalInBody;
        this.hasOutputs = hasOutputs;
        this.handledPolicy = handledPolicy;
        this.continuedPolicy = continuedPolicy;
        this.retryWhilePolicy = retryWhilePolicy;
        this.onRedelivery = onRedelivery;
        this.onExceptionOccurred = onExceptionOccurred;
        this.redeliveryPolicyRef = redeliveryPolicyRef;
        this.redeliveryPolicy = redeliveryPolicy;
        this.exceptions = exceptions;
    }

    public String getId() {
        return this.id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public boolean isUseOriginalInMessage() {
        return this.useOriginalInMessage;
    }

    public boolean isUseOriginalInBody() {
        return this.useOriginalInBody;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public Predicate getContinuedPolicy() {
        return this.continuedPolicy;
    }

    public Predicate getRetryWhilePolicy() {
        return this.retryWhilePolicy;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public Processor getOnExceptionOccurred() {
        return this.onExceptionOccurred;
    }

    public RedeliveryPolicy createRedeliveryPolicy(CamelContext context, RedeliveryPolicy parentPolicy) {
        if (this.redeliveryPolicyRef != null) {
            return (RedeliveryPolicy)CamelContextHelper.mandatoryLookup((CamelContext)context, (String)this.redeliveryPolicyRef, RedeliveryPolicy.class);
        }
        if (this.redeliveryPolicy != null) {
            return ExceptionPolicy.createRedeliveryPolicy(this.redeliveryPolicy, context, parentPolicy);
        }
        if (this.hasOutputs && parentPolicy.getMaximumRedeliveries() != 0) {
            RedeliveryPolicy answer = parentPolicy.copy();
            answer.setMaximumRedeliveries(0);
            return answer;
        }
        return parentPolicy;
    }

    public boolean determineIfRedeliveryIsEnabled(CamelContext camelContext) throws Exception {
        Integer max;
        RedeliveryPolicy policy;
        if (this.redeliveryPolicyRef != null ? (policy = (RedeliveryPolicy)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)this.redeliveryPolicyRef, RedeliveryPolicy.class)).getMaximumRedeliveries() != 0 : this.redeliveryPolicy != null && (max = CamelContextHelper.parseInteger((CamelContext)camelContext, (String)this.redeliveryPolicy.get((Object)RedeliveryOption.maximumRedeliveries))) != null && max != 0) {
            return true;
        }
        return this.retryWhilePolicy != null;
    }

    private static RedeliveryPolicy createRedeliveryPolicy(Map<RedeliveryOption, String> definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            if (definition.get((Object)RedeliveryOption.maximumRedeliveries) != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.get((Object)RedeliveryOption.maximumRedeliveries)));
            }
            if (definition.get((Object)RedeliveryOption.redeliveryDelay) != null) {
                answer.setRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.get((Object)RedeliveryOption.redeliveryDelay)));
            }
            if (definition.get((Object)RedeliveryOption.asyncDelayedRedelivery) != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.asyncDelayedRedelivery)));
            }
            if (definition.get((Object)RedeliveryOption.retriesExhaustedLogLevel) != null) {
                answer.setRetriesExhaustedLogLevel(LoggingLevel.valueOf((String)definition.get((Object)RedeliveryOption.retriesExhaustedLogLevel)));
            }
            if (definition.get((Object)RedeliveryOption.retryAttemptedLogLevel) != null) {
                answer.setRetryAttemptedLogLevel(LoggingLevel.valueOf((String)definition.get((Object)RedeliveryOption.retryAttemptedLogLevel)));
            }
            if (definition.get((Object)RedeliveryOption.retryAttemptedLogInterval) != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.get((Object)RedeliveryOption.retryAttemptedLogInterval)));
            }
            if (definition.get((Object)RedeliveryOption.backOffMultiplier) != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.get((Object)RedeliveryOption.backOffMultiplier)));
            }
            if (definition.get((Object)RedeliveryOption.useExponentialBackOff) != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.useExponentialBackOff)));
            }
            if (definition.get((Object)RedeliveryOption.collisionAvoidanceFactor) != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.get((Object)RedeliveryOption.collisionAvoidanceFactor)));
            }
            if (definition.get((Object)RedeliveryOption.useCollisionAvoidance) != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.useCollisionAvoidance)));
            }
            if (definition.get((Object)RedeliveryOption.maximumRedeliveryDelay) != null) {
                answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.get((Object)RedeliveryOption.maximumRedeliveryDelay)));
            }
            if (definition.get((Object)RedeliveryOption.logStackTrace) != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logStackTrace)));
            }
            if (definition.get((Object)RedeliveryOption.logRetryStackTrace) != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logRetryStackTrace)));
            }
            if (definition.get((Object)RedeliveryOption.logHandled) != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logHandled)));
            }
            if (definition.get((Object)RedeliveryOption.logNewException) != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logNewException)));
            }
            if (definition.get((Object)RedeliveryOption.logContinued) != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logContinued)));
            }
            if (definition.get((Object)RedeliveryOption.logRetryAttempted) != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logRetryAttempted)));
            }
            if (definition.get((Object)RedeliveryOption.logExhausted) != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logExhausted)));
            }
            if (definition.get((Object)RedeliveryOption.logExhaustedMessageHistory) != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logExhaustedMessageHistory)));
            }
            if (definition.get((Object)RedeliveryOption.logExhaustedMessageBody) != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.logExhaustedMessageBody)));
            }
            if (definition.get((Object)RedeliveryOption.disableRedelivery) != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.disableRedelivery)).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.get((Object)RedeliveryOption.delayPattern) != null) {
                answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)definition.get((Object)RedeliveryOption.delayPattern)));
            }
            if (definition.get((Object)RedeliveryOption.allowRedeliveryWhileStopping) != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.get((Object)RedeliveryOption.allowRedeliveryWhileStopping)));
            }
            if (definition.get((Object)RedeliveryOption.exchangeFormatterRef) != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText((CamelContext)context, (String)definition.get((Object)RedeliveryOption.exchangeFormatterRef)));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public static enum RedeliveryOption {
        maximumRedeliveries,
        redeliveryDelay,
        asyncDelayedRedelivery,
        backOffMultiplier,
        useExponentialBackOff,
        collisionAvoidanceFactor,
        useCollisionAvoidance,
        maximumRedeliveryDelay,
        retriesExhaustedLogLevel,
        retryAttemptedLogLevel,
        retryAttemptedLogInterval,
        logRetryAttempted,
        logStackTrace,
        logRetryStackTrace,
        logHandled,
        logNewException,
        logContinued,
        logExhausted,
        logExhaustedMessageHistory,
        logExhaustedMessageBody,
        disableRedelivery,
        delayPattern,
        allowRedeliveryWhileStopping,
        exchangeFormatterRef;

    }
}

