/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class LoopProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private String id;
    private final Expression expression;
    private final Predicate predicate;
    private final boolean copy;

    public LoopProcessor(Processor processor, Expression expression, Predicate predicate, boolean copy) {
        super(processor);
        this.expression = expression;
        this.predicate = predicate;
        this.copy = copy;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            LoopState state = new LoopState(exchange, callback);
            if (exchange.isTransacted()) {
                exchange.getContext().getReactiveExecutor().scheduleSync((Runnable)state);
            } else {
                exchange.getContext().getReactiveExecutor().scheduleMain((Runnable)state);
            }
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected Exchange prepareExchange(Exchange exchange, int index) {
        if (this.copy) {
            return ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
        }
        ExchangeHelper.prepareOutToIn((Exchange)exchange);
        return exchange;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public String getTraceLabel() {
        if (this.predicate != null) {
            return "loopWhile[" + this.predicate + "]";
        }
        return "loop[" + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        if (this.predicate != null) {
            return "Loop[while: " + this.predicate + " do: " + this.getProcessor() + "]";
        }
        return "Loop[for: " + this.expression + " times do: " + this.getProcessor() + "]";
    }

    class LoopState
    implements Runnable {
        final Exchange exchange;
        final AsyncCallback callback;
        Exchange current;
        int index;
        int count;

        public LoopState(Exchange exchange, AsyncCallback callback) throws NoTypeConversionAvailableException {
            this.exchange = exchange;
            this.callback = callback;
            this.current = exchange;
            if (LoopProcessor.this.expression != null) {
                String text = (String)LoopProcessor.this.expression.evaluate(exchange, String.class);
                this.count = (Integer)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Integer.class, (Object)text);
                exchange.setProperty("CamelLoopSize", (Object)this.count);
            }
        }

        @Override
        public void run() {
            try {
                boolean doLoop;
                boolean cont = PipelineHelper.continueProcessing(this.current, "so breaking out of loop", LoopProcessor.this.log);
                boolean doWhile = LoopProcessor.this.predicate == null || LoopProcessor.this.predicate.matches(this.current);
                boolean bl = doLoop = LoopProcessor.this.expression == null || this.index < this.count;
                if (cont && doWhile && doLoop) {
                    this.current = LoopProcessor.this.prepareExchange(this.exchange, this.index);
                    LoopProcessor.this.log.debug("LoopProcessor: iteration #{}", (Object)this.index);
                    this.current.setProperty("CamelLoopIndex", (Object)this.index);
                    LoopProcessor.this.processor.process(this.current, doneSync -> {
                        ++this.index;
                        this.exchange.getContext().getReactiveExecutor().schedule((Runnable)this);
                    });
                } else {
                    ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)this.current);
                    LoopProcessor.this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                    this.callback.done(false);
                }
            }
            catch (Exception e) {
                LoopProcessor.this.log.trace("Processing failed for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)e.getMessage());
                this.exchange.setException((Throwable)e);
                this.callback.done(false);
            }
        }

        public String toString() {
            return "LoopState[" + this.exchange.getExchangeId() + "]";
        }
    }
}

