/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.GlobalEndpointConfiguration;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupListener;
import org.apache.camel.StatefulService;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.TypeConverter;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.impl.engine.BaseRouteService;
import org.apache.camel.impl.engine.BeanProxyFactoryResolver;
import org.apache.camel.impl.engine.DefaultAnnotationBasedProcessorFactory;
import org.apache.camel.impl.engine.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.impl.engine.DefaultDeferServiceFactory;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.impl.engine.DefaultGlobalEndpointConfiguration;
import org.apache.camel.impl.engine.DefaultManagementNameStrategy;
import org.apache.camel.impl.engine.DefaultManagementStrategyFactory;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.impl.engine.DefaultRouteError;
import org.apache.camel.impl.engine.DefaultRouteStartupOrder;
import org.apache.camel.impl.engine.DefaultRuntimeEndpointRegistry;
import org.apache.camel.impl.engine.DeferServiceStartupListener;
import org.apache.camel.impl.engine.EndpointKey;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.engine.ProvisionalEndpointRegistry;
import org.apache.camel.impl.engine.ServicePool;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.impl.validator.ValidatorKey;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DeferServiceFactory;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.function.ThrowingRunnable;
import org.slf4j.MDC;

public abstract class AbstractCamelContext
extends ServiceSupport
implements ExtendedCamelContext,
Suspendable {
    private String version;
    private final AtomicBoolean vetoStarted = new AtomicBoolean();
    private String managementName;
    private ClassLoader applicationContextClassLoader;
    private final AtomicInteger endpointKeyCounter = new AtomicInteger();
    private final List<EndpointStrategy> endpointStrategies = new ArrayList<EndpointStrategy>();
    private final GlobalEndpointConfiguration globalEndpointConfiguration = new DefaultGlobalEndpointConfiguration();
    private final Map<String, Component> components = new ConcurrentHashMap<String, Component>();
    private final Set<Route> routes = new LinkedHashSet<Route>();
    private final List<Service> servicesToStop = new CopyOnWriteArrayList<Service>();
    private final List<StartupListener> startupListeners = new CopyOnWriteArrayList<StartupListener>();
    private final DeferServiceStartupListener deferStartupListener = new DeferServiceStartupListener();
    private boolean autoCreateComponents = true;
    private final Map<String, Language> languages = new ConcurrentHashMap<String, Language>();
    private final List<LifecycleStrategy> lifecycleStrategies = new CopyOnWriteArrayList<LifecycleStrategy>();
    private Map<String, RestConfiguration> restConfigurations = new ConcurrentHashMap<String, RestConfiguration>();
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private List<RoutePolicyFactory> routePolicyFactories = new ArrayList<RoutePolicyFactory>();
    private Set<LogListener> logListeners = new LinkedHashSet<LogListener>();
    private volatile boolean firstStartDone;
    private volatile boolean doNotStartRoutesOnFirstStart;
    private final ThreadLocal<Boolean> isStartingRoutes = new ThreadLocal();
    private final ThreadLocal<Boolean> isSetupRoutes = new ThreadLocal();
    private Initialization initialization = Initialization.Default;
    private Boolean autoStartup = Boolean.TRUE;
    private Boolean backlogTrace = Boolean.FALSE;
    private Boolean trace = Boolean.FALSE;
    private String tracePattern;
    private Boolean debug = Boolean.FALSE;
    private Boolean messageHistory = Boolean.TRUE;
    private Boolean logMask = Boolean.FALSE;
    private Boolean logExhaustedMessageBody = Boolean.FALSE;
    private Boolean streamCache = Boolean.FALSE;
    private Boolean disableJMX = Boolean.FALSE;
    private Boolean loadTypeConverters = Boolean.TRUE;
    private Boolean typeConverterStatisticsEnabled = Boolean.FALSE;
    private Boolean useMDCLogging = Boolean.FALSE;
    private String mdcLoggingKeysPattern;
    private Boolean useDataType = Boolean.FALSE;
    private Boolean useBreadcrumb = Boolean.FALSE;
    private Boolean allowUseOriginalMessage = Boolean.FALSE;
    private Long delay;
    private ErrorHandlerFactory errorHandlerFactory;
    private Map<String, String> globalOptions = new HashMap<String, String>();
    private PropertiesComponent propertiesComponent;
    private final Map<String, FactoryFinder> factories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Map<String, BaseRouteService> routeServices = new LinkedHashMap<String, BaseRouteService>();
    private final Map<String, BaseRouteService> suspendedRouteServices = new LinkedHashMap<String, BaseRouteService>();
    private final Object lock = new Object();
    private volatile CamelContextNameStrategy nameStrategy;
    private volatile ReactiveExecutor reactiveExecutor;
    private volatile ManagementNameStrategy managementNameStrategy;
    private volatile Registry registry;
    private volatile TypeConverter typeConverter;
    private volatile TypeConverterRegistry typeConverterRegistry;
    private volatile Injector injector;
    private volatile CamelBeanPostProcessor beanPostProcessor;
    private volatile ComponentResolver componentResolver;
    private volatile LanguageResolver languageResolver;
    private volatile DataFormatResolver dataFormatResolver;
    private volatile ManagementStrategy managementStrategy;
    private volatile ManagementMBeanAssembler managementMBeanAssembler;
    private volatile RestRegistryFactory restRegistryFactory;
    private volatile RestRegistry restRegistry;
    private volatile HeadersMapFactory headersMapFactory;
    private volatile BeanProxyFactory beanProxyFactory;
    private volatile BeanProcessorFactory beanProcessorFactory;
    private volatile ClassResolver classResolver;
    private volatile PackageScanClassResolver packageScanClassResolver;
    private volatile PackageScanResourceResolver packageScanResourceResolver;
    private volatile ServicePool<Producer> producerServicePool;
    private volatile ServicePool<PollingConsumer> pollingConsumerServicePool;
    private volatile NodeIdFactory nodeIdFactory;
    private volatile ProcessorFactory processorFactory;
    private volatile MessageHistoryFactory messageHistoryFactory;
    private volatile FactoryFinderResolver factoryFinderResolver;
    private volatile FactoryFinder defaultFactoryFinder;
    private volatile StreamCachingStrategy streamCachingStrategy;
    private volatile InflightRepository inflightRepository;
    private volatile AsyncProcessorAwaitManager asyncProcessorAwaitManager;
    private volatile ShutdownStrategy shutdownStrategy;
    private volatile ModelJAXBContextFactory modelJAXBContextFactory;
    private volatile ExecutorServiceManager executorServiceManager;
    private volatile UuidGenerator uuidGenerator;
    private volatile UnitOfWorkFactory unitOfWorkFactory;
    private volatile RouteController routeController;
    private volatile ScheduledExecutorService errorHandlerExecutorService;
    private volatile BeanIntrospection beanIntrospection;
    private final DeferServiceFactory deferServiceFactory = new DefaultDeferServiceFactory();
    private final AnnotationBasedProcessorFactory annotationBasedProcessorFactory = new DefaultAnnotationBasedProcessorFactory();
    private TransformerRegistry<TransformerKey> transformerRegistry;
    private ValidatorRegistry<ValidatorKey> validatorRegistry;
    private EndpointRegistry<EndpointKey> endpoints;
    private RuntimeEndpointRegistry runtimeEndpointRegistry;
    private final List<RouteStartupOrder> routeStartupOrder = new ArrayList<RouteStartupOrder>();
    private int defaultRouteStartupOrder = 1000;
    private ShutdownRoute shutdownRoute = ShutdownRoute.Default;
    private ShutdownRunningTask shutdownRunningTask = ShutdownRunningTask.CompleteCurrentTaskOnly;
    private Debugger debugger;
    private Tracer tracer;
    private final StopWatch stopWatch = new StopWatch(false);
    private Date startDate;
    private SSLContextParameters sslContextParameters;
    private final ThreadLocal<Set<String>> componentsInCreation = new ThreadLocal<Set<String>>(){

        @Override
        public Set<String> initialValue() {
            return new HashSet<String>();
        }
    };
    private Map<Class<?>, Object> extensions = new ConcurrentHashMap();

    public AbstractCamelContext() {
        this(true);
    }

    public AbstractCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    public AbstractCamelContext(boolean init) {
        this.endpoints = new ProvisionalEndpointRegistry();
        this.startupListeners.add(this.deferStartupListener);
        if (init) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing CamelContext", e);
            }
        }
    }

    public void doInit() throws Exception {
        this.setupManagement(null);
        CamelContextTracker.notifyContextCreated((CamelContext)this);
    }

    public <T extends CamelContext> T adapt(Class<T> type) {
        return (T)((CamelContext)type.cast((Object)this));
    }

    public <T> T getExtension(Class<T> type) {
        if (type.isInstance((Object)this)) {
            return type.cast((Object)this);
        }
        Object extension = this.extensions.get(type);
        if (extension instanceof Supplier) {
            extension = ((Supplier)extension).get();
            this.setExtension(type, extension);
        }
        return (T)extension;
    }

    public <T> void setExtension(Class<T> type, T module) {
        try {
            this.extensions.put(type, this.doAddService(module));
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public <T> void setDefaultExtension(Class<T> type, Supplier<T> module) {
        this.extensions.putIfAbsent(type, module);
    }

    public boolean isVetoStarted() {
        return this.vetoStarted.get();
    }

    public Initialization getInitialization() {
        return this.initialization;
    }

    public void setInitialization(Initialization initialization) {
        this.initialization = initialization;
    }

    public String getName() {
        return this.getNameStrategy().getName();
    }

    public void setName(String name) {
        this.setNameStrategy(new ExplicitCamelContextNameStrategy(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelContextNameStrategy getNameStrategy() {
        if (this.nameStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.nameStrategy == null) {
                    this.setNameStrategy(this.createCamelContextNameStrategy());
                }
            }
        }
        return this.nameStrategy;
    }

    public void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.nameStrategy = this.doAddService(nameStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagementNameStrategy getManagementNameStrategy() {
        if (this.managementNameStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.managementNameStrategy == null) {
                    this.setManagementNameStrategy(this.createManagementNameStrategy());
                }
            }
        }
        return this.managementNameStrategy;
    }

    public void setManagementNameStrategy(ManagementNameStrategy managementNameStrategy) {
        this.managementNameStrategy = this.doAddService(managementNameStrategy);
    }

    public String getManagementName() {
        return this.managementName;
    }

    public void setManagementName(String managementName) {
        this.managementName = managementName;
    }

    public Component hasComponent(String componentName) {
        return this.components.get(componentName);
    }

    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull((Object)component, (String)"component");
        component.setCamelContext((CamelContext)this);
        Component oldValue = this.components.putIfAbsent(componentName, component);
        if (oldValue != null) {
            throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
        }
        this.postInitComponent(componentName, component);
    }

    private void postInitComponent(String componentName, Component component) {
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onComponentAdd(componentName, component);
        }
        if (component instanceof PropertiesComponent && "properties".equals(componentName)) {
            this.propertiesComponent = (PropertiesComponent)component;
            ServiceHelper.initService((Object)this.propertiesComponent);
        }
    }

    public Component getComponent(String name) {
        return this.getComponent(name, this.autoCreateComponents, true);
    }

    public Component getComponent(String name, boolean autoCreateComponents) {
        return this.getComponent(name, autoCreateComponents, true);
    }

    public Component getComponent(final String name, final boolean autoCreateComponents, boolean autoStart) {
        this.init();
        if (this.componentsInCreation.get().contains(name)) {
            throw new IllegalStateException("Circular dependency detected, the component " + name + " is already being created");
        }
        try {
            final AtomicBoolean created = new AtomicBoolean(false);
            Component component = this.components.computeIfAbsent(name, new Function<String, Component>(){

                @Override
                public Component apply(String comp) {
                    created.set(true);
                    return AbstractCamelContext.this.initComponent(name, autoCreateComponents);
                }
            });
            if (component != null && created.get() && autoStart && (this.isStarted() || this.isStarting())) {
                this.startService((Service)component);
            }
            Component component2 = component;
            return component2;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot auto create component: " + name, (Throwable)e);
        }
        finally {
            this.componentsInCreation.get().remove(name);
        }
    }

    private Component initComponent(String name, boolean autoCreateComponents) {
        Component component = null;
        if (autoCreateComponents) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using ComponentResolver: {} to resolve component with name: {}", (Object)this.getComponentResolver(), (Object)name);
                }
                this.componentsInCreation.get().add(name);
                component = this.getComponentResolver().resolveComponent(name, (CamelContext)this);
                if (component != null) {
                    component.setCamelContext((CamelContext)this);
                    this.postInitComponent(name, component);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot auto create component: " + name, (Throwable)e);
            }
        }
        return component;
    }

    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        String message = component == null ? "Did not find component given by the name: " + name : "Found component of type: " + component.getClass() + " instead of expected: " + componentType;
        throw new IllegalArgumentException(message);
    }

    public Component resolveComponent(String name) {
        Component answer = this.hasComponent(name);
        if (answer == null) {
            try {
                answer = this.getComponentResolver().resolveComponent(name, (CamelContext)this);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot resolve component: " + name, (Throwable)e);
            }
        }
        return answer;
    }

    public Component removeComponent(String componentName) {
        Component oldComponent = this.components.remove(componentName);
        if (oldComponent != null) {
            try {
                this.stopServices(oldComponent);
            }
            catch (Exception e) {
                this.log.warn("Error stopping component " + oldComponent + ". This exception will be ignored.", (Throwable)e);
            }
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onComponentRemove(componentName, oldComponent);
            }
        }
        if (oldComponent != null && "properties".equals(componentName)) {
            this.propertiesComponent = null;
        }
        return oldComponent;
    }

    public EndpointRegistry<EndpointKey> getEndpointRegistry() {
        return this.endpoints;
    }

    public Collection<Endpoint> getEndpoints() {
        return new ArrayList<Endpoint>(this.endpoints.values());
    }

    public Map<String, Endpoint> getEndpointMap() {
        TreeMap<String, Endpoint> answer = new TreeMap<String, Endpoint>();
        for (Map.Entry entry : this.endpoints.entrySet()) {
            answer.put((String)((EndpointKey)((Object)entry.getKey())).get(), (Endpoint)entry.getValue());
        }
        return answer;
    }

    public Endpoint hasEndpoint(String uri) {
        return (Endpoint)this.endpoints.get((Object)this.getEndpointKey(uri));
    }

    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        this.startService((Service)endpoint);
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove((Object)this.getEndpointKey(uri));
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onEndpointAdd(endpoint);
        }
        this.addEndpointToRegistry(uri, endpoint);
        if (oldEndpoint != null && oldEndpoint != endpoint) {
            this.stopServices(oldEndpoint);
        }
        return oldEndpoint;
    }

    public void removeEndpoint(Endpoint endpoint) throws Exception {
        this.removeEndpoints(endpoint.getEndpointUri());
    }

    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove((Object)this.getEndpointKey(uri));
        if (oldEndpoint != null) {
            answer.add(oldEndpoint);
            this.stopServices(oldEndpoint);
        } else {
            for (Map.Entry entry : this.endpoints.entrySet()) {
                oldEndpoint = (Endpoint)entry.getValue();
                if (!EndpointHelper.matchEndpoint((CamelContext)this, (String)oldEndpoint.getEndpointUri(), (String)uri)) continue;
                try {
                    this.stopServices(oldEndpoint);
                }
                catch (Exception e) {
                    this.log.warn("Error stopping endpoint " + oldEndpoint + ". This exception will be ignored.", (Throwable)e);
                }
                answer.add(oldEndpoint);
                this.endpoints.remove(entry.getKey());
            }
        }
        for (Endpoint endpoint : answer) {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointRemove(endpoint);
            }
        }
        return answer;
    }

    public Endpoint getEndpoint(String uri) {
        this.init();
        StringHelper.notEmpty((String)uri, (String)"uri");
        this.log.trace("Getting endpoint with uri: {}", (Object)uri);
        try {
            uri = this.resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        String rawUri = uri;
        uri = AbstractCamelContext.normalizeEndpointUri(uri);
        this.log.trace("Getting endpoint with raw uri: {}, normalized uri: {}", (Object)rawUri, (Object)uri);
        String scheme = null;
        EndpointKey key = this.getEndpointKeyPreNormalized(uri);
        Endpoint answer = (Endpoint)this.endpoints.get((Object)key);
        if (answer == null) {
            try {
                int pos;
                String componentName;
                Component component;
                String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
                if (splitURI[1] != null) {
                    scheme = splitURI[0];
                    this.log.trace("Endpoint uri: {} is from component with name: {}", (Object)uri, (Object)scheme);
                    Component component2 = this.getComponent(scheme);
                    if (component2 != null) {
                        this.log.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component2);
                        answer = component2.useRawUri() ? component2.createEndpoint(rawUri) : component2.createEndpoint(uri);
                        if (answer != null && this.log.isDebugEnabled()) {
                            this.log.debug("{} converted to endpoint: {} by component: {}", new Object[]{URISupport.sanitizeUri((String)uri), answer, component2});
                        }
                    }
                }
                if (answer == null) {
                    answer = this.createEndpoint(uri);
                    this.log.trace("No component to create endpoint from uri: {} fallback lookup in registry -> {}", (Object)uri, (Object)answer);
                }
                if (answer == null && splitURI[1] == null && (component = this.getComponent(componentName = (pos = uri.indexOf(63)) > 0 ? uri.substring(0, pos) : uri)) != null) {
                    this.log.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component);
                    answer = component.useRawUri() ? component.createEndpoint(rawUri) : component.createEndpoint(uri);
                    if (answer != null && this.log.isDebugEnabled()) {
                        this.log.debug("{} converted to endpoint: {} by component: {}", new Object[]{URISupport.sanitizeUri((String)uri), answer, component});
                    }
                }
                if (answer != null) {
                    this.addService(answer);
                    answer = this.addEndpointToRegistry(uri, answer);
                }
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        if (answer == null && scheme != null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    public Endpoint getEndpoint(String uri, Map<String, Object> parameters) {
        this.init();
        StringHelper.notEmpty((String)uri, (String)"uri");
        this.log.trace("Getting endpoint with uri: {} and parameters: {}", (Object)uri, parameters);
        try {
            uri = this.resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        String rawUri = uri;
        uri = AbstractCamelContext.normalizeEndpointUri(uri);
        this.log.trace("Getting endpoint with raw uri: {}, normalized uri: {}", (Object)rawUri, (Object)uri);
        String scheme = null;
        EndpointKey key = this.getEndpointKeyPreNormalized(uri);
        Endpoint answer = (Endpoint)this.endpoints.get((Object)key);
        if (answer == null) {
            try {
                int pos;
                String componentName;
                Component component;
                String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
                if (splitURI[1] != null) {
                    scheme = splitURI[0];
                    this.log.trace("Endpoint uri: {} is from component with name: {}", (Object)uri, (Object)scheme);
                    Component component2 = this.getComponent(scheme);
                    if (component2 != null) {
                        this.log.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component2);
                        answer = component2.useRawUri() ? component2.createEndpoint(rawUri, parameters) : component2.createEndpoint(uri, parameters);
                        if (answer != null && this.log.isDebugEnabled()) {
                            this.log.debug("{} converted to endpoint: {} by component: {}", new Object[]{URISupport.sanitizeUri((String)uri), answer, component2});
                        }
                    }
                }
                if (answer == null) {
                    answer = this.createEndpoint(uri);
                    this.log.trace("No component to create endpoint from uri: {} fallback lookup in registry -> {}", (Object)uri, (Object)answer);
                }
                if (answer == null && splitURI[1] == null && (component = this.getComponent(componentName = (pos = uri.indexOf(63)) > 0 ? uri.substring(0, pos) : uri)) != null) {
                    this.log.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component);
                    answer = component.useRawUri() ? component.createEndpoint(rawUri, parameters) : component.createEndpoint(uri, parameters);
                    if (answer != null && this.log.isDebugEnabled()) {
                        this.log.debug("{} converted to endpoint: {} by component: {}", new Object[]{URISupport.sanitizeUri((String)uri), answer, component});
                    }
                }
                if (answer != null) {
                    this.addService(answer);
                    answer = this.addEndpointToRegistry(uri, answer);
                }
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        if (answer == null && scheme != null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint == null) {
            throw new NoSuchEndpointException(name);
        }
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    public void registerEndpointCallback(EndpointStrategy strategy) {
        if (!this.endpointStrategies.contains(strategy)) {
            this.endpointStrategies.add(strategy);
            for (Endpoint endpoint : this.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.endpoints.put((Object)this.getEndpointKey(endpoint.getEndpointUri()), (Object)newEndpoint);
            }
        }
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        StringHelper.notEmpty((String)uri, (String)"uri");
        ObjectHelper.notNull((Object)endpoint, (String)"endpoint");
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put((Object)this.getEndpointKey(uri, endpoint), (Object)endpoint);
        return endpoint;
    }

    protected static String normalizeEndpointUri(String uri) {
        try {
            uri = URISupport.normalizeUri((String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    protected EndpointKey getEndpointKey(String uri) {
        return new EndpointKey(uri);
    }

    protected EndpointKey getEndpointKeyPreNormalized(String uri) {
        return new EndpointKey(uri, true);
    }

    protected EndpointKey getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint != null && !endpoint.isSingleton()) {
            int counter = this.endpointKeyCounter.incrementAndGet();
            return new EndpointKey(uri + ":" + counter);
        }
        return new EndpointKey(uri);
    }

    public GlobalEndpointConfiguration getGlobalEndpointConfiguration() {
        return this.globalEndpointConfiguration;
    }

    public void setRouteController(RouteController routeController) {
        this.routeController = routeController;
        this.doAddService(routeController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouteController getRouteController() {
        if (this.routeController == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.routeController == null) {
                    this.setRouteController(this.createRouteController());
                }
            }
        }
        return this.routeController;
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.routeStartupOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Route> getRoutes() {
        if (this.routes.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Route> set = this.routes;
        synchronized (set) {
            return new ArrayList<Route>(this.routes);
        }
    }

    public Route getRoute(String id) {
        if (id != null) {
            for (Route route : this.getRoutes()) {
                if (!route.getId().equals(id)) continue;
                return route;
            }
        }
        return null;
    }

    public Processor getProcessor(String id) {
        for (Route route : this.getRoutes()) {
            List list = route.filter(id);
            if (list.size() != 1) continue;
            return (Processor)list.get(0);
        }
        return null;
    }

    public <T extends Processor> T getProcessor(String id, Class<T> type) {
        Processor answer = this.getProcessor(id);
        if (answer != null) {
            return (T)((Processor)type.cast(answer));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoute(Route route) {
        Set<Route> set = this.routes;
        synchronized (set) {
            this.routes.remove(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoute(Route route) {
        Set<Route> set = this.routes;
        synchronized (set) {
            this.routes.add(route);
        }
    }

    public void addRoutes(RoutesBuilder builder) throws Exception {
        this.init();
        this.log.debug("Adding routes from builder: {}", (Object)builder);
        this.doWithDefinedClassLoader(() -> builder.addRoutesToCamelContext((CamelContext)this));
    }

    public ServiceStatus getRouteStatus(String key) {
        BaseRouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    public boolean isStartingRoutes() {
        Boolean answer = this.isStartingRoutes.get();
        return answer != null && answer != false;
    }

    public void setStartingRoutes(boolean starting) {
        if (starting) {
            this.isStartingRoutes.set(true);
        } else {
            this.isStartingRoutes.remove();
        }
    }

    public boolean isSetupRoutes() {
        Boolean answer = this.isSetupRoutes.get();
        return answer != null && answer != false;
    }

    public void startAllRoutes() throws Exception {
        this.doStartOrResumeRoutes(this.routeServices, true, true, false, false);
    }

    public synchronized void startRoute(String routeId) throws Exception {
        DefaultRouteError.reset((CamelContext)this, routeId);
        BaseRouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            try {
                this.startRouteService(routeService, false);
            }
            catch (Exception e) {
                DefaultRouteError.set((CamelContext)this, routeId, RouteError.Phase.START, e);
                throw e;
            }
        }
    }

    public synchronized void resumeRoute(String routeId) throws Exception {
        DefaultRouteError.reset((CamelContext)this, routeId);
        try {
            if (!this.routeSupportsSuspension(routeId)) {
                this.startRoute(routeId);
                return;
            }
            BaseRouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                this.resumeRouteService(routeService);
                Route route = this.getRoute(routeId);
                ServiceHelper.resumeService((Object)route);
            }
        }
        catch (Exception e) {
            DefaultRouteError.set((CamelContext)this, routeId, RouteError.Phase.RESUME, e);
            throw e;
        }
    }

    public synchronized boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        DefaultRouteError.reset((CamelContext)this, routeId);
        BaseRouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            try {
                DefaultRouteStartupOrder route = new DefaultRouteStartupOrder(1, routeService.getRoute(), routeService);
                boolean completed = this.getShutdownStrategy().shutdown((CamelContext)this, (RouteStartupOrder)route, timeout, timeUnit, abortAfterTimeout);
                if (completed) {
                    this.stopRouteService(routeService, false);
                } else {
                    this.startRouteService(routeService, false);
                }
                return completed;
            }
            catch (Exception e) {
                DefaultRouteError.set((CamelContext)this, routeId, RouteError.Phase.STOP, e);
                throw e;
            }
        }
        return false;
    }

    public void stopRoute(String routeId) throws Exception {
        this.doShutdownRoute(routeId, this.getShutdownStrategy().getTimeout(), this.getShutdownStrategy().getTimeUnit(), false);
    }

    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdownRoute(routeId, timeout, timeUnit, false);
    }

    protected synchronized void doShutdownRoute(String routeId, long timeout, TimeUnit timeUnit, boolean removingRoutes) throws Exception {
        DefaultRouteError.reset((CamelContext)this, routeId);
        BaseRouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            try {
                ArrayList<DefaultRouteStartupOrder> routes = new ArrayList<DefaultRouteStartupOrder>(1);
                DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoute(), routeService);
                routes.add(order);
                this.getShutdownStrategy().shutdown((CamelContext)this, routes, timeout, timeUnit);
                this.stopRouteService(routeService, removingRoutes);
            }
            catch (Exception e) {
                DefaultRouteError.set((CamelContext)this, routeId, removingRoutes ? RouteError.Phase.SHUTDOWN : RouteError.Phase.STOP, e);
                throw e;
            }
        }
    }

    public synchronized boolean removeRoute(String routeId) throws Exception {
        DefaultRouteError.reset((CamelContext)this, routeId);
        HashMap<String, Set<Endpoint>> endpointsInUse = new HashMap<String, Set<Endpoint>>();
        for (Map.Entry<String, BaseRouteService> entry : this.routeServices.entrySet()) {
            endpointsInUse.put(entry.getKey(), entry.getValue().gatherEndpoints());
        }
        BaseRouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            if (this.getRouteStatus(routeId).isStopped()) {
                try {
                    routeService.setRemovingRoutes(true);
                    this.shutdownRouteService(routeService);
                    this.routeServices.remove(routeId);
                    this.routeStartupOrder.removeIf(order -> order.getRoute().getId().equals(routeId));
                    LinkedHashSet<Endpoint> toRemove = new LinkedHashSet<Endpoint>();
                    for (Endpoint endpoint : (Set)endpointsInUse.get(routeId)) {
                        int count = 0;
                        for (Set endpoints : endpointsInUse.values()) {
                            if (!endpoints.contains(endpoint)) continue;
                            ++count;
                        }
                        if (count > true) continue;
                        toRemove.add(endpoint);
                    }
                    for (Endpoint endpoint : toRemove) {
                        this.log.debug("Removing: {} which was only in use by route: {}", (Object)endpoint, (Object)routeId);
                        this.removeEndpoint(endpoint);
                    }
                }
                catch (Exception e) {
                    DefaultRouteError.set((CamelContext)this, routeId, RouteError.Phase.REMOVE, e);
                    throw e;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void suspendRoute(String routeId) throws Exception {
        this.suspendRoute(routeId, this.getShutdownStrategy().getTimeout(), this.getShutdownStrategy().getTimeUnit());
    }

    public synchronized void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        DefaultRouteError.reset((CamelContext)this, routeId);
        try {
            if (!this.routeSupportsSuspension(routeId)) {
                this.stopRoute(routeId, timeout, timeUnit);
                return;
            }
            BaseRouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                ArrayList<DefaultRouteStartupOrder> routes = new ArrayList<DefaultRouteStartupOrder>(1);
                Route route = routeService.getRoute();
                DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, route, routeService);
                routes.add(order);
                this.getShutdownStrategy().suspend((CamelContext)this, routes, timeout, timeUnit);
                this.suspendRouteService(routeService);
                if (route instanceof SuspendableService) {
                    ((SuspendableService)route).suspend();
                }
            }
        }
        catch (Exception e) {
            DefaultRouteError.set((CamelContext)this, routeId, RouteError.Phase.SUSPEND, e);
            throw e;
        }
    }

    public void addService(Object object) throws Exception {
        this.addService(object, true);
    }

    public void addService(Object object, boolean stopOnShutdown) throws Exception {
        this.addService(object, stopOnShutdown, false);
    }

    public void addService(Object object, boolean stopOnShutdown, boolean forceStart) throws Exception {
        this.internalAddService(object, stopOnShutdown, forceStart);
    }

    protected <T> T doAddService(T object) {
        return this.doAddService(object, true);
    }

    protected <T> T doAddService(T object, boolean stopOnShutdown) {
        return this.doAddService(object, stopOnShutdown, true);
    }

    protected <T> T doAddService(T object, boolean stopOnShutdown, boolean forceStart) {
        try {
            this.internalAddService(object, stopOnShutdown, forceStart);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return object;
    }

    private void internalAddService(Object object, boolean stopOnShutdown, boolean forceStart) throws Exception {
        if (object instanceof CamelContextAware) {
            CamelContextAware aware = (CamelContextAware)object;
            aware.setCamelContext((CamelContext)this);
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                if (service instanceof Endpoint) {
                    strategy.onEndpointAdd((Endpoint)service);
                    continue;
                }
                strategy.onServiceAdd((CamelContext)this, service, null);
            }
            if (!forceStart) {
                this.deferStartService(object, stopOnShutdown);
            } else {
                boolean singleton = true;
                if (object instanceof IsSingleton) {
                    singleton = ((IsSingleton)service).isSingleton();
                }
                if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.hasService(service)) {
                    boolean tc;
                    boolean bl = tc = service instanceof TypeConverter || service instanceof TypeConverterRegistry;
                    if (!tc) {
                        this.servicesToStop.add(service);
                    }
                }
                ServiceHelper.startService((Object)service);
            }
        }
    }

    public boolean removeService(Object object) throws Exception {
        if (object instanceof Endpoint) {
            this.removeEndpoint((Endpoint)object);
            return true;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onServiceRemove((CamelContext)this, service, null);
            }
            return this.servicesToStop.remove(service);
        }
        return false;
    }

    public boolean hasService(Object object) {
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.servicesToStop.contains(service);
        }
        return false;
    }

    public <T> T hasService(Class<T> type) {
        for (Service service : this.servicesToStop) {
            if (!type.isInstance(service)) continue;
            return type.cast(service);
        }
        return null;
    }

    public <T> Set<T> hasServices(Class<T> type) {
        HashSet<Service> set = new HashSet<Service>();
        for (Service service : this.servicesToStop) {
            if (!type.isInstance(service)) continue;
            set.add(service);
        }
        return set;
    }

    public void deferStartService(Object object, boolean stopOnShutdown) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            boolean singleton = true;
            if (object instanceof IsSingleton) {
                singleton = ((IsSingleton)service).isSingleton();
            }
            if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.hasService(service)) {
                this.servicesToStop.add(service);
            }
            if (this.isStarted()) {
                ServiceHelper.startService((Object)service);
            } else {
                this.deferStartupListener.addService(service);
            }
        }
    }

    public void addStartupListener(StartupListener listener) throws Exception {
        if (this.isStarted()) {
            listener.onCamelContextStarted((CamelContext)this, true);
        } else {
            this.startupListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComponentParameterJsonSchema(String componentName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/component/");
        Class<?> clazz = finder.findClass(componentName).orElse(null);
        if (clazz == null) {
            Component existing = this.hasComponent(componentName);
            if (existing != null) {
                clazz = existing.getClass();
            } else {
                return null;
            }
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + componentName + ".json";
        ClassResolver resolver = this.getClassResolver();
        InputStream inputStream = resolver.loadResourceAsStream(path);
        this.log.debug("Loading component JSON Schema for: {} using class resolver: {} -> {}", new Object[]{componentName, resolver, inputStream});
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        if ("ActiveMQComponent".equals(clazz.getSimpleName())) {
            return this.getComponentParameterJsonSchema("jms");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataFormatParameterJsonSchema(String dataFormatName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/dataformat/");
        Class clazz = finder.findClass(dataFormatName).orElse(null);
        if (clazz == null) {
            return null;
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + dataFormatName + ".json";
        ClassResolver resolver = this.getClassResolver();
        InputStream inputStream = resolver.loadResourceAsStream(path);
        this.log.debug("Loading dataformat JSON Schema for: {} using class resolver: {} -> {}", new Object[]{dataFormatName, resolver, inputStream});
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguageParameterJsonSchema(String languageName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/language/");
        Class clazz = finder.findClass(languageName).orElse(null);
        if (clazz == null) {
            return null;
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + languageName + ".json";
        ClassResolver resolver = this.getClassResolver();
        InputStream inputStream = resolver.loadResourceAsStream(path);
        this.log.debug("Loading language JSON Schema for: {} using class resolver: {} -> {}", new Object[]{languageName, resolver, inputStream});
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEipParameterJsonSchema(String eipName) throws IOException {
        String[] subPackages;
        for (String sub : subPackages = new String[]{"", "/config", "/dataformat", "/language", "/loadbalancer", "/rest"}) {
            String path = "org/apache/camel/model/" + sub + "/" + eipName + ".json";
            ClassResolver resolver = this.getClassResolver();
            InputStream inputStream = resolver.loadResourceAsStream(path);
            if (inputStream == null) continue;
            this.log.debug("Loading eip JSON Schema for: {} using class resolver: {} -> {}", new Object[]{eipName, resolver, inputStream});
            try {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language resolveLanguage(String language) {
        Language answer;
        Map<String, Language> map = this.languages;
        synchronized (map) {
            boolean singleton;
            answer = this.languages.get(language);
            if (answer instanceof IsSingleton && (singleton = ((IsSingleton)answer).isSingleton())) {
                return answer;
            }
            answer = this.getLanguageResolver().resolveLanguage(language, (CamelContext)this);
            if (answer != null) {
                if (answer instanceof CamelContextAware) {
                    ((CamelContextAware)answer).setCamelContext((CamelContext)this);
                }
                if (answer instanceof Service) {
                    try {
                        this.startService((Service)answer);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                }
                this.languages.put(language, answer);
            }
        }
        return answer;
    }

    public String resolvePropertyPlaceholders(String text) {
        if (text != null && text.contains("{{")) {
            String answer = this.getPropertiesComponent().parseUri(text);
            this.log.debug("Resolved text: {} -> {}", (Object)text, (Object)answer);
            return answer;
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.typeConverter == null) {
                    this.setTypeConverter(this.createTypeConverter());
                }
            }
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = this.doAddService(typeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.typeConverterRegistry == null) {
                    this.setTypeConverterRegistry(this.createTypeConverterRegistry());
                }
            }
        }
        return this.typeConverterRegistry;
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = this.doAddService(typeConverterRegistry);
        if (typeConverterRegistry instanceof TypeConverter) {
            this.typeConverter = (TypeConverter)typeConverterRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector() {
        if (this.injector == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.injector == null) {
                    this.setInjector(this.createInjector());
                }
            }
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = this.doAddService(injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesComponent getPropertiesComponent() {
        if (this.propertiesComponent == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.propertiesComponent == null) {
                    this.setPropertiesComponent(this.createPropertiesComponent());
                }
            }
        }
        return this.propertiesComponent;
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = this.doAddService(propertiesComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelBeanPostProcessor getBeanPostProcessor() {
        if (this.beanPostProcessor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanPostProcessor == null) {
                    this.setBeanPostProcessor(this.createBeanPostProcessor());
                }
            }
        }
        return this.beanPostProcessor;
    }

    public void setBeanPostProcessor(CamelBeanPostProcessor beanPostProcessor) {
        this.beanPostProcessor = this.doAddService(beanPostProcessor);
    }

    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        return this.managementMBeanAssembler;
    }

    public void setManagementMBeanAssembler(ManagementMBeanAssembler managementMBeanAssembler) {
        this.managementMBeanAssembler = this.doAddService(managementMBeanAssembler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.componentResolver == null) {
                    this.setComponentResolver(this.createComponentResolver());
                }
            }
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = this.doAddService(componentResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageResolver getLanguageResolver() {
        if (this.languageResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.languageResolver == null) {
                    this.setLanguageResolver(this.createLanguageResolver());
                }
            }
        }
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = this.doAddService(languageResolver);
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry() {
        if (this.registry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registry == null) {
                    this.setRegistry(this.createRegistry());
                }
            }
        }
        return this.registry;
    }

    public <T> T getRegistry(Class<T> type) {
        Registry reg = this.getRegistry();
        if (type.isAssignableFrom(reg.getClass())) {
            return type.cast(reg);
        }
        return null;
    }

    public void setRegistry(Registry registry) {
        if (registry instanceof CamelContextAware) {
            ((CamelContextAware)registry).setCamelContext((CamelContext)this);
        }
        this.registry = registry;
    }

    public List<LifecycleStrategy> getLifecycleStrategies() {
        return this.lifecycleStrategies;
    }

    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.getLifecycleStrategies().add(lifecycleStrategy);
    }

    public void setupRoutes(boolean done) {
        if (done) {
            this.isSetupRoutes.remove();
        } else {
            this.isSetupRoutes.set(true);
        }
    }

    public RestConfiguration getRestConfiguration() {
        return this.restConfigurations.get("");
    }

    public void setRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfigurations.put("", restConfiguration);
    }

    public Collection<RestConfiguration> getRestConfigurations() {
        return this.restConfigurations.values();
    }

    public void addRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfigurations.put(restConfiguration.getComponent(), restConfiguration);
    }

    public RestConfiguration getRestConfiguration(String component, boolean defaultIfNotExist) {
        RestConfiguration config;
        if (component == null) {
            component = "";
        }
        if ((config = this.restConfigurations.get(component)) == null && defaultIfNotExist && ((config = this.getRestConfiguration()) == null || config.getComponent() != null && !config.getComponent().equals(component))) {
            config = new RestConfiguration();
            this.restConfigurations.put(component, config);
        }
        return config;
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    public List<RoutePolicyFactory> getRoutePolicyFactories() {
        return this.routePolicyFactories;
    }

    public void setRoutePolicyFactories(List<RoutePolicyFactory> routePolicyFactories) {
        this.routePolicyFactories = routePolicyFactories;
    }

    public void addRoutePolicyFactory(RoutePolicyFactory routePolicyFactory) {
        this.getRoutePolicyFactories().add(routePolicyFactory);
    }

    public Set<LogListener> getLogListeners() {
        return this.logListeners;
    }

    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    public Boolean isStreamCaching() {
        return this.streamCache;
    }

    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    public Boolean isTracing() {
        return this.trace;
    }

    public String getTracingPattern() {
        return this.tracePattern;
    }

    public void setTracingPattern(String tracePattern) {
        this.tracePattern = tracePattern;
    }

    public Boolean isBacklogTracing() {
        return this.backlogTrace;
    }

    public void setBacklogTracing(Boolean backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    public void setDebugging(Boolean debug) {
        this.debug = debug;
    }

    public Boolean isDebugging() {
        return this.debug;
    }

    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    public Boolean isMessageHistory() {
        return this.messageHistory;
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public Boolean isLogMask() {
        return this.logMask != null && this.logMask != false;
    }

    public Boolean isLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public Long getDelayer() {
        return this.delay;
    }

    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    public ProducerTemplate createProducerTemplate() {
        return this.createProducerTemplate(0);
    }

    public ProducerTemplate createProducerTemplate(int maximumCacheSize) {
        DefaultProducerTemplate answer = new DefaultProducerTemplate((CamelContext)this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService((Service)answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public FluentProducerTemplate createFluentProducerTemplate() {
        return this.createFluentProducerTemplate(0);
    }

    public FluentProducerTemplate createFluentProducerTemplate(int maximumCacheSize) {
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate((CamelContext)this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService((Service)answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public ConsumerTemplate createConsumerTemplate() {
        return this.createConsumerTemplate(0);
    }

    public ConsumerTemplate createConsumerTemplate(int maximumCacheSize) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate((CamelContext)this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService((Service)answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getErrorHandlerExecutorService() {
        if (this.errorHandlerExecutorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.errorHandlerExecutorService == null) {
                    this.errorHandlerExecutorService = this.createErrorHandlerExecutorService();
                }
            }
        }
        return this.errorHandlerExecutorService;
    }

    protected ScheduledExecutorService createErrorHandlerExecutorService() {
        return this.getExecutorServiceManager().newDefaultScheduledThreadPool((Object)"ErrorHandlerRedeliveryThreadPool", "ErrorHandlerRedeliveryTask");
    }

    public void setErrorHandlerExecutorService(ScheduledExecutorService errorHandlerExecutorService) {
        this.errorHandlerExecutorService = errorHandlerExecutorService;
    }

    public void setProducerServicePool(ServicePool<Producer> producerServicePool) {
        this.producerServicePool = this.doAddService((Object)producerServicePool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicePool<Producer> getProducerServicePool() {
        if (this.producerServicePool == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.producerServicePool == null) {
                    this.setProducerServicePool(this.createProducerServicePool());
                }
            }
        }
        return this.producerServicePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicePool<PollingConsumer> getPollingConsumerServicePool() {
        if (this.pollingConsumerServicePool == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pollingConsumerServicePool == null) {
                    this.setPollingConsumerServicePool(this.createPollingConsumerServicePool());
                }
            }
        }
        return this.pollingConsumerServicePool;
    }

    public void setPollingConsumerServicePool(ServicePool<PollingConsumer> pollingConsumerServicePool) {
        this.pollingConsumerServicePool = this.doAddService((Object)pollingConsumerServicePool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitOfWorkFactory getUnitOfWorkFactory() {
        if (this.unitOfWorkFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.unitOfWorkFactory == null) {
                    this.setUnitOfWorkFactory(this.createUnitOfWorkFactory());
                }
            }
        }
        return this.unitOfWorkFactory;
    }

    public void setUnitOfWorkFactory(UnitOfWorkFactory unitOfWorkFactory) {
        this.unitOfWorkFactory = this.doAddService(unitOfWorkFactory);
    }

    public RuntimeEndpointRegistry getRuntimeEndpointRegistry() {
        return this.runtimeEndpointRegistry;
    }

    public void setRuntimeEndpointRegistry(RuntimeEndpointRegistry runtimeEndpointRegistry) {
        this.runtimeEndpointRegistry = this.doAddService(runtimeEndpointRegistry);
    }

    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration((double)delta);
    }

    public long getUptimeMillis() {
        if (this.startDate == null) {
            return 0L;
        }
        return new Date().getTime() - this.startDate.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this.version == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.version == null) {
                    this.version = this.doGetVersion();
                }
            }
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doGetVersion() {
        Package aPackage;
        String version;
        block6: {
            version = null;
            InputStream is = null;
            try {
                Properties p = new Properties();
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/org.apache.camel/camel-base/pom.properties");
                if (is != null) {
                    p.load(is);
                    version = p.getProperty("version", "");
                }
                if (is == null) break block6;
            }
            catch (Exception p) {
                if (is != null) {
                    IOHelper.close(is);
                }
                break block6;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                IOHelper.close(is);
                throw throwable;
            }
            IOHelper.close((Closeable)is);
        }
        if (version == null && (aPackage = ((Object)((Object)this)).getClass().getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version != null) return version;
        return "";
    }

    protected void doSuspend() throws Exception {
        EventHelper.notifyCamelContextSuspending((CamelContext)this);
        this.log.info("Apache Camel {} (CamelContext: {}) is suspending", (Object)this.getVersion(), (Object)this.getName());
        StopWatch watch = new StopWatch();
        for (Map.Entry<String, BaseRouteService> entry : this.getRouteServices().entrySet()) {
            if (!entry.getValue().getStatus().isStarted()) continue;
            this.suspendedRouteServices.put(entry.getKey(), entry.getValue());
        }
        ArrayList<DefaultRouteStartupOrder> orders = new ArrayList<DefaultRouteStartupOrder>();
        for (Map.Entry<String, BaseRouteService> entry : this.suspendedRouteServices.entrySet()) {
            Route route = entry.getValue().getRoute();
            Integer order = entry.getValue().getStartupOrder();
            if (order == null) {
                order = this.defaultRouteStartupOrder++;
            }
            orders.add(new DefaultRouteStartupOrder(order, route, entry.getValue()));
        }
        this.getShutdownStrategy().suspend((CamelContext)this, orders);
        for (BaseRouteService service : this.suspendedRouteServices.values()) {
            if (this.routeSupportsSuspension(service.getId())) {
                service.suspend();
                continue;
            }
            service.stop();
        }
        watch.taken();
        if (this.log.isInfoEnabled()) {
            this.log.info("Apache Camel {} (CamelContext: {}) is suspended in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration((double)watch.taken())});
        }
        EventHelper.notifyCamelContextSuspended((CamelContext)this);
    }

    protected void doResume() throws Exception {
        try {
            EventHelper.notifyCamelContextResuming((CamelContext)this);
            this.log.info("Apache Camel {} (CamelContext: {}) is resuming", (Object)this.getVersion(), (Object)this.getName());
            StopWatch watch = new StopWatch();
            this.doStartOrResumeRoutes(this.suspendedRouteServices, false, true, true, false);
            for (BaseRouteService service : this.suspendedRouteServices.values()) {
                if (this.routeSupportsSuspension(service.getId())) {
                    service.resume();
                    continue;
                }
                service.start();
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Resumed {} routes", (Object)this.suspendedRouteServices.size());
                this.log.info("Apache Camel {} (CamelContext: {}) resumed in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration((double)watch.taken())});
            }
            this.suspendedRouteServices.clear();
            EventHelper.notifyCamelContextResumed((CamelContext)this);
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextResumeFailed((CamelContext)this, (Throwable)e);
            throw e;
        }
    }

    public void start() {
        block31: {
            int started;
            try (MDCHelper mdcHelper = new MDCHelper();){
                this.init();
                this.vetoStarted.set(false);
                this.startDate = new Date();
                this.stopWatch.restart();
                this.log.info("Apache Camel {} (CamelContext: {}) is starting", (Object)this.getVersion(), (Object)this.getName());
                ServiceHelper.startService((Object)this.routeController);
                boolean bl = this.doNotStartRoutesOnFirstStart = !this.firstStartDone && this.isAutoStartup() == false;
                if (this.firstStartDone && !this.isAutoStartup().booleanValue() && this.isStarted()) {
                    try {
                        this.doStartOrResumeRoutes(this.routeServices, true, true, false, true);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                    }
                }
                try {
                    this.firstStartDone = true;
                    super.start();
                }
                catch (Exception e) {
                    VetoCamelContextStartException veto = (VetoCamelContextStartException)ObjectHelper.getException(VetoCamelContextStartException.class, (Throwable)e);
                    if (veto != null) {
                        this.vetoStarted.set(true);
                        if (veto.isRethrowException()) {
                            throw e;
                        }
                        this.log.info("CamelContext ({}) vetoed to not start due {}", (Object)this.getName(), (Object)e.getMessage());
                        this.stop();
                        if (mdcHelper != null) {
                            if (var2_2 != null) {
                                try {
                                    mdcHelper.close();
                                }
                                catch (Throwable throwable) {
                                    var2_2.addSuppressed(throwable);
                                }
                            } else {
                                mdcHelper.close();
                            }
                        }
                        return;
                    }
                    this.log.error("Error starting CamelContext (" + this.getName() + ") due to exception thrown: " + e.getMessage(), (Throwable)e);
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
                if (!this.log.isInfoEnabled()) break block31;
                started = 0;
            }
            for (Route route : this.getRoutes()) {
                ServiceStatus status = this.getRouteStatus(route.getId());
                if (status == null || !status.isStarted()) continue;
                ++started;
            }
            Collection controlledRoutes = this.getRouteController().getControlledRoutes();
            if (controlledRoutes.isEmpty()) {
                this.log.info("Total {} routes, of which {} are started", (Object)this.getRoutes().size(), (Object)started);
            } else {
                this.log.info("Total {} routes, of which {} are started, and {} are managed by RouteController: {}", new Object[]{this.getRoutes().size(), started, controlledRoutes.size(), this.getRouteController().getClass().getName()});
            }
            this.log.info("Apache Camel {} (CamelContext: {}) started in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration((double)this.stopWatch.taken())});
        }
        EventHelper.notifyCamelContextStarted((CamelContext)this);
        for (StartupListener startup : this.startupListeners) {
            if (!(startup instanceof ExtendedStartupListener)) continue;
            try {
                ((ExtendedStartupListener)startup).onCamelContextFullyStarted((CamelContext)this, this.isStarted());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
    }

    public void stop() {
        try (MDCHelper mdcHelper = new MDCHelper();){
            super.stop();
        }
    }

    public void suspend() {
        try (MDCHelper mdcHelper = new MDCHelper();){
            super.suspend();
        }
    }

    public void resume() {
        try (MDCHelper mdcHelper = new MDCHelper();){
            super.resume();
        }
    }

    public void shutdown() {
        try (MDCHelper mdcHelper = new MDCHelper();){
            super.shutdown();
        }
    }

    protected synchronized void doStart() throws Exception {
        this.doWithDefinedClassLoader(() -> {
            try {
                this.doStartCamel();
            }
            catch (Exception e) {
                EventHelper.notifyCamelContextStartupFailed((CamelContext)this, (Throwable)e);
                throw e;
            }
        });
    }

    private <T extends Throwable> void doWithDefinedClassLoader(ThrowingRunnable<T> callable) throws T {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.applicationContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.applicationContextClassLoader);
            }
            callable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected void doStartCamel() throws Exception {
        if (this.globalOptions != null && !this.globalOptions.isEmpty()) {
            for (Map.Entry<String, String> entry : this.globalOptions.entrySet()) {
                String replaced;
                String string = entry.getKey();
                String value = entry.getValue();
                if (value == null || value.equals(replaced = this.resolvePropertyPlaceholders(value))) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Camel property with key {} replaced value from {} -> {}", new Object[]{string, value, replaced});
                }
                entry.setValue(replaced);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using ClassResolver={}, PackageScanClassResolver={}, ApplicationContextClassLoader={}, RouteController={}", new Object[]{this.getClassResolver(), this.getPackageScanClassResolver(), this.getApplicationContextClassLoader(), this.getRouteController()});
        }
        if (this.isStreamCaching().booleanValue()) {
            this.log.info("StreamCaching is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isBacklogTracing().booleanValue()) {
            this.log.info("Backlog Tracing is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isTracing().booleanValue()) {
            this.log.info("Tracing is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isUseMDCLogging().booleanValue()) {
            String pattern = this.getMDCLoggingKeysPattern();
            if (pattern != null) {
                this.log.info("MDC logging (keys-pattern: {}) is enabled on CamelContext: {}", (Object)pattern, (Object)this.getName());
            } else {
                this.log.info("MDC logging is enabled on CamelContext: {}", (Object)this.getName());
            }
        }
        if (this.getDelayer() != null && this.getDelayer() > 0L) {
            this.log.info("Delayer is enabled with: {} ms. on CamelContext: {}", (Object)this.getDelayer(), (Object)this.getName());
        }
        ManagementStrategy managementStrategy = this.getManagementStrategy();
        this.startService((Service)managementStrategy);
        ServiceHelper.startService(this.lifecycleStrategies);
        for (LifecycleStrategy lifecycleStrategy : this.lifecycleStrategies) {
            try {
                lifecycleStrategy.onContextStart((CamelContext)this);
            }
            catch (VetoCamelContextStartException e) {
                this.log.warn("Lifecycle strategy vetoed starting CamelContext ({}) due: {}", (Object)this.getName(), (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.warn("Lifecycle strategy " + lifecycleStrategy + " failed starting CamelContext ({}) due: {}", (Object)this.getName(), (Object)e.getMessage());
                throw e;
            }
        }
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            if (!(notifier instanceof Service)) continue;
            Service service = (Service)notifier;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onServiceAdd((CamelContext)this, service, null);
            }
            this.startService((Service)notifier);
        }
        EventHelper.notifyCamelContextStarting((CamelContext)this);
        this.forceLazyInitialization();
        BeanProxyFactory beanProxyFactory = new BeanProxyFactoryResolver().resolve((CamelContext)this);
        if (beanProxyFactory != null) {
            this.addService(beanProxyFactory);
        }
        this.endpoints = this.doAddService(this.createEndpointRegistry((Map<EndpointKey, Endpoint>)this.endpoints));
        this.transformerRegistry = this.doAddService(this.createTransformerRegistry());
        this.validatorRegistry = this.doAddService(this.createValidatorRegistry());
        if (this.runtimeEndpointRegistry == null && this.getManagementStrategy() != null && this.getManagementStrategy().getManagementAgent() != null) {
            boolean extended;
            Boolean isEnabled = this.getManagementStrategy().getManagementAgent().getEndpointRuntimeStatisticsEnabled();
            boolean isExtended = this.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended();
            boolean bl = extended = isExtended || isEnabled != null && isEnabled != false;
            if (extended) {
                this.runtimeEndpointRegistry = new DefaultRuntimeEndpointRegistry();
            }
        }
        if (this.runtimeEndpointRegistry != null) {
            if (this.runtimeEndpointRegistry instanceof EventNotifier && this.getManagementStrategy() != null) {
                this.getManagementStrategy().addEventNotifier((EventNotifier)this.runtimeEndpointRegistry);
            }
            this.addService(this.runtimeEndpointRegistry, true, true);
        }
        this.bindDataFormats();
        this.startServices(this.components.values());
        this.startRouteDefinitions();
        if (this.isUseDataType().booleanValue()) {
            this.log.info("Message DataType is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isStreamCachingInUse()) {
            this.getStreamCachingStrategy().setEnabled(true);
        } else {
            this.log.info("StreamCaching is not in use. If using streams then its recommended to enable stream caching. See more details at http://camel.apache.org/stream-caching.html");
        }
        if (this.isAllowUseOriginalMessage().booleanValue()) {
            this.log.debug("AllowUseOriginalMessage enabled because UseOriginalMessage is in use");
        }
        this.log.debug("Using HeadersMapFactory: {}", (Object)this.getHeadersMapFactory());
        if (!this.getHeadersMapFactory().isCaseInsensitive()) {
            this.log.info("HeadersMapFactory: {} is case-sensitive which can cause problems for protocols such as HTTP based, which rely on case-insensitive headers.", (Object)this.getHeadersMapFactory());
        }
        if (!this.getReactiveExecutor().getClass().getSimpleName().equals("DefaultReactiveExecutor")) {
            this.log.info("Using ReactiveExecutor: {}", (Object)this.getReactiveExecutor());
        } else {
            this.log.debug("Using ReactiveExecutor: {}", (Object)this.getReactiveExecutor());
        }
        if (this.doNotStartRoutesOnFirstStart) {
            this.log.debug("Skip starting routes as CamelContext has been configured with autoStartup=false");
        }
        EventHelper.notifyCamelContextRoutesStarting((CamelContext)this);
        this.doStartOrResumeRoutes(this.routeServices, true, !this.doNotStartRoutesOnFirstStart, false, true);
        EventHelper.notifyCamelContextRoutesStarted((CamelContext)this);
        long cacheCounter = this.getBeanIntrospection().getCachedClassesCounter();
        if (cacheCounter > 0L) {
            this.log.debug("Clearing BeanIntrospection cache with {} objects using during starting Camel", (Object)cacheCounter);
            this.getBeanIntrospection().clearCache();
        }
    }

    protected void startRouteDefinitions() throws Exception {
    }

    protected boolean isStreamCachingInUse() throws Exception {
        return this.isStreamCaching();
    }

    protected void bindDataFormats() throws Exception {
    }

    protected synchronized void doStop() throws Exception {
        this.stopWatch.restart();
        this.log.info("Apache Camel {} (CamelContext: {}) is shutting down", (Object)this.getVersion(), (Object)this.getName());
        EventHelper.notifyCamelContextStopping((CamelContext)this);
        EventHelper.notifyCamelContextRoutesStopping((CamelContext)this);
        ServiceHelper.stopAndShutdownService((Object)this.routeController);
        try {
            if (this.shutdownStrategy != null) {
                this.shutdownStrategy.shutdownForced((CamelContext)this, this.getRouteStartupOrder());
            }
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while shutting down routes. This exception will be ignored.", e);
        }
        this.shutdownServices(this.asyncProcessorAwaitManager);
        for (BaseRouteService baseRouteService : this.routeServices.values()) {
            boolean found = this.routeStartupOrder.stream().anyMatch(o -> o.getRoute().getId().equals(baseRouteService.getId()));
            if (found) continue;
            this.log.debug("Route: {} which failed to startup will be stopped", (Object)baseRouteService.getId());
            this.routeStartupOrder.add(this.doPrepareRouteToBeStarted(baseRouteService));
        }
        this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder).reversed());
        ArrayList<BaseRouteService> list = new ArrayList<BaseRouteService>();
        for (RouteStartupOrder startupOrder : this.routeStartupOrder) {
            DefaultRouteStartupOrder order = (DefaultRouteStartupOrder)startupOrder;
            BaseRouteService routeService = order.getRouteService();
            list.add(routeService);
        }
        this.shutdownServices(list, false);
        this.routeStartupOrder.clear();
        EventHelper.notifyCamelContextRoutesStopped((CamelContext)this);
        this.suspendedRouteServices.clear();
        for (Service service : this.servicesToStop) {
            if (!(service instanceof Consumer)) continue;
            this.shutdownServices(service);
        }
        if (this.errorHandlerExecutorService != null) {
            this.getExecutorServiceManager().shutdownNow((ExecutorService)this.errorHandlerExecutorService);
            this.errorHandlerExecutorService = null;
        }
        ServiceHelper.stopAndShutdownService((Object)this.getDebugger());
        this.shutdownServices(this.endpoints.values());
        this.endpoints.clear();
        this.shutdownServices(this.components.values());
        this.components.clear();
        this.shutdownServices(this.languages.values());
        this.languages.clear();
        try {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onContextStop((CamelContext)this);
            }
        }
        catch (Throwable throwable) {
            this.log.warn("Error occurred while stopping lifecycle strategies. This exception will be ignored.", throwable);
        }
        this.shutdownServices(this.servicesToStop);
        this.servicesToStop.clear();
        EventHelper.notifyCamelContextStopped((CamelContext)this);
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            this.shutdownServices(notifier);
        }
        this.shutdownServices(this.executorServiceManager);
        this.shutdownServices(this.reactiveExecutor);
        this.shutdownServices(this.managementStrategy);
        this.shutdownServices(this.managementMBeanAssembler);
        this.shutdownServices(this.lifecycleStrategies);
        ServiceHelper.stopService((Object)this.typeConverter);
        ServiceHelper.stopService((Object)this.typeConverterRegistry);
        this.forceStopLazyInitialization();
        if (this.log.isInfoEnabled()) {
            this.log.info("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") uptime {}", (Object)this.getUptime());
            this.log.info("Apache Camel {} (CamelContext: {}) is shutdown in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration((double)this.stopWatch.taken())});
        }
        this.startDate = null;
        CamelContextTracker.notifyContextDestroyed((CamelContext)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartOrResumeRoutes(Map<String, BaseRouteService> routeServices, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes) throws Exception {
        this.setStartingRoutes(true);
        try {
            LinkedHashMap<String, BaseRouteService> filtered = new LinkedHashMap<String, BaseRouteService>();
            for (Map.Entry<String, BaseRouteService> entry : routeServices.entrySet()) {
                boolean startable = false;
                Consumer consumer = entry.getValue().getRoute().getConsumer();
                if (consumer instanceof SuspendableService) {
                    startable = ((SuspendableService)consumer).isSuspended();
                }
                if (!startable && consumer instanceof StatefulService) {
                    startable = ((StatefulService)consumer).getStatus().isStartable();
                } else if (!startable) {
                    startable = entry.getValue().getStatus().isStartable();
                }
                if (!startable) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, filtered.values());
        }
        finally {
            this.setStartingRoutes(false);
        }
    }

    protected boolean routeSupportsSuspension(String routeId) {
        BaseRouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            return routeService.getRoute().supportsSuspension();
        }
        return false;
    }

    private void shutdownServices(Object service) {
        try {
            if (service instanceof Service) {
                ServiceHelper.stopAndShutdownService((Object)service);
            } else if (service instanceof Collection) {
                ServiceHelper.stopAndShutdownServices((Collection)((Collection)service));
            }
        }
        catch (Throwable e) {
            this.log.warn("Error occurred while shutting down service: " + service + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure((CamelContext)this, (Object)service, (Throwable)e);
        }
    }

    private void shutdownServices(Collection<?> services) {
        this.shutdownServices(services, true);
    }

    private void shutdownServices(Collection<?> services, boolean reverse) {
        Collection<?> list = services;
        if (reverse) {
            ArrayList reverseList = new ArrayList(services);
            Collections.reverse(reverseList);
            list = reverseList;
        }
        for (Object service : list) {
            this.shutdownServices(service);
        }
    }

    private void startService(Service service) throws Exception {
        if (service instanceof StartupListener) {
            StartupListener listener = (StartupListener)service;
            this.addStartupListener(listener);
        }
        if (service instanceof CamelContextAware) {
            CamelContextAware aware = (CamelContextAware)service;
            aware.setCamelContext((CamelContext)this);
        }
        service.start();
    }

    private void startServices(Collection<?> services) throws Exception {
        for (Object element : services) {
            if (!(element instanceof Service)) continue;
            this.startService((Service)element);
        }
    }

    private void stopServices(Object service) throws Exception {
        try {
            ServiceHelper.stopService((Object)service);
        }
        catch (Exception e) {
            EventHelper.notifyServiceStopFailure((CamelContext)this, (Object)service, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startRouteService(BaseRouteService routeService, boolean addingRoutes) throws Exception {
        boolean alreadyStartingRoutes = this.isStartingRoutes();
        if (!alreadyStartingRoutes) {
            this.setStartingRoutes(true);
        }
        try {
            if (routeService.getStatus().isSuspended()) {
                this.resumeRouteService(routeService);
            } else {
                this.routeServices.put(routeService.getId(), routeService);
                if (this.shouldStartRoutes()) {
                    this.safelyStartRouteServices(true, true, true, false, addingRoutes, routeService);
                    boolean autoStartup = routeService.isAutoStartup();
                    if (!addingRoutes || autoStartup) {
                        routeService.start();
                    }
                }
            }
        }
        finally {
            if (!alreadyStartingRoutes) {
                this.setStartingRoutes(false);
            }
        }
    }

    protected synchronized void resumeRouteService(BaseRouteService routeService) throws Exception {
        if (!routeService.getStatus().isSuspended()) {
            this.startRouteService(routeService, false);
        } else if (this.shouldStartRoutes()) {
            this.safelyStartRouteServices(true, false, true, true, false, routeService);
            routeService.resume();
        }
    }

    protected synchronized void stopRouteService(BaseRouteService routeService, boolean removingRoutes) throws Exception {
        routeService.setRemovingRoutes(removingRoutes);
        this.stopRouteService(routeService);
    }

    protected void logRouteState(Route route, String state) {
        if (this.log.isInfoEnabled()) {
            if (route.getConsumer() != null) {
                this.log.info("Route: {} is {}, was consuming from: {}", new Object[]{route.getId(), state, route.getConsumer().getEndpoint()});
            } else {
                this.log.info("Route: {} is {}.", (Object)route.getId(), (Object)state);
            }
        }
    }

    protected synchronized void stopRouteService(BaseRouteService routeService) throws Exception {
        routeService.stop();
        this.logRouteState(routeService.getRoute(), "stopped");
    }

    protected synchronized void shutdownRouteService(BaseRouteService routeService) throws Exception {
        routeService.shutdown();
        this.logRouteState(routeService.getRoute(), "shutdown and removed");
    }

    protected synchronized void suspendRouteService(BaseRouteService routeService) throws Exception {
        routeService.setRemovingRoutes(false);
        routeService.suspend();
        this.logRouteState(routeService.getRoute(), "suspended");
    }

    protected synchronized void safelyStartRouteServices(boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, Collection<BaseRouteService> routeServices) throws Exception {
        TreeMap<Integer, DefaultRouteStartupOrder> inputs = new TreeMap<Integer, DefaultRouteStartupOrder>();
        for (BaseRouteService routeService : routeServices) {
            DefaultRouteStartupOrder order = this.doPrepareRouteToBeStarted(routeService);
            if (checkClash) {
                this.doCheckStartupOrderClash(order, inputs);
            }
            inputs.put(order.getStartupOrder(), order);
        }
        this.doWarmUpRoutes(inputs, startConsumer);
        this.startupListeners.sort((Comparator<StartupListener>)OrderedComparator.get());
        for (StartupListener startup : this.startupListeners) {
            startup.onCamelContextStarted((CamelContext)this, this.isStarted());
        }
        ArrayList<StartupListener> backup = new ArrayList<StartupListener>(this.startupListeners);
        this.startupListeners.clear();
        if (startConsumer) {
            if (resumeConsumer) {
                this.doResumeRouteConsumers(inputs, addingRoutes);
            } else {
                this.doStartRouteConsumers(inputs, addingRoutes);
            }
        }
        this.startupListeners.sort((Comparator<StartupListener>)OrderedComparator.get());
        for (StartupListener startup : this.startupListeners) {
            startup.onCamelContextStarted((CamelContext)this, this.isStarted());
        }
        this.startupListeners.addAll(0, backup);
        inputs.clear();
    }

    protected synchronized void safelyStartRouteServices(boolean forceAutoStart, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, BaseRouteService ... routeServices) throws Exception {
        this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, Arrays.asList(routeServices));
    }

    private DefaultRouteStartupOrder doPrepareRouteToBeStarted(BaseRouteService routeService) {
        Integer startupOrder = routeService.getStartupOrder();
        if (startupOrder == null) {
            startupOrder = this.defaultRouteStartupOrder++;
        }
        Route route = routeService.getRoute();
        return new DefaultRouteStartupOrder(startupOrder, route, routeService);
    }

    private boolean doCheckStartupOrderClash(DefaultRouteStartupOrder answer, Map<Integer, DefaultRouteStartupOrder> inputs) throws FailedToStartRouteException {
        DefaultRouteStartupOrder other = inputs.get(answer.getStartupOrder());
        if (other != null && answer != other) {
            String otherId = other.getRoute().getId();
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        for (RouteStartupOrder order : this.routeStartupOrder) {
            String otherId = order.getRoute().getId();
            if (answer.getRoute().getId().equals(otherId) || answer.getStartupOrder() != order.getStartupOrder()) continue;
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        return true;
    }

    private void doWarmUpRoutes(Map<Integer, DefaultRouteStartupOrder> inputs, boolean autoStartup) throws FailedToStartRouteException {
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            BaseRouteService routeService = entry.getValue().getRouteService();
            this.log.debug("Warming up route id: {} having autoStartup={}", (Object)routeService.getId(), (Object)autoStartup);
            routeService.warmUp();
        }
    }

    private void doResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, true, addingRoutes);
    }

    private void doStartRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, false, addingRoutes);
    }

    private void doStartOrResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean resumeOnly, boolean addingRoute) throws Exception {
        ArrayList<Endpoint> routeInputs = new ArrayList<Endpoint>();
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            Integer order = entry.getKey();
            Route route = entry.getValue().getRoute();
            BaseRouteService routeService = entry.getValue().getRouteService();
            boolean autoStartup = routeService.isAutoStartup();
            if (addingRoute && !autoStartup) {
                this.log.info("Skipping starting of route {} as its configured with autoStartup=false", (Object)routeService.getId());
                continue;
            }
            for (Consumer consumer : routeService.getInputs().values()) {
                Endpoint endpoint = consumer.getEndpoint();
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, routeInputs)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                ArrayList<Endpoint> existingEndpoints = new ArrayList<Endpoint>();
                for (Route existingRoute : this.getRoutes()) {
                    if (route.getId().equals(existingRoute.getId())) continue;
                    Endpoint existing = existingRoute.getEndpoint();
                    ServiceStatus status = this.getRouteStatus(existingRoute.getId());
                    if (status == null || !status.isStarted() && !status.isStarting()) continue;
                    existingEndpoints.add(existing);
                }
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, existingEndpoints)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                this.log.debug("Route: {} >>> {}", (Object)route.getId(), (Object)route);
                if (resumeOnly) {
                    this.log.debug("Resuming consumer (order: {}) on route: {}", (Object)order, (Object)route.getId());
                } else {
                    this.log.debug("Starting consumer (order: {}) on route: {}", (Object)order, (Object)route.getId());
                }
                if (resumeOnly && route.supportsSuspension()) {
                    ServiceHelper.resumeService((Object)consumer);
                    this.log.info("Route: {} resumed and consuming from: {}", (Object)route.getId(), (Object)endpoint);
                } else {
                    for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                        strategy.onServiceAdd((CamelContext)this, (Service)consumer, route);
                    }
                    try {
                        this.startService((Service)consumer);
                        route.getProperties().remove("route.start.exception");
                    }
                    catch (Exception e) {
                        route.getProperties().put("route.start.exception", e);
                        throw e;
                    }
                    this.log.info("Route: {} started and consuming from: {}", (Object)route.getId(), (Object)endpoint);
                }
                routeInputs.add(endpoint);
                boolean found = false;
                for (RouteStartupOrder other : this.routeStartupOrder) {
                    if (!other.getRoute().getId().equals(route.getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.routeStartupOrder.add(entry.getValue());
            }
            if (resumeOnly) {
                routeService.resume();
                continue;
            }
            try {
                routeService.start();
                route.getProperties().remove("route.start.exception");
            }
            catch (Exception e) {
                route.getProperties().put("route.start.exception", e);
                throw e;
            }
        }
    }

    private boolean doCheckMultipleConsumerSupportClash(Endpoint endpoint, List<Endpoint> routeInputs) {
        boolean multipleConsumersSupported = false;
        if (endpoint instanceof MultipleConsumersSupport) {
            multipleConsumersSupported = ((MultipleConsumersSupport)endpoint).isMultipleConsumersSupported();
        }
        if (multipleConsumersSupported) {
            return true;
        }
        return !routeInputs.contains(endpoint);
    }

    protected void forceLazyInitialization() {
        if (this.initialization != Initialization.Lazy) {
            this.doStartStandardServices();
            if (this.initialization == Initialization.Eager) {
                this.doStartEagerServices();
            }
        }
    }

    protected void doStartStandardServices() {
        this.getVersion();
        this.getTypeConverter();
        this.getTypeConverterRegistry();
        this.getInjector();
        this.getRegistry();
        this.getLanguageResolver();
        this.getExecutorServiceManager();
        this.getInflightRepository();
        this.getAsyncProcessorAwaitManager();
        this.getShutdownStrategy();
        this.getPackageScanClassResolver();
        this.getProducerServicePool();
        this.getPollingConsumerServicePool();
        this.getRestRegistryFactory();
        this.getReactiveExecutor();
        this.getBeanIntrospection();
        this.getPropertiesComponent();
        if (this.isTypeConverterStatisticsEnabled() != null) {
            this.getTypeConverterRegistry().getStatistics().setStatisticsEnabled(this.isTypeConverterStatisticsEnabled().booleanValue());
        }
        this.resolveLanguage("simple");
    }

    protected void doStartEagerServices() {
        this.getFactoryFinderResolver();
        this.getDefaultFactoryFinder();
        this.getComponentResolver();
        this.getDataFormatResolver();
        this.getManagementStrategy();
        this.getHeadersMapFactory();
        this.getClassResolver();
        this.getNodeIdFactory();
        this.getProcessorFactory();
        this.getMessageHistoryFactory();
        this.getStreamCachingStrategy();
        this.getModelJAXBContextFactory();
        this.getUuidGenerator();
        this.getUnitOfWorkFactory();
        this.getRouteController();
        this.getBeanProxyFactory();
        this.getBeanProcessorFactory();
        this.getBeanPostProcessor();
    }

    protected void forceStopLazyInitialization() {
        this.injector = null;
        this.languageResolver = null;
        this.typeConverterRegistry = null;
        this.typeConverter = null;
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookupByName(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, (CamelContext)this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    public Map<String, String> getGlobalOptions() {
        return this.globalOptions;
    }

    public void setGlobalOptions(Map<String, String> globalOptions) {
        this.globalOptions = globalOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryFinder getDefaultFactoryFinder() {
        if (this.defaultFactoryFinder == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.defaultFactoryFinder == null) {
                    this.defaultFactoryFinder = this.getFactoryFinderResolver().resolveDefaultFactoryFinder(this.getClassResolver());
                }
            }
        }
        return this.defaultFactoryFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryFinderResolver getFactoryFinderResolver() {
        if (this.factoryFinderResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.factoryFinderResolver == null) {
                    this.factoryFinderResolver = this.createFactoryFinderResolver();
                }
            }
        }
        return this.factoryFinderResolver;
    }

    public void setFactoryFinderResolver(FactoryFinderResolver factoryFinderResolver) {
        this.factoryFinderResolver = this.doAddService(factoryFinderResolver);
    }

    public FactoryFinder getFactoryFinder(String path) throws NoFactoryAvailableException {
        return this.factories.computeIfAbsent(path, this::createFactoryFinder);
    }

    protected FactoryFinder createFactoryFinder(String path) {
        return this.getFactoryFinderResolver().resolveFactoryFinder(this.getClassResolver(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classResolver == null) {
                    this.setClassResolver(this.createClassResolver());
                }
            }
        }
        return this.classResolver;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = this.doAddService(classResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageScanClassResolver getPackageScanClassResolver() {
        if (this.packageScanClassResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.packageScanClassResolver == null) {
                    this.setPackageScanClassResolver(this.createPackageScanClassResolver());
                }
            }
        }
        return this.packageScanClassResolver;
    }

    public void setPackageScanClassResolver(PackageScanClassResolver packageScanClassResolver) {
        this.packageScanClassResolver = this.doAddService(packageScanClassResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageScanResourceResolver getPackageScanResourceResolver() {
        if (this.packageScanResourceResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.packageScanResourceResolver == null) {
                    this.setPackageScanResourceResolver(this.createPackageScanResourceResolver());
                }
            }
        }
        return this.packageScanResourceResolver;
    }

    public void setPackageScanResourceResolver(PackageScanResourceResolver packageScanResourceResolver) {
        this.packageScanResourceResolver = this.doAddService(packageScanResourceResolver);
    }

    public List<String> getComponentNames() {
        return new ArrayList<String>(this.components.keySet());
    }

    public List<String> getLanguageNames() {
        return new ArrayList<String>(this.languages.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelJAXBContextFactory getModelJAXBContextFactory() {
        if (this.modelJAXBContextFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.modelJAXBContextFactory == null) {
                    this.setModelJAXBContextFactory(this.createModelJAXBContextFactory());
                }
            }
        }
        return this.modelJAXBContextFactory;
    }

    public void setModelJAXBContextFactory(ModelJAXBContextFactory modelJAXBContextFactory) {
        this.modelJAXBContextFactory = this.doAddService(modelJAXBContextFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeIdFactory getNodeIdFactory() {
        if (this.nodeIdFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.nodeIdFactory == null) {
                    this.setNodeIdFactory(this.createNodeIdFactory());
                }
            }
        }
        return this.nodeIdFactory;
    }

    public void setNodeIdFactory(NodeIdFactory idFactory) {
        this.nodeIdFactory = this.doAddService(idFactory);
    }

    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public void disableJMX() {
        if (this.isNew()) {
            this.disableJMX = true;
        } else if (this.isInit()) {
            this.disableJMX = true;
            this.setupManagement(null);
        } else {
            throw new IllegalStateException("Disabling JMX can only be done when CamelContext has not been started");
        }
    }

    public boolean isJMXDisabled() {
        return this.disableJMX;
    }

    public void setupManagement(Map<String, Object> options) {
        DefaultManagementStrategyFactory factory = new DefaultManagementStrategyFactory();
        if (!this.isJMXDisabled()) {
            try {
                Object object;
                FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/management/");
                if (finder != null && (object = finder.newInstance("ManagementStrategyFactory").orElse(null)) instanceof ManagementStrategyFactory) {
                    factory = object;
                }
            }
            catch (Exception e) {
                this.log.warn("Cannot create JMX lifecycle strategy. Will fallback and disable JMX.", (Throwable)e);
            }
        }
        List notifiers = null;
        if (this.managementStrategy != null) {
            notifiers = this.managementStrategy.getEventNotifiers();
        }
        this.log.debug("Setting up management with factory: {}", (Object)factory);
        try {
            ManagementStrategy strategy = factory.create((CamelContext)this, options);
            if (notifiers != null) {
                notifiers.forEach(arg_0 -> ((ManagementStrategy)strategy).addEventNotifier(arg_0));
            }
            LifecycleStrategy lifecycle = factory.createLifecycle((CamelContext)this);
            factory.setupManagement((CamelContext)this, strategy, lifecycle);
        }
        catch (Exception e) {
            this.log.warn("Error setting up management due " + e.getMessage());
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InflightRepository getInflightRepository() {
        if (this.inflightRepository == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.inflightRepository == null) {
                    this.setInflightRepository(this.createInflightRepository());
                }
            }
        }
        return this.inflightRepository;
    }

    public void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = this.doAddService(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncProcessorAwaitManager getAsyncProcessorAwaitManager() {
        if (this.asyncProcessorAwaitManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.asyncProcessorAwaitManager == null) {
                    this.setAsyncProcessorAwaitManager(this.createAsyncProcessorAwaitManager());
                }
            }
        }
        return this.asyncProcessorAwaitManager;
    }

    public void setAsyncProcessorAwaitManager(AsyncProcessorAwaitManager asyncProcessorAwaitManager) {
        this.asyncProcessorAwaitManager = this.doAddService(asyncProcessorAwaitManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanIntrospection getBeanIntrospection() {
        if (this.beanIntrospection == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanIntrospection == null) {
                    this.setBeanIntrospection(this.createBeanIntrospection());
                }
            }
        }
        return this.beanIntrospection;
    }

    public void setBeanIntrospection(BeanIntrospection beanIntrospection) {
        this.beanIntrospection = this.doAddService(beanIntrospection);
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Boolean isAutoStartup() {
        return this.autoStartup != null && this.autoStartup != false;
    }

    public Boolean isLoadTypeConverters() {
        return this.loadTypeConverters != null && this.loadTypeConverters != false;
    }

    public void setLoadTypeConverters(Boolean loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    public Boolean isTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled != null && this.typeConverterStatisticsEnabled != false;
    }

    public void setTypeConverterStatisticsEnabled(Boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    public Boolean isUseMDCLogging() {
        return this.useMDCLogging != null && this.useMDCLogging != false;
    }

    public void setUseMDCLogging(Boolean useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    public String getMDCLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    public void setMDCLoggingKeysPattern(String pattern) {
        this.mdcLoggingKeysPattern = pattern;
    }

    public Boolean isUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(Boolean useDataType) {
        this.useDataType = useDataType;
    }

    public Boolean isUseBreadcrumb() {
        return this.useBreadcrumb != null && this.useBreadcrumb != false;
    }

    public void setUseBreadcrumb(Boolean useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        this.applicationContextClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFormatResolver getDataFormatResolver() {
        if (this.dataFormatResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.dataFormatResolver == null) {
                    this.setDataFormatResolver(this.createDataFormatResolver());
                }
            }
        }
        return this.dataFormatResolver;
    }

    public void setDataFormatResolver(DataFormatResolver dataFormatResolver) {
        this.dataFormatResolver = this.doAddService(dataFormatResolver);
    }

    public DataFormat resolveDataFormat(String name) {
        DataFormat answer = this.getDataFormatResolver().resolveDataFormat(name, (CamelContext)this);
        if (answer instanceof CamelContextAware) {
            ((CamelContextAware)answer).setCamelContext((CamelContext)this);
        }
        return answer;
    }

    public DataFormat createDataFormat(String name) {
        DataFormat answer = this.getDataFormatResolver().createDataFormat(name, (CamelContext)this);
        if (answer instanceof CamelContextAware) {
            ((CamelContextAware)answer).setCamelContext((CamelContext)this);
        }
        return answer;
    }

    protected static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return (T)context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownStrategy getShutdownStrategy() {
        if (this.shutdownStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStrategy == null) {
                    this.setShutdownStrategy(this.createShutdownStrategy());
                }
            }
        }
        return this.shutdownStrategy;
    }

    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = this.doAddService(shutdownStrategy);
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    public Boolean isAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage != null && this.allowUseOriginalMessage != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorServiceManager getExecutorServiceManager() {
        if (this.executorServiceManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorServiceManager == null) {
                    this.setExecutorServiceManager(this.createExecutorServiceManager());
                }
            }
        }
        return this.executorServiceManager;
    }

    public void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        this.executorServiceManager = this.doAddService(executorServiceManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorFactory getProcessorFactory() {
        if (this.processorFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.processorFactory == null) {
                    this.setProcessorFactory(this.createProcessorFactory());
                }
            }
        }
        return this.processorFactory;
    }

    public void setProcessorFactory(ProcessorFactory processorFactory) {
        this.processorFactory = this.doAddService(processorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageHistoryFactory getMessageHistoryFactory() {
        if (this.messageHistoryFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageHistoryFactory == null) {
                    this.setMessageHistoryFactory(this.createMessageHistoryFactory());
                }
            }
        }
        return this.messageHistoryFactory;
    }

    public void setMessageHistoryFactory(MessageHistoryFactory messageHistoryFactory) {
        this.messageHistoryFactory = this.doAddService(messageHistoryFactory);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(Debugger debugger) {
        if (this.isStartingOrStarted()) {
            throw new IllegalStateException("Can not set debugger on a started CamelContext");
        }
        this.debugger = this.doAddService(debugger);
        this.setDebugging(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer() {
        if (this.tracer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tracer == null) {
                    this.setTracer(this.createTracer());
                }
            }
        }
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
        this.setTracing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uuidGenerator == null) {
                    this.setUuidGenerator(this.createUuidGenerator());
                }
            }
        }
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = this.doAddService(uuidGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamCachingStrategy getStreamCachingStrategy() {
        if (this.streamCachingStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.streamCachingStrategy == null) {
                    this.setStreamCachingStrategy(this.createStreamCachingStrategy());
                }
            }
        }
        return this.streamCachingStrategy;
    }

    public void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        this.streamCachingStrategy = this.doAddService(streamCachingStrategy, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestRegistry getRestRegistry() {
        if (this.restRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restRegistry == null) {
                    this.setRestRegistry(this.createRestRegistry());
                }
            }
        }
        return this.restRegistry;
    }

    public void setRestRegistry(RestRegistry restRegistry) {
        this.restRegistry = this.doAddService(restRegistry);
    }

    protected RestRegistry createRestRegistry() {
        RestRegistryFactory factory = this.getRestRegistryFactory();
        if (factory == null) {
            throw new IllegalStateException("No RestRegistryFactory implementation found.  You need to add camel-rest to the classpath.");
        }
        return factory.createRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestRegistryFactory getRestRegistryFactory() {
        if (this.restRegistryFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restRegistryFactory == null) {
                    this.setRestRegistryFactory(this.createRestRegistryFactory());
                }
            }
        }
        return this.restRegistryFactory;
    }

    public void setRestRegistryFactory(RestRegistryFactory restRegistryFactory) {
        this.restRegistryFactory = this.doAddService(restRegistryFactory);
    }

    public String getGlobalOption(String key) {
        String value = this.getGlobalOptions().get(key);
        if (ObjectHelper.isNotEmpty((Object)value)) {
            try {
                value = this.resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error getting global option: " + key, (Throwable)e);
            }
        }
        return value;
    }

    public Transformer resolveTransformer(String scheme) {
        return this.transformerRegistry.resolveTransformer((Object)new TransformerKey(scheme));
    }

    public Transformer resolveTransformer(DataType from, DataType to) {
        return this.transformerRegistry.resolveTransformer((Object)new TransformerKey(from, to));
    }

    public TransformerRegistry<TransformerKey> getTransformerRegistry() {
        return this.transformerRegistry;
    }

    public Validator resolveValidator(DataType type) {
        return this.validatorRegistry.resolveValidator((Object)new ValidatorKey(type));
    }

    public ValidatorRegistry<ValidatorKey> getValidatorRegistry() {
        return this.validatorRegistry;
    }

    public void setSSLContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public SSLContextParameters getSSLContextParameters() {
        return this.sslContextParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeadersMapFactory getHeadersMapFactory() {
        if (this.headersMapFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.headersMapFactory == null) {
                    this.setHeadersMapFactory(this.createHeadersMapFactory());
                }
            }
        }
        return this.headersMapFactory;
    }

    public void setHeadersMapFactory(HeadersMapFactory headersMapFactory) {
        this.headersMapFactory = this.doAddService(headersMapFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactiveExecutor getReactiveExecutor() {
        if (this.reactiveExecutor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.reactiveExecutor == null) {
                    this.setReactiveExecutor(this.createReactiveExecutor());
                }
            }
        }
        return this.reactiveExecutor;
    }

    public void setReactiveExecutor(ReactiveExecutor reactiveExecutor) {
        this.reactiveExecutor = this.doAddService(reactiveExecutor, false);
    }

    public DeferServiceFactory getDeferServiceFactory() {
        return this.deferServiceFactory;
    }

    public AnnotationBasedProcessorFactory getAnnotationBasedProcessorFactory() {
        return this.annotationBasedProcessorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanProxyFactory getBeanProxyFactory() {
        if (this.beanProxyFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanProxyFactory == null) {
                    this.beanProxyFactory = this.createBeanProxyFactory();
                }
            }
        }
        return this.beanProxyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanProcessorFactory getBeanProcessorFactory() {
        if (this.beanProcessorFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanProcessorFactory == null) {
                    this.beanProcessorFactory = this.createBeanProcessorFactory();
                }
            }
        }
        return this.beanProcessorFactory;
    }

    protected Map<String, BaseRouteService> getRouteServices() {
        return this.routeServices;
    }

    public static void setContextCounter(int value) {
        DefaultCamelContextNameStrategy.setCounter(value);
        DefaultManagementNameStrategy.setCounter(value);
    }

    public String toString() {
        return "CamelContext(" + this.getName() + ")";
    }

    protected abstract ReactiveExecutor createReactiveExecutor();

    protected abstract StreamCachingStrategy createStreamCachingStrategy();

    protected abstract TypeConverter createTypeConverter();

    protected abstract TypeConverterRegistry createTypeConverterRegistry();

    protected abstract Injector createInjector();

    protected abstract PropertiesComponent createPropertiesComponent();

    protected abstract CamelBeanPostProcessor createBeanPostProcessor();

    protected abstract ComponentResolver createComponentResolver();

    protected abstract Registry createRegistry();

    protected abstract UuidGenerator createUuidGenerator();

    protected abstract ModelJAXBContextFactory createModelJAXBContextFactory();

    protected abstract NodeIdFactory createNodeIdFactory();

    protected abstract FactoryFinderResolver createFactoryFinderResolver();

    protected abstract ClassResolver createClassResolver();

    protected abstract ProcessorFactory createProcessorFactory();

    protected abstract DataFormatResolver createDataFormatResolver();

    protected abstract MessageHistoryFactory createMessageHistoryFactory();

    protected abstract InflightRepository createInflightRepository();

    protected abstract AsyncProcessorAwaitManager createAsyncProcessorAwaitManager();

    protected abstract RouteController createRouteController();

    protected abstract ShutdownStrategy createShutdownStrategy();

    protected abstract PackageScanClassResolver createPackageScanClassResolver();

    protected abstract PackageScanResourceResolver createPackageScanResourceResolver();

    protected abstract ExecutorServiceManager createExecutorServiceManager();

    protected abstract ServicePool<Producer> createProducerServicePool();

    protected abstract ServicePool<PollingConsumer> createPollingConsumerServicePool();

    protected abstract UnitOfWorkFactory createUnitOfWorkFactory();

    protected abstract CamelContextNameStrategy createCamelContextNameStrategy();

    protected abstract ManagementNameStrategy createManagementNameStrategy();

    protected abstract HeadersMapFactory createHeadersMapFactory();

    protected abstract BeanProxyFactory createBeanProxyFactory();

    protected abstract BeanProcessorFactory createBeanProcessorFactory();

    protected abstract BeanIntrospection createBeanIntrospection();

    protected abstract Tracer createTracer();

    protected abstract LanguageResolver createLanguageResolver();

    protected abstract RestRegistryFactory createRestRegistryFactory();

    protected abstract EndpointRegistry<EndpointKey> createEndpointRegistry(Map<EndpointKey, Endpoint> var1);

    protected abstract TransformerRegistry<TransformerKey> createTransformerRegistry() throws Exception;

    protected abstract ValidatorRegistry<ValidatorKey> createValidatorRegistry() throws Exception;

    class MDCHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;

        MDCHelper() {
            if (AbstractCamelContext.this.isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)AbstractCamelContext.this.getName());
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (AbstractCamelContext.this.isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
        }
    }

    public static enum Initialization {
        Eager,
        Default,
        Lazy;

    }
}

