/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class InterceptorToAsyncProcessorBridge
extends ServiceSupport
implements AsyncProcessor {
    private final AsyncProcessor interceptor;
    private volatile AsyncProcessor target;
    private volatile ThreadLocal<AsyncCallback> callback = new ThreadLocal();
    private volatile ThreadLocal<Boolean> interceptorDone = new ThreadLocal();

    public InterceptorToAsyncProcessorBridge(Processor interceptor) {
        this.interceptor = AsyncProcessorConverterHelper.convert((Processor)interceptor);
        this.target = AsyncProcessorConverterHelper.convert((Processor)this.target);
    }

    public void process(Exchange exchange) throws Exception {
        boolean done = this.interceptor.process(exchange, this.callback.get());
        this.interceptorDone.set(done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.callback.set(callback);
        try {
            boolean done = this.target.process(exchange, callback);
            if (this.interceptorDone.get() != null) {
                boolean bl = this.interceptorDone.get();
                return bl;
            }
            boolean bl = done;
            return bl;
        }
        finally {
            this.callback.remove();
            this.interceptorDone.remove();
        }
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
        this.process(exchange, (AsyncCallback)callback);
        return callback.getFuture();
    }

    public void setTarget(Processor target) {
        this.target = AsyncProcessorConverterHelper.convert((Processor)target);
    }

    public String toString() {
        return "AsyncBridge[" + this.interceptor.toString() + "]";
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.target, this.interceptor});
    }

    protected void doStop() throws Exception {
        this.callback.remove();
        this.interceptorDone.remove();
        ServiceHelper.stopService((Object[])new Object[]{this.interceptor, this.target});
    }
}

