/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnitOfWork
implements UnitOfWork,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUnitOfWork.class);
    private UnitOfWork parent;
    private String id;
    private CamelContext context;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private Set<Object> transactedBy;
    private final Deque<RouteContext> routeContextStack = new ArrayDeque<RouteContext>();
    private final transient Logger log;

    public DefaultUnitOfWork(Exchange exchange) {
        this(exchange, LOG);
    }

    protected DefaultUnitOfWork(Exchange exchange, Logger logger) {
        String breadcrumbId;
        this.log = logger;
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork created for ExchangeId: {} with {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        this.context = exchange.getContext();
        if (this.context.isAllowUseOriginalMessage().booleanValue()) {
            if (exchange.getIn().getClass().getName().equals("org.apache.camel.component.jms.JmsMessage")) {
                this.originalInMessage = new DefaultMessage(this.context);
                this.originalInMessage.setBody(exchange.getIn().getBody());
                this.originalInMessage.getHeaders().putAll(exchange.getIn().getHeaders());
            } else {
                this.originalInMessage = exchange.getIn().copy();
            }
            if (this.originalInMessage instanceof MessageSupport) {
                ((MessageSupport)this.originalInMessage).setExchange(exchange);
            }
        }
        if (exchange.getProperty("CamelCreatedTimestamp") == null) {
            exchange.setProperty("CamelCreatedTimestamp", (Object)new Date());
        }
        if (exchange.getContext().isUseBreadcrumb().booleanValue() && (breadcrumbId = (String)exchange.getIn().getHeader("breadcrumbId", String.class)) == null) {
            breadcrumbId = exchange.getExchangeId();
            exchange.getIn().setHeader("breadcrumbId", (Object)breadcrumbId);
        }
        if (exchange.getProperty("CamelExternalRedelivered") == null) {
            Boolean redelivered = exchange.isExternalRedelivered();
            if (redelivered == null) {
                redelivered = false;
            }
            exchange.setProperty("CamelExternalRedelivered", (Object)redelivered);
        }
        try {
            EventHelper.notifyExchangeCreated((CamelContext)exchange.getContext(), (Exchange)exchange);
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
        }
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().add(exchange);
        }
    }

    UnitOfWork newInstance(Exchange exchange) {
        return new DefaultUnitOfWork(exchange);
    }

    public void setParentUnitOfWork(UnitOfWork parentUnitOfWork) {
        this.parent = parentUnitOfWork;
    }

    public UnitOfWork createChildUnitOfWork(Exchange childExchange) {
        UnitOfWork answer = this.newInstance(childExchange);
        answer.setParentUnitOfWork((UnitOfWork)this);
        return answer;
    }

    public void start() {
        this.id = null;
    }

    public void stop() {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
        this.routeContextStack.clear();
        this.originalInMessage = null;
        this.parent = null;
        this.id = null;
    }

    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        this.log.trace("Adding synchronization {}", (Object)synchronization);
        this.synchronizations.add(synchronization);
    }

    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    public synchronized boolean containsSynchronization(Synchronization synchronization) {
        return this.synchronizations != null && this.synchronizations.contains(synchronization);
    }

    public void handoverSynchronization(Exchange target) {
        this.handoverSynchronization(target, null);
    }

    public void handoverSynchronization(Exchange target, Predicate<Synchronization> filter) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            if (synchronization instanceof SynchronizationVetoable) {
                SynchronizationVetoable veto = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover && (filter == null || filter.test(synchronization))) {
                this.log.trace("Handover synchronization {} to: {}", (Object)synchronization, (Object)target);
                target.addOnCompletion(synchronization);
                it.remove();
                continue;
            }
            this.log.trace("Handover not allow for synchronization {}", (Object)synchronization);
        }
    }

    public void done(Exchange exchange) {
        this.log.trace("UnitOfWork done for ExchangeId: {} with {}", (Object)exchange.getExchangeId(), (Object)exchange);
        boolean failed = exchange.isFailed();
        UnitOfWorkHelper.doneSynchronizations((Exchange)exchange, this.synchronizations, (Logger)this.log);
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().remove(exchange);
        }
        try {
            if (failed) {
                EventHelper.notifyExchangeFailed((CamelContext)exchange.getContext(), (Exchange)exchange);
            } else {
                EventHelper.notifyExchangeDone((CamelContext)exchange.getContext(), (Exchange)exchange);
            }
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
        }
    }

    public void beforeRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork beforeRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange.getExchangeId(), exchange});
        }
        UnitOfWorkHelper.beforeRouteSynchronizations((Route)route, (Exchange)exchange, this.synchronizations, (Logger)this.log);
    }

    public void afterRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork afterRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange.getExchangeId(), exchange});
        }
        UnitOfWorkHelper.afterRouteSynchronizations((Route)route, (Exchange)exchange, this.synchronizations, (Logger)this.log);
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.context.getUuidGenerator().generateUuid();
        }
        return this.id;
    }

    public Message getOriginalInMessage() {
        if (this.originalInMessage == null && !this.context.isAllowUseOriginalMessage().booleanValue()) {
            throw new IllegalStateException("AllowUseOriginalMessage is disabled. Cannot access the original message.");
        }
        return this.originalInMessage;
    }

    public boolean isTransacted() {
        return this.transactedBy != null && !this.transactedBy.isEmpty();
    }

    public boolean isTransactedBy(Object key) {
        return this.getTransactedBy().contains(key);
    }

    public void beginTransactedBy(Object key) {
        this.getTransactedBy().add(key);
    }

    public void endTransactedBy(Object key) {
        this.getTransactedBy().remove(key);
    }

    public RouteContext getRouteContext() {
        return this.routeContextStack.peek();
    }

    public void pushRouteContext(RouteContext routeContext) {
        this.routeContextStack.push(routeContext);
    }

    public RouteContext popRouteContext() {
        return this.routeContextStack.pollFirst();
    }

    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return callback;
    }

    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new LinkedHashSet<Object>();
        }
        return this.transactedBy;
    }

    public String toString() {
        return "DefaultUnitOfWork";
    }
}

