/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Component;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextEvents;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToStartComponentException;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.GlobalEndpointConfiguration;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupListener;
import org.apache.camel.StartupStep;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.TypeConverter;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.clock.Clock;
import org.apache.camel.clock.ContextClock;
import org.apache.camel.clock.EventClock;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.console.DevConsoleResolver;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.impl.engine.CustomizersLifecycleStrategy;
import org.apache.camel.impl.engine.DefaultAutowiredLifecycleStrategy;
import org.apache.camel.impl.engine.DefaultCamelContextExtension;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.impl.engine.DefaultGlobalEndpointConfiguration;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.impl.engine.DefaultRouteError;
import org.apache.camel.impl.engine.DefaultRouteStartupOrder;
import org.apache.camel.impl.engine.DefaultRuntimeEndpointRegistry;
import org.apache.camel.impl.engine.DefaultServiceBootstrapCloseable;
import org.apache.camel.impl.engine.InternalRouteStartupManager;
import org.apache.camel.impl.engine.InternalServiceManager;
import org.apache.camel.impl.engine.OnCamelContextLifecycleStrategy;
import org.apache.camel.impl.engine.ProvisionalEndpointRegistry;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.impl.engine.VersionHolder;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.spi.AnnotationScanTypeConverters;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DebuggerFactory;
import org.apache.camel.spi.DeferServiceFactory;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptEndpointFactory;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.spi.InternalProcessorFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.ModelineFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.PeriodTaskResolver;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RouteFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorKey;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResetableClock;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractCamelContext
extends BaseService
implements CamelContext,
CatalogCamelContext,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelContext.class);
    private final InternalServiceManager internalServiceManager;
    private final DefaultCamelContextExtension camelContextExtension = new DefaultCamelContextExtension(this);
    private final AtomicInteger endpointKeyCounter = new AtomicInteger();
    private final Set<EndpointStrategy> endpointStrategies = ConcurrentHashMap.newKeySet();
    private final GlobalEndpointConfiguration globalEndpointConfiguration = new DefaultGlobalEndpointConfiguration();
    private final Map<String, Component> components = new ConcurrentHashMap<String, Component>();
    private final Set<Route> routes = new LinkedHashSet<Route>();
    private final List<StartupListener> startupListeners = new CopyOnWriteArrayList<StartupListener>();
    private final Map<String, Language> languages = new ConcurrentHashMap<String, Language>();
    private final Map<String, DataFormat> dataformats = new ConcurrentHashMap<String, DataFormat>();
    private final List<LifecycleStrategy> lifecycleStrategies = new CopyOnWriteArrayList<LifecycleStrategy>();
    private final ThreadLocal<Boolean> isStartingRoutes = new ThreadLocal();
    private final ThreadLocal<Boolean> isLockModel = new ThreadLocal();
    private final Map<String, RouteService> routeServices = new LinkedHashMap<String, RouteService>();
    private final Map<String, RouteService> suspendedRouteServices = new LinkedHashMap<String, RouteService>();
    private final InternalRouteStartupManager internalRouteStartupManager = new InternalRouteStartupManager();
    private final List<RouteStartupOrder> routeStartupOrder = new ArrayList<RouteStartupOrder>();
    private final StopWatch stopWatch = new StopWatch(false);
    private final ThreadLocal<Set<String>> componentsInCreation = ThreadLocal.withInitial(HashSet::new);
    private final Lock routesLock = new ReentrantLock();
    private final Lock lock = new ReentrantLock();
    private VetoCamelContextStartException vetoed;
    private String managementName;
    private ClassLoader applicationContextClassLoader;
    private boolean autoCreateComponents = true;
    private VaultConfiguration vaultConfiguration = new VaultConfiguration();
    private final List<RoutePolicyFactory> routePolicyFactories = new ArrayList<RoutePolicyFactory>();
    private volatile boolean firstStartDone;
    private volatile boolean doNotStartRoutesOnFirstStart;
    private Boolean autoStartup = Boolean.TRUE;
    private Boolean backlogTrace = Boolean.FALSE;
    private Boolean backlogTraceStandby = Boolean.FALSE;
    private Boolean backlogTraceTemplates = Boolean.FALSE;
    private Boolean trace = Boolean.FALSE;
    private Boolean traceStandby = Boolean.FALSE;
    private Boolean traceTemplates = Boolean.FALSE;
    private String tracePattern;
    private String tracingLoggingFormat;
    private Boolean modeline = Boolean.FALSE;
    private Boolean debug = Boolean.FALSE;
    private Boolean debugStandby = Boolean.FALSE;
    private String debugBreakpoints;
    private Boolean messageHistory = Boolean.FALSE;
    private Boolean logMask = Boolean.FALSE;
    private Boolean logExhaustedMessageBody = Boolean.FALSE;
    private Boolean streamCache = Boolean.TRUE;
    private Boolean disableJMX = Boolean.FALSE;
    private Boolean loadTypeConverters = Boolean.FALSE;
    private Boolean loadHealthChecks = Boolean.FALSE;
    private Boolean devConsole = Boolean.FALSE;
    private Boolean sourceLocationEnabled = Boolean.FALSE;
    private Boolean typeConverterStatisticsEnabled = Boolean.FALSE;
    private String dumpRoutes;
    private Boolean useMDCLogging = Boolean.FALSE;
    private String mdcLoggingKeysPattern;
    private Boolean useDataType = Boolean.FALSE;
    private Boolean useBreadcrumb = Boolean.FALSE;
    private Boolean allowUseOriginalMessage = Boolean.FALSE;
    private Boolean caseInsensitiveHeaders = Boolean.TRUE;
    private Boolean autowiredEnabled = Boolean.TRUE;
    private Long delay;
    private Map<String, String> globalOptions = new HashMap<String, String>();
    private EndpointRegistry endpoints;
    private RuntimeEndpointRegistry runtimeEndpointRegistry;
    private ShutdownRoute shutdownRoute = ShutdownRoute.Default;
    private ShutdownRunningTask shutdownRunningTask = ShutdownRunningTask.CompleteCurrentTaskOnly;
    private Debugger debugger;
    private long buildTaken;
    private long initTaken;
    private final ContextClock clock = new ContextClock();
    private SSLContextParameters sslContextParameters;
    private StartupSummaryLevel startupSummaryLevel = StartupSummaryLevel.Default;

    protected AbstractCamelContext() {
        this(true);
    }

    protected AbstractCamelContext(Registry registry) {
        this();
        this.camelContextExtension.setRegistry(registry);
    }

    protected AbstractCamelContext(boolean build) {
        this.endpoints = new ProvisionalEndpointRegistry();
        this.lifecycleStrategies.add((LifecycleStrategy)new OnCamelContextLifecycleStrategy());
        this.lifecycleStrategies.add((LifecycleStrategy)new CustomizersLifecycleStrategy(this));
        this.lifecycleStrategies.add((LifecycleStrategy)new DefaultAutowiredLifecycleStrategy(this));
        this.camelContextExtension.addBootstrap(new DefaultServiceBootstrapCloseable(this));
        this.internalServiceManager = new InternalServiceManager(this.internalRouteStartupManager, this.startupListeners);
        this.initPlugins();
        if (build) {
            try {
                this.build();
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing CamelContext", e);
            }
        }
    }

    protected void initPlugins() {
        this.camelContextExtension.addContextPlugin(CamelBeanPostProcessor.class, this.createBeanPostProcessor());
        this.camelContextExtension.addContextPlugin(CamelDependencyInjectionAnnotationFactory.class, this.createDependencyInjectionAnnotationFactory());
        this.camelContextExtension.addContextPlugin(ComponentResolver.class, this.createComponentResolver());
        this.camelContextExtension.addContextPlugin(ComponentNameResolver.class, this.createComponentNameResolver());
        this.camelContextExtension.addContextPlugin(LanguageResolver.class, this.createLanguageResolver());
        this.camelContextExtension.addContextPlugin(ConfigurerResolver.class, this.createConfigurerResolver());
        this.camelContextExtension.addContextPlugin(UriFactoryResolver.class, this.createUriFactoryResolver());
        this.camelContextExtension.addContextPlugin(FactoryFinderResolver.class, this.createFactoryFinderResolver());
        this.camelContextExtension.addContextPlugin(PackageScanClassResolver.class, this.createPackageScanClassResolver());
        this.camelContextExtension.addContextPlugin(PackageScanResourceResolver.class, this.createPackageScanResourceResolver());
        this.camelContextExtension.addContextPlugin(VariableRepositoryFactory.class, this.createVariableRepositoryFactory());
        this.camelContextExtension.lazyAddContextPlugin(ModelineFactory.class, this::createModelineFactory);
        this.camelContextExtension.lazyAddContextPlugin(ModelJAXBContextFactory.class, this::createModelJAXBContextFactory);
        this.camelContextExtension.addContextPlugin(DataFormatResolver.class, this.createDataFormatResolver());
        this.camelContextExtension.lazyAddContextPlugin(PeriodTaskResolver.class, this::createPeriodTaskResolver);
        this.camelContextExtension.lazyAddContextPlugin(PeriodTaskScheduler.class, this::createPeriodTaskScheduler);
        this.camelContextExtension.lazyAddContextPlugin(HealthCheckResolver.class, this::createHealthCheckResolver);
        this.camelContextExtension.lazyAddContextPlugin(DevConsoleResolver.class, this::createDevConsoleResolver);
        this.camelContextExtension.lazyAddContextPlugin(ProcessorFactory.class, this::createProcessorFactory);
        this.camelContextExtension.lazyAddContextPlugin(InternalProcessorFactory.class, this::createInternalProcessorFactory);
        this.camelContextExtension.lazyAddContextPlugin(InterceptEndpointFactory.class, this::createInterceptEndpointFactory);
        this.camelContextExtension.lazyAddContextPlugin(RouteFactory.class, this::createRouteFactory);
        this.camelContextExtension.lazyAddContextPlugin(RoutesLoader.class, this::createRoutesLoader);
        this.camelContextExtension.lazyAddContextPlugin(AsyncProcessorAwaitManager.class, this::createAsyncProcessorAwaitManager);
        this.camelContextExtension.lazyAddContextPlugin(RuntimeCamelCatalog.class, this::createRuntimeCamelCatalog);
        this.camelContextExtension.lazyAddContextPlugin(RestBindingJaxbDataFormatFactory.class, this::createRestBindingJaxbDataFormatFactory);
        this.camelContextExtension.lazyAddContextPlugin(BeanProxyFactory.class, this::createBeanProxyFactory);
        this.camelContextExtension.lazyAddContextPlugin(UnitOfWorkFactory.class, this::createUnitOfWorkFactory);
        this.camelContextExtension.lazyAddContextPlugin(BeanIntrospection.class, this::createBeanIntrospection);
        this.camelContextExtension.lazyAddContextPlugin(ResourceLoader.class, this::createResourceLoader);
        this.camelContextExtension.lazyAddContextPlugin(BeanProcessorFactory.class, this::createBeanProcessorFactory);
        this.camelContextExtension.lazyAddContextPlugin(ModelToXMLDumper.class, this::createModelToXMLDumper);
        this.camelContextExtension.lazyAddContextPlugin(ModelToYAMLDumper.class, this::createModelToYAMLDumper);
        this.camelContextExtension.lazyAddContextPlugin(DeferServiceFactory.class, this::createDeferServiceFactory);
        this.camelContextExtension.lazyAddContextPlugin(AnnotationBasedProcessorFactory.class, this::createAnnotationBasedProcessorFactory);
        this.camelContextExtension.lazyAddContextPlugin(DumpRoutesStrategy.class, this::createDumpRoutesStrategy);
    }

    protected static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return (T)context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CamelContext getCamelContextReference() {
        return this;
    }

    protected boolean eagerCreateTypeConverter() {
        return true;
    }

    public boolean isVetoStarted() {
        return this.vetoed != null;
    }

    public CamelContextNameStrategy getNameStrategy() {
        return this.camelContextExtension.getNameStrategy();
    }

    public void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.camelContextExtension.setNameStrategy(nameStrategy);
    }

    public ManagementNameStrategy getManagementNameStrategy() {
        return this.camelContextExtension.getManagementNameStrategy();
    }

    public void setManagementNameStrategy(ManagementNameStrategy managementNameStrategy) {
        this.camelContextExtension.setManagementNameStrategy(managementNameStrategy);
    }

    public String getManagementName() {
        return this.managementName;
    }

    public void setManagementName(String managementName) {
        this.managementName = managementName;
    }

    public Component hasComponent(String componentName) {
        if (this.components.isEmpty()) {
            return null;
        }
        return this.components.get(componentName);
    }

    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull((Object)component, (String)"component");
        component.setCamelContext(this.getCamelContextReference());
        if (this.isStarted()) {
            ServiceHelper.startService((Service)component);
        } else {
            ServiceHelper.initService((Object)component);
        }
        Component oldValue = this.components.putIfAbsent(componentName, component);
        if (oldValue != null) {
            throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
        }
        this.postInitComponent(componentName, component);
    }

    private void postInitComponent(String componentName, Component component) {
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onComponentAdd(componentName, component);
        }
    }

    public Component getComponent(String name) {
        return this.getComponent(name, this.autoCreateComponents, true);
    }

    public Component getComponent(String name, boolean autoCreateComponents) {
        return this.getComponent(name, autoCreateComponents, true);
    }

    public Component getComponent(String name, boolean autoCreateComponents, boolean autoStart) {
        this.build();
        if (this.componentsInCreation.get().contains(name)) {
            throw new IllegalStateException("Circular dependency detected, the component " + name + " is already being created");
        }
        try {
            AtomicBoolean created = new AtomicBoolean();
            Component component = this.components.computeIfAbsent(name, comp -> {
                created.set(true);
                return this.initComponent(name, autoCreateComponents);
            });
            if (component != null && created.get() && autoStart && (this.isStarted() || this.isStarting())) {
                StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
                StartupStep step = startupStepRecorder.beginStep(Component.class, name, "Start Component");
                this.startService((Service)component);
                startupStepRecorder.endStep(step);
            }
            Component component2 = component;
            return component2;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot auto create component: " + name, (Throwable)e);
        }
        finally {
            this.componentsInCreation.get().remove(name);
        }
    }

    private Component initComponent(String name, boolean autoCreateComponents) {
        Component component = null;
        if (autoCreateComponents) {
            StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
            StartupStep step = startupStepRecorder.beginStep(Component.class, name, "Resolve Component");
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using ComponentResolver: {} to resolve component with name: {}", (Object)PluginHelper.getComponentResolver((ExtendedCamelContext)this.camelContextExtension), (Object)name);
                }
                this.componentsInCreation.get().add(name);
                component = ResolverHelper.lookupComponentInRegistryWithFallback((CamelContext)this.getCamelContextReference(), (String)name);
                if (component == null) {
                    component = PluginHelper.getComponentResolver((ExtendedCamelContext)this.camelContextExtension).resolveComponent(name, this.getCamelContextReference());
                }
                if (component != null) {
                    component.setCamelContext(this.getCamelContextReference());
                    ServiceHelper.buildService((Object)component);
                    this.postInitComponent(name, component);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot auto create component: " + name, (Throwable)e);
            }
            startupStepRecorder.endStep(step);
        }
        return component;
    }

    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        String message = AbstractCamelContext.invalidComponentMessage(name, componentType, component);
        throw new IllegalArgumentException(message);
    }

    private static <T extends Component> String invalidComponentMessage(String name, Class<T> componentType, Component component) {
        if (component == null) {
            return "Did not find component given by the name: " + name;
        }
        return "Found component of type: " + component.getClass() + " instead of expected: " + componentType;
    }

    public Component removeComponent(String componentName) {
        Component oldComponent = this.components.remove(componentName);
        if (oldComponent != null) {
            try {
                this.stopServices(oldComponent);
            }
            catch (Exception e) {
                LOG.warn("Error stopping component {}. This exception will be ignored.", (Object)oldComponent, (Object)e);
            }
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onComponentRemove(componentName, oldComponent);
            }
        }
        return oldComponent;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpoints;
    }

    public Collection<Endpoint> getEndpoints() {
        return this.endpoints.getReadOnlyValues();
    }

    public Endpoint hasEndpoint(String uri) {
        if (this.endpoints.isEmpty()) {
            return null;
        }
        return (Endpoint)this.endpoints.get((Object)this.getEndpointKey(uri));
    }

    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        this.startService((Service)endpoint);
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove((Object)this.getEndpointKey(uri));
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onEndpointAdd(endpoint);
        }
        this.addEndpointToRegistry(uri, endpoint);
        if (oldEndpoint != null && oldEndpoint != endpoint) {
            this.stopServices(oldEndpoint);
        }
        return oldEndpoint;
    }

    public void removeEndpoint(Endpoint endpoint) {
        Endpoint oldEndpoint = null;
        NormalizedEndpointUri oldKey = null;
        for (Map.Entry entry : this.endpoints.entrySet()) {
            if (endpoint != entry.getValue()) continue;
            oldKey = (NormalizedEndpointUri)entry.getKey();
            oldEndpoint = endpoint;
            break;
        }
        if (oldEndpoint != null) {
            this.endpoints.remove(oldKey);
            try {
                this.stopServices(oldEndpoint);
            }
            catch (Exception e) {
                LOG.warn("Error stopping endpoint {}. This exception will be ignored.", (Object)oldEndpoint, (Object)e);
            }
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointRemove(oldEndpoint);
            }
        }
    }

    public Collection<Endpoint> removeEndpoints(String uri) {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove((Object)this.getEndpointKey(uri));
        if (oldEndpoint != null) {
            answer.add(oldEndpoint);
            this.stopServices(oldEndpoint);
        } else {
            String decodeUri = URISupport.getDecodeQuery((String)uri);
            if (decodeUri != null) {
                oldEndpoint = (Endpoint)this.endpoints.remove((Object)this.getEndpointKey(decodeUri));
            }
            if (oldEndpoint != null) {
                answer.add(oldEndpoint);
                this.stopServices(oldEndpoint);
            } else {
                this.tryMatchingEndpoints(uri, answer);
            }
        }
        for (Endpoint endpoint : answer) {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointRemove(endpoint);
            }
        }
        return answer;
    }

    private void tryMatchingEndpoints(String uri, Collection<Endpoint> answer) {
        ArrayList<NormalizedEndpointUri> toRemove = new ArrayList<NormalizedEndpointUri>();
        for (Map.Entry entry : this.endpoints.entrySet()) {
            Endpoint oldEndpoint = (Endpoint)entry.getValue();
            if (!EndpointHelper.matchEndpoint((CamelContext)this, (String)oldEndpoint.getEndpointUri(), (String)uri)) continue;
            try {
                this.stopServices(oldEndpoint);
            }
            catch (Exception e) {
                LOG.warn("Error stopping endpoint {}. This exception will be ignored.", (Object)oldEndpoint, (Object)e);
            }
            answer.add(oldEndpoint);
            toRemove.add((NormalizedEndpointUri)entry.getKey());
        }
        for (NormalizedEndpointUri key : toRemove) {
            this.endpoints.remove((Object)key);
        }
    }

    public Endpoint getEndpoint(String uri) {
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        StartupStep step = null;
        if (!this.isStarted() && startupStepRecorder.isEnabled()) {
            String u = URISupport.sanitizeUri((String)uri);
            step = startupStepRecorder.beginStep(Endpoint.class, u, "Get Endpoint");
        }
        Endpoint answer = this.doGetEndpoint(uri, null, false, false);
        if (step != null) {
            startupStepRecorder.endStep(step);
        }
        return answer;
    }

    public Endpoint getEndpoint(String uri, Map<String, Object> parameters) {
        return this.doGetEndpoint(uri, parameters, false, false);
    }

    protected Endpoint doGetEndpoint(String uri, Map<String, Object> parameters, boolean normalized, boolean prototype) {
        this.build();
        StringHelper.notEmpty((String)uri, (String)"uri");
        LOG.trace("Getting endpoint with uri: {} and parameters: {}", (Object)uri, parameters);
        if (!normalized) {
            uri = URISupport.textBlockToSingleLine((String)uri);
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this, (String)uri);
        }
        String rawUri = uri;
        if (!normalized) {
            uri = EndpointHelper.normalizeEndpointUri((String)uri);
        }
        LOG.trace("Getting endpoint with raw uri: {}, normalized uri: {}", (Object)rawUri, (Object)uri);
        Endpoint answer = null;
        if (!prototype) {
            NormalizedUri key = NormalizedUri.newNormalizedUri((String)uri, (boolean)true);
            answer = (Endpoint)this.endpoints.get((Object)key);
        }
        if (answer == null) {
            try {
                String scheme = StringHelper.before((String)uri, (String)":");
                if (scheme == null) {
                    answer = (Endpoint)this.camelContextExtension.getRegistry().lookupByNameAndType(uri, Endpoint.class);
                    if (answer != null) {
                        return answer;
                    }
                    throw new NoSuchEndpointException(uri);
                }
                LOG.trace("Endpoint uri: {} is from component with name: {}", (Object)uri, (Object)scheme);
                Component component = this.getComponent(scheme);
                ServiceHelper.initService((Object)component);
                if (component != null) {
                    LOG.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component);
                    answer = component.createEndpoint(component.useRawUri() ? rawUri : uri, parameters);
                    if (answer != null && LOG.isDebugEnabled()) {
                        LOG.debug("{} converted to endpoint: {} by component: {}", new Object[]{URISupport.sanitizeUri((String)uri), answer, component});
                    }
                }
                if (answer == null) {
                    answer = this.createEndpoint(uri);
                    LOG.trace("No component to create endpoint from uri: {} fallback lookup in registry -> {}", (Object)uri, (Object)answer);
                }
                if (answer != null) {
                    if (!prototype) {
                        this.addService(answer);
                        answer = this.addEndpointToRegistry(uri, answer);
                    } else {
                        this.addPrototypeService(answer);
                        for (EndpointStrategy strategy : this.endpointStrategies) {
                            answer = strategy.registerEndpoint(uri, answer);
                        }
                    }
                }
            }
            catch (NoSuchEndpointException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        if (answer == null) {
            throw new NoSuchEndpointException(uri);
        }
        return answer;
    }

    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint == null) {
            throw new NoSuchEndpointException(name);
        }
        if (endpoint instanceof InterceptSendToEndpoint) {
            InterceptSendToEndpoint interceptSendToEndpoint = (InterceptSendToEndpoint)endpoint;
            endpoint = interceptSendToEndpoint.getOriginalEndpoint();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        StringHelper.notEmpty((String)uri, (String)"uri");
        ObjectHelper.notNull((Object)endpoint, (String)"endpoint");
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put((Object)this.getEndpointKey(uri, endpoint), (Object)endpoint);
        return endpoint;
    }

    protected NormalizedUri getEndpointKey(String uri) {
        return NormalizedUri.newNormalizedUri((String)uri, (boolean)false);
    }

    protected NormalizedUri getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint != null && !endpoint.isSingleton()) {
            int counter = this.endpointKeyCounter.incrementAndGet();
            return NormalizedUri.newNormalizedUri((String)(uri + ":" + counter), (boolean)false);
        }
        return NormalizedUri.newNormalizedUri((String)uri, (boolean)false);
    }

    public GlobalEndpointConfiguration getGlobalEndpointConfiguration() {
        return this.globalEndpointConfiguration;
    }

    public RouteController getRouteController() {
        return this.camelContextExtension.getRouteController();
    }

    public void setRouteController(RouteController routeController) {
        this.camelContextExtension.setRouteController(routeController);
    }

    public List<Route> getRoutes() {
        if (this.routes.isEmpty()) {
            return Collections.emptyList();
        }
        this.routesLock.lock();
        try {
            ArrayList<Route> arrayList = new ArrayList<Route>(this.routes);
            return arrayList;
        }
        finally {
            this.routesLock.unlock();
        }
    }

    public int getRoutesSize() {
        return this.routes.size();
    }

    public Route getRoute(String id) {
        if (id != null) {
            for (Route route : this.getRoutes()) {
                if (!route.getId().equals(id)) continue;
                return route;
            }
        }
        return null;
    }

    public Processor getProcessor(String id) {
        for (Route route : this.getRoutes()) {
            List list = route.filter(id);
            if (list.size() != 1) continue;
            return (Processor)list.get(0);
        }
        return null;
    }

    public <T extends Processor> T getProcessor(String id, Class<T> type) {
        Processor answer = this.getProcessor(id);
        if (answer != null) {
            return (T)((Processor)type.cast(answer));
        }
        return null;
    }

    public void addRoutes(RoutesBuilder builder) throws Exception {
        if (builder instanceof RouteConfigurationsBuilder) {
            RouteConfigurationsBuilder rcBuilder = (RouteConfigurationsBuilder)builder;
            this.addRoutesConfigurations(rcBuilder);
        }
        try (LifecycleHelper helper = new LifecycleHelper();){
            this.build();
            LOG.debug("Adding routes from builder: {}", (Object)builder);
            builder.addRoutesToCamelContext((CamelContext)this);
        }
    }

    public void addTemplatedRoutes(RoutesBuilder builder) throws Exception {
        try (LifecycleHelper helper = new LifecycleHelper();){
            this.build();
            LOG.debug("Adding templated routes from builder: {}", (Object)builder);
            builder.addTemplatedRoutesToCamelContext((CamelContext)this);
        }
    }

    public void addRoutesConfigurations(RouteConfigurationsBuilder builder) throws Exception {
        try (LifecycleHelper helper = new LifecycleHelper();){
            this.build();
            LOG.debug("Adding route configurations from builder: {}", (Object)builder);
            builder.addRouteConfigurationsToCamelContext((CamelContext)this);
        }
    }

    public ServiceStatus getRouteStatus(String key) {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    public boolean isStartingRoutes() {
        Boolean answer = this.isStartingRoutes.get();
        return answer != null && answer != false;
    }

    public void setStartingRoutes(boolean starting) {
        if (starting) {
            this.isStartingRoutes.set(true);
        } else {
            this.isStartingRoutes.remove();
        }
    }

    public boolean isLockModel() {
        Boolean answer = this.isLockModel.get();
        return answer != null && answer != false;
    }

    public void setLockModel(boolean lockModel) {
        if (lockModel) {
            this.isLockModel.set(true);
        } else {
            this.isLockModel.remove();
        }
    }

    public void startAllRoutes() throws Exception {
        this.internalRouteStartupManager.doStartOrResumeRoutes(this, this.routeServices, true, true, false, false);
    }

    private void doStopRoutes(RouteController controller, Comparator<RouteStartupOrder> comparator) throws Exception {
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(this.camelContextExtension.getRouteStartupOrder());
        routesOrdered.sort(comparator);
        for (RouteStartupOrder order : routesOrdered) {
            Route route = order.getRoute();
            boolean stopped = controller.getRouteStatus(route.getRouteId()).isStopped();
            if (stopped) continue;
            this.stopRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
        for (Route route : this.getRoutes()) {
            boolean stopped = controller.getRouteStatus(route.getRouteId()).isStopped();
            if (stopped) continue;
            this.stopRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
    }

    public void stopAllRoutes() throws Exception {
        RouteController controller = this.getRouteController();
        if (controller == null) {
            return;
        }
        Comparator<RouteStartupOrder> comparator = Comparator.comparingInt(RouteStartupOrder::getStartupOrder);
        ShutdownStrategy shutdownStrategy = this.camelContextExtension.getShutdownStrategy();
        if (shutdownStrategy == null || shutdownStrategy.isShutdownRoutesInReverseOrder()) {
            comparator = comparator.reversed();
        }
        this.doStopRoutes(controller, comparator);
        if (this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off) {
            this.logRouteStopSummary(LoggingLevel.INFO);
        }
    }

    public void removeAllRoutes() throws Exception {
        Comparator<RouteStartupOrder> comparator = Comparator.comparingInt(RouteStartupOrder::getStartupOrder);
        ShutdownStrategy shutdownStrategy = this.getShutdownStrategy();
        if (shutdownStrategy == null || shutdownStrategy.isShutdownRoutesInReverseOrder()) {
            comparator = comparator.reversed();
        }
        this.doStopRoutes(this.getRouteController(), comparator);
        this.logRouteStopSummary(LoggingLevel.DEBUG);
        for (Route route : this.getRoutes()) {
            this.removeRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRoute(String routeId) throws Exception {
        block5: {
            this.lock.lock();
            try {
                DefaultRouteError.reset(this, routeId);
                RouteService routeService = this.routeServices.get(routeId);
                if (routeService == null) break block5;
                try {
                    this.startRouteService(routeService, false);
                }
                catch (Exception e) {
                    DefaultRouteError.set(this, routeId, RouteError.Phase.START, e);
                    throw e;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRoute(String routeId) throws Exception {
        this.lock.lock();
        try {
            block8: {
                DefaultRouteError.reset(this, routeId);
                try {
                    if (this.routeSupportsSuspension(routeId)) break block8;
                    this.startRoute(routeId);
                    return;
                }
                catch (Exception e) {
                    DefaultRouteError.set(this, routeId, RouteError.Phase.RESUME, e);
                    throw e;
                }
            }
            RouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                this.resumeRouteService(routeService);
                Route route = this.getRoute(routeId);
                ServiceHelper.resumeService((Object)route);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout, LoggingLevel loggingLevel) throws Exception {
        this.lock.lock();
        try {
            DefaultRouteError.reset(this, routeId);
            RouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                try {
                    DefaultRouteStartupOrder route = new DefaultRouteStartupOrder(1, routeService.getRoute(), routeService);
                    boolean completed = this.camelContextExtension.getShutdownStrategy().shutdown((CamelContext)this, (RouteStartupOrder)route, timeout, timeUnit, abortAfterTimeout);
                    if (completed) {
                        this.stopRouteService(routeService, false, loggingLevel);
                    } else {
                        this.startRouteService(routeService, false);
                    }
                    boolean bl = completed;
                    return bl;
                }
                catch (Exception e) {
                    DefaultRouteError.set(this, routeId, RouteError.Phase.STOP, e);
                    throw e;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopRoute(String routeId) throws Exception {
        this.stopRoute(routeId, LoggingLevel.INFO);
    }

    public void stopRoute(String routeId, LoggingLevel loggingLevel) throws Exception {
        this.doShutdownRoute(routeId, this.getShutdownStrategy().getTimeout(), this.getShutdownStrategy().getTimeUnit(), false, loggingLevel);
    }

    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdownRoute(routeId, timeout, timeUnit, false, LoggingLevel.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdownRoute(String routeId, long timeout, TimeUnit timeUnit, boolean removingRoutes, LoggingLevel loggingLevel) throws Exception {
        block5: {
            this.lock.lock();
            try {
                DefaultRouteError.reset(this, routeId);
                RouteService routeService = this.routeServices.get(routeId);
                if (routeService == null) break block5;
                try {
                    ArrayList<DefaultRouteStartupOrder> routeList = new ArrayList<DefaultRouteStartupOrder>(1);
                    DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoute(), routeService);
                    routeList.add(order);
                    this.getShutdownStrategy().shutdown((CamelContext)this, routeList, timeout, timeUnit);
                    this.stopRouteService(routeService, removingRoutes, loggingLevel);
                }
                catch (Exception e) {
                    DefaultRouteError.set(this, routeId, removingRoutes ? RouteError.Phase.SHUTDOWN : RouteError.Phase.STOP, e);
                    throw e;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean removeRoute(String routeId) throws Exception {
        this.lock.lock();
        try {
            boolean bl = this.removeRoute(routeId, LoggingLevel.INFO);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeRoute(String routeId, LoggingLevel loggingLevel) throws Exception {
        this.lock.lock();
        try {
            DefaultRouteError.reset(this, routeId);
            HashMap<String, Set<Endpoint>> endpointsInUse = new HashMap<String, Set<Endpoint>>();
            for (Map.Entry<String, RouteService> entry : this.routeServices.entrySet()) {
                endpointsInUse.put(entry.getKey(), entry.getValue().gatherEndpoints());
            }
            RouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                if (this.getRouteStatus(routeId).isStopped()) {
                    try {
                        this.doRemove(routeId, loggingLevel, routeService, endpointsInUse);
                    }
                    catch (Exception e) {
                        DefaultRouteError.set(this, routeId, RouteError.Phase.REMOVE, e);
                        throw e;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRemove(String routeId, LoggingLevel loggingLevel, RouteService routeService, Map<String, Set<Endpoint>> endpointsInUse) {
        routeService.setRemovingRoutes(true);
        this.shutdownRouteService(routeService, loggingLevel);
        this.routeServices.remove(routeId);
        this.routeStartupOrder.removeIf(order -> order.getRoute().getId().equals(routeId));
        LinkedHashSet<Endpoint> toRemove = new LinkedHashSet<Endpoint>();
        for (Endpoint endpoint : endpointsInUse.get(routeId)) {
            int count = 0;
            for (Set<Endpoint> endpointSet : endpointsInUse.values()) {
                if (!endpointSet.contains(endpoint)) continue;
                ++count;
            }
            if (count > true) continue;
            toRemove.add(endpoint);
        }
        for (Endpoint endpoint : toRemove) {
            LOG.debug("Removing: {} which was only in use by route: {}", (Object)endpoint, (Object)routeId);
            this.removeEndpoint(endpoint);
        }
    }

    public void suspendRoute(String routeId) throws Exception {
        this.suspendRoute(routeId, this.getShutdownStrategy().getTimeout(), this.getShutdownStrategy().getTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.lock.lock();
        try {
            block9: {
                DefaultRouteError.reset(this, routeId);
                try {
                    if (this.routeSupportsSuspension(routeId)) break block9;
                    this.stopRoute(routeId, timeout, timeUnit);
                    return;
                }
                catch (Exception e) {
                    DefaultRouteError.set(this, routeId, RouteError.Phase.SUSPEND, e);
                    throw e;
                }
            }
            RouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                ArrayList<DefaultRouteStartupOrder> routeList = new ArrayList<DefaultRouteStartupOrder>(1);
                Route route = routeService.getRoute();
                DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, route, routeService);
                routeList.add(order);
                this.getShutdownStrategy().suspend((CamelContext)this, routeList, timeout, timeUnit);
                this.suspendRouteService(routeService);
                if (route instanceof SuspendableService) {
                    SuspendableService suspendableService = (SuspendableService)route;
                    suspendableService.suspend();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addService(Object object) throws Exception {
        this.addService(object, true);
    }

    public void addService(Object object, boolean stopOnShutdown) throws Exception {
        this.addService(object, stopOnShutdown, false);
    }

    public void addService(Object object, boolean stopOnShutdown, boolean forceStart) throws Exception {
        this.internalServiceManager.doAddService(this, object, stopOnShutdown, forceStart, true);
    }

    public void addPrototypeService(Object object) {
        this.internalServiceManager.addService(this, object, false, true, false);
    }

    public boolean removeService(Object object) throws Exception {
        if (object instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)object;
            this.removeEndpoint(endpoint);
            return true;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onServiceRemove((CamelContext)this, service, null);
            }
            return this.internalServiceManager.removeService(service);
        }
        return false;
    }

    public boolean hasService(Object object) {
        return this.internalServiceManager.hasService(object);
    }

    public <T> T hasService(Class<T> type) {
        return this.internalServiceManager.hasService(type);
    }

    public <T> Set<T> hasServices(Class<T> type) {
        return this.internalServiceManager.hasServices(type);
    }

    public Service hasService(Predicate<Service> filter) {
        return this.internalServiceManager.getServices().stream().filter(filter).findFirst().orElse(null);
    }

    public void deferStartService(Object object, boolean stopOnShutdown) {
        this.internalServiceManager.deferStartService(this, object, stopOnShutdown, false);
    }

    protected List<StartupListener> getStartupListeners() {
        return this.startupListeners;
    }

    public void addStartupListener(StartupListener listener) throws Exception {
        if (this.isStarted()) {
            listener.onCamelContextStarted((CamelContext)this, true);
        } else {
            this.startupListeners.add(listener);
        }
    }

    private static String toResourcePath(Package clazz, String languageName) {
        String packageName = clazz.getName();
        packageName = packageName.replace('.', '/');
        return "META-INF/" + packageName + "/" + languageName + ".json";
    }

    private String doLoadResource(String resourceName, String path, String resourceType) throws IOException {
        ClassResolver resolver = this.getClassResolver();
        try (InputStream inputStream = resolver.loadResourceAsStream(path);){
            LOG.debug("Loading {} JSON Schema for: {} using class resolver: {} -> {}", new Object[]{resourceType, resourceName, resolver, inputStream});
            if (inputStream != null) {
                String string = IOHelper.loadText((InputStream)inputStream);
                return string;
            }
        }
        return null;
    }

    public String getComponentParameterJsonSchema(String componentName) throws IOException {
        String path;
        String inputStream;
        FactoryFinder finder = this.camelContextExtension.getFactoryFinder("META-INF/services/org/apache/camel/component/");
        Class<?> clazz = finder.findClass(componentName).orElse(null);
        if (clazz == null) {
            Component existing = this.hasComponent(componentName);
            if (existing != null) {
                clazz = existing.getClass();
            } else {
                return null;
            }
        }
        if ((inputStream = this.doLoadResource(componentName, path = AbstractCamelContext.toResourcePath(clazz.getPackage(), componentName), "component")) != null) {
            return inputStream;
        }
        return null;
    }

    public String getDataFormatParameterJsonSchema(String dataFormatName) throws IOException {
        FactoryFinder finder = this.camelContextExtension.getFactoryFinder("META-INF/services/org/apache/camel/dataformat/");
        Class clazz = finder.findClass(dataFormatName).orElse(null);
        if (clazz == null) {
            return null;
        }
        String path = AbstractCamelContext.toResourcePath(clazz.getPackage(), dataFormatName);
        String inputStream = this.doLoadResource(dataFormatName, path, "dataformat");
        if (inputStream != null) {
            return inputStream;
        }
        return null;
    }

    public String getLanguageParameterJsonSchema(String languageName) throws IOException {
        FactoryFinder finder = this.camelContextExtension.getFactoryFinder("META-INF/services/org/apache/camel/language/");
        Class clazz = finder.findClass(languageName).orElse(null);
        if (clazz == null) {
            return null;
        }
        String path = AbstractCamelContext.toResourcePath(clazz.getPackage(), languageName);
        String inputStream = this.doLoadResource(languageName, path, "language");
        if (inputStream != null) {
            return inputStream;
        }
        return null;
    }

    public String getTransformerParameterJsonSchema(String transformerName) throws IOException {
        String name = this.sanitizeFileName(transformerName) + ".json";
        String path = "META-INF/services/org/apache/camel/transformer/" + name;
        String inputStream = this.doLoadResource(transformerName, path, "transformer");
        if (inputStream != null) {
            return inputStream;
        }
        return null;
    }

    public String getDevConsoleParameterJsonSchema(String devConsoleName) throws IOException {
        String name = this.sanitizeFileName(devConsoleName) + ".json";
        String path = "META-INF/services/org/apache/camel/dev-console/" + name;
        String inputStream = this.doLoadResource(devConsoleName, path, "console");
        if (inputStream != null) {
            return inputStream;
        }
        return null;
    }

    public String getPojoBeanParameterJsonSchema(String beanName) throws IOException {
        String name = this.sanitizeFileName(beanName) + ".json";
        String path = "META-INF/services/org/apache/camel/bean/" + name;
        return this.doLoadResource(beanName, path, "bean");
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^A-Za-z0-9-]", "-");
    }

    public String getEipParameterJsonSchema(String eipName) throws IOException {
        String[] subPackages;
        for (String sub : subPackages = new String[]{"", "cloud/", "config/", "dataformat/", "errorhandler/", "language/", "loadbalancer/", "rest/", "transformer/", "validator/"}) {
            String path = "META-INF/org/apache/camel/model/" + sub + eipName + ".json";
            String inputStream = this.doLoadResource(eipName, path, "eip");
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public Language resolveLanguage(String name) {
        LOG.debug("Resolving language: {}", (Object)name);
        return this.languages.computeIfAbsent(name, s -> this.doResolveLanguage(name));
    }

    private Language doResolveLanguage(String name) {
        CamelContext camelContext;
        Language language;
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        StartupStep step = null;
        if (!this.isStarted() && startupStepRecorder.isEnabled()) {
            step = startupStepRecorder.beginStep(Language.class, name, "Resolve Language");
        }
        if ((language = ResolverHelper.lookupLanguageInRegistryWithFallback((CamelContext)(camelContext = this.getCamelContextReference()), (String)name)) == null) {
            language = PluginHelper.getLanguageResolver((ExtendedCamelContext)this.camelContextExtension).resolveLanguage(name, camelContext);
        }
        if (language != null) {
            if (language instanceof Service) {
                Service service = (Service)language;
                try {
                    CamelContextAware.trySetCamelContext((Object)service, (CamelContext)camelContext);
                    ServiceHelper.initService((Object)service);
                    this.startService(service);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            CamelContextAware.trySetCamelContext((Object)language, (CamelContext)camelContext);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onLanguageCreated(name, language);
            }
        }
        if (step != null) {
            startupStepRecorder.endStep(step);
        }
        return language;
    }

    public String resolvePropertyPlaceholders(String text) {
        return this.camelContextExtension.resolvePropertyPlaceholders(text, false);
    }

    public Object getVariable(String name) {
        String id = StringHelper.before((String)name, (String)":", (String)"global");
        name = StringHelper.after((String)name, (String)":", (String)name);
        VariableRepository repo = this.camelContextExtension.getContextPlugin(VariableRepositoryFactory.class).getVariableRepository(id);
        if (repo != null) {
            return repo.getVariable(name);
        }
        return null;
    }

    public <T> T getVariable(String name, Class<T> type) {
        Object value = this.getVariable(name);
        if (value != null) {
            return (T)this.getTypeConverter().convertTo(type, value);
        }
        return null;
    }

    public void setVariable(String name, Object value) {
        String id = StringHelper.before((String)name, (String)":", (String)"global");
        name = StringHelper.after((String)name, (String)":", (String)name);
        VariableRepository repo = this.camelContextExtension.getContextPlugin(VariableRepositoryFactory.class).getVariableRepository(id);
        if (repo != null) {
            repo.setVariable(name, value);
        }
    }

    public TypeConverter getTypeConverter() {
        return this.camelContextExtension.getTypeConverter();
    }

    public TypeConverterRegistry getTypeConverterRegistry() {
        return this.camelContextExtension.getTypeConverterRegistry();
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.camelContextExtension.setTypeConverterRegistry(typeConverterRegistry);
    }

    public Injector getInjector() {
        return this.camelContextExtension.getInjector();
    }

    public void setInjector(Injector injector) {
        this.camelContextExtension.setInjector(injector);
    }

    public PropertiesComponent getPropertiesComponent() {
        return this.camelContextExtension.getPropertiesComponent();
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.camelContextExtension.setPropertiesComponent(propertiesComponent);
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    public <T> T getRegistry(Class<T> type) {
        Registry reg = this.camelContextExtension.getRegistry();
        if (type.isAssignableFrom(reg.getClass())) {
            return type.cast(reg);
        }
        return null;
    }

    public List<LifecycleStrategy> getLifecycleStrategies() {
        return this.lifecycleStrategies;
    }

    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        CamelContextAware.trySetCamelContext((Object)lifecycleStrategy, (CamelContext)this);
        if (!this.getLifecycleStrategies().contains(lifecycleStrategy)) {
            this.getLifecycleStrategies().add(lifecycleStrategy);
        }
    }

    public RestConfiguration getRestConfiguration() {
        return this.camelContextExtension.getRestConfiguration();
    }

    public void setRestConfiguration(RestConfiguration restConfiguration) {
        this.camelContextExtension.setRestConfiguration(restConfiguration);
    }

    public VaultConfiguration getVaultConfiguration() {
        return this.vaultConfiguration;
    }

    public void setVaultConfiguration(VaultConfiguration vaultConfiguration) {
        this.vaultConfiguration = vaultConfiguration;
    }

    public List<RoutePolicyFactory> getRoutePolicyFactories() {
        return this.routePolicyFactories;
    }

    public void addRoutePolicyFactory(RoutePolicyFactory routePolicyFactory) {
        CamelContextAware.trySetCamelContext((Object)routePolicyFactory, (CamelContext)this);
        if (!this.getRoutePolicyFactories().contains(routePolicyFactory)) {
            this.getRoutePolicyFactories().add(routePolicyFactory);
        }
    }

    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    public Boolean isStreamCaching() {
        return this.streamCache;
    }

    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    public Boolean isTracing() {
        return this.trace;
    }

    public String getTracingPattern() {
        return this.tracePattern;
    }

    public void setTracingPattern(String tracePattern) {
        this.tracePattern = tracePattern;
    }

    public String getTracingLoggingFormat() {
        return this.tracingLoggingFormat;
    }

    public void setTracingLoggingFormat(String format) {
        this.tracingLoggingFormat = format;
    }

    public Boolean isBacklogTracing() {
        return this.backlogTrace;
    }

    public void setBacklogTracing(Boolean backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    public void setDebugging(Boolean debug) {
        this.debug = debug;
    }

    public Boolean isDebugging() {
        return this.debug;
    }

    public void setDebugStandby(boolean debugStandby) {
        this.debugStandby = debugStandby;
    }

    public boolean isDebugStandby() {
        return this.debugStandby != null && this.debugStandby != false;
    }

    public void setDebuggingBreakpoints(String debugBreakpoints) {
        this.debugBreakpoints = debugBreakpoints;
    }

    public String getDebuggingBreakpoints() {
        return this.debugBreakpoints;
    }

    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    public Boolean isMessageHistory() {
        return this.messageHistory;
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public Boolean isLogMask() {
        return this.logMask != null && this.logMask != false;
    }

    public Boolean isLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public Long getDelayer() {
        return this.delay;
    }

    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    public ProducerTemplate createProducerTemplate() {
        return this.createProducerTemplate(0);
    }

    public ProducerTemplate createProducerTemplate(int maximumCacheSize) {
        DefaultProducerTemplate answer = new DefaultProducerTemplate(this.getCamelContextReference());
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService((Service)answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public FluentProducerTemplate createFluentProducerTemplate() {
        return this.createFluentProducerTemplate(0);
    }

    public FluentProducerTemplate createFluentProducerTemplate(int maximumCacheSize) {
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate(this.getCamelContextReference());
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService((Service)answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public ConsumerTemplate createConsumerTemplate() {
        return this.createConsumerTemplate(0);
    }

    public ConsumerTemplate createConsumerTemplate(int maximumCacheSize) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContextReference());
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService((Service)answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected ScheduledExecutorService createErrorHandlerExecutorService() {
        return this.getExecutorServiceManager().newDefaultScheduledThreadPool((Object)"ErrorHandlerRedeliveryThreadPool", "ErrorHandlerRedeliveryTask");
    }

    public RuntimeEndpointRegistry getRuntimeEndpointRegistry() {
        return this.runtimeEndpointRegistry;
    }

    public void setRuntimeEndpointRegistry(RuntimeEndpointRegistry runtimeEndpointRegistry) {
        this.runtimeEndpointRegistry = this.internalServiceManager.addService(this, runtimeEndpointRegistry);
    }

    public Duration getUptime() {
        EventClock<ContextEvents> contextClock = this.getClock();
        Clock startClock = contextClock.get((Enum)ContextEvents.START);
        if (startClock == null) {
            return Duration.ZERO;
        }
        return startClock.asDuration();
    }

    public String getVersion() {
        return VersionHolder.VERSION;
    }

    public EventClock<ContextEvents> getClock() {
        return this.clock;
    }

    protected void doSuspend() throws Exception {
        EventHelper.notifyCamelContextSuspending((CamelContext)this);
        LOG.info("Apache Camel {} ({}) is suspending", (Object)this.getVersion(), (Object)this.camelContextExtension.getName());
        StopWatch watch = new StopWatch();
        for (Map.Entry<String, RouteService> entry : this.getRouteServices().entrySet()) {
            if (!entry.getValue().getStatus().isStarted()) continue;
            this.suspendedRouteServices.put(entry.getKey(), entry.getValue());
        }
        ArrayList<DefaultRouteStartupOrder> orders = new ArrayList<DefaultRouteStartupOrder>();
        for (Map.Entry<String, RouteService> entry : this.suspendedRouteServices.entrySet()) {
            Route route = entry.getValue().getRoute();
            Integer order = route.getStartupOrder();
            if (order == null) {
                order = this.internalRouteStartupManager.incrementRouteStartupOrder();
            }
            orders.add(new DefaultRouteStartupOrder(order, route, entry.getValue()));
        }
        this.getShutdownStrategy().suspend((CamelContext)this, orders);
        for (RouteService service : this.suspendedRouteServices.values()) {
            if (this.routeSupportsSuspension(service.getId())) {
                service.suspend();
                continue;
            }
            service.stop();
        }
        watch.taken();
        if (LOG.isInfoEnabled()) {
            LOG.info("Apache Camel {} ({}) is suspended in {}", new Object[]{this.getVersion(), this.camelContextExtension.getName(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)});
        }
        EventHelper.notifyCamelContextSuspended((CamelContext)this);
    }

    protected void doResume() throws Exception {
        try {
            EventHelper.notifyCamelContextResuming((CamelContext)this);
            LOG.info("Apache Camel {} ({}) is resuming", (Object)this.getVersion(), (Object)this.camelContextExtension.getName());
            StopWatch watch = new StopWatch();
            this.internalRouteStartupManager.doStartOrResumeRoutes(this, this.suspendedRouteServices, false, true, true, false);
            for (RouteService service : this.suspendedRouteServices.values()) {
                if (this.routeSupportsSuspension(service.getId())) {
                    service.resume();
                    continue;
                }
                service.start();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Resumed {} routes", (Object)this.suspendedRouteServices.size());
                LOG.info("Apache Camel {} ({}) resumed in {}", new Object[]{this.getVersion(), this.camelContextExtension.getName(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)});
            }
            this.suspendedRouteServices.clear();
            EventHelper.notifyCamelContextResumed((CamelContext)this);
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextResumeFailed((CamelContext)this, (Throwable)e);
            throw e;
        }
    }

    protected AutoCloseable doLifecycleChange() {
        return new LifecycleHelper();
    }

    public void init() {
        try {
            super.init();
        }
        catch (RuntimeCamelException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof VetoCamelContextStartException) {
                VetoCamelContextStartException veto;
                this.vetoed = veto = (VetoCamelContextStartException)throwable;
            }
            throw e;
        }
        if (this.vetoed != null) {
            LOG.info("CamelContext ({}) vetoed to not initialize due to: {}", (Object)this.camelContextExtension.getName(), (Object)this.vetoed.getMessage());
            this.failOnStartup((Exception)this.vetoed);
        }
    }

    public void start() {
        super.start();
        if (this.vetoed != null) {
            LOG.info("CamelContext ({}) vetoed to not start due to: {}", (Object)this.camelContextExtension.getName(), (Object)this.vetoed.getMessage());
            this.failOnStartup((Exception)this.vetoed);
            this.stop();
            return;
        }
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextStarted((CamelContext)this);
            }
            catch (Exception e) {
                LOG.warn("Lifecycle strategy {} failed on CamelContext ({}) due to: {}. This exception will be ignored", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
            }
        }
        EventHelper.notifyCamelContextStarted((CamelContext)this);
        for (StartupListener startup : this.startupListeners) {
            try {
                startup.onCamelContextFullyStarted((CamelContext)this, this.isStarted());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
    }

    public void stop() {
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextStopping((CamelContext)this);
            }
            catch (Exception e) {
                LOG.warn("Lifecycle strategy {} failed on CamelContext ({}) due to: {}. This exception will be ignored", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
            }
        }
        super.stop();
    }

    public void doBuild() throws Exception {
        StartupStep step5;
        DevConsoleRegistry dcr;
        StartupStepRecorder fr;
        StopWatch watch = new StopWatch();
        this.getCamelContextExtension().addContextPlugin(NodeIdFactory.class, (Object)this.createNodeIdFactory());
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        if (startupStepRecorder.getClass().getSimpleName().equals("DefaultStartupStepRecorder") && (fr = (StartupStepRecorder)this.camelContextExtension.getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            this.camelContextExtension.setStartupStepRecorder(fr);
            startupStepRecorder = fr;
        }
        startupStepRecorder.start();
        StartupStep step = startupStepRecorder.beginStep(CamelContext.class, null, "Build CamelContext");
        StartupStep subStep = startupStepRecorder.beginStep(CamelContext.class, null, "Setup LRUCacheFactory");
        LRUCacheFactory.init();
        startupStepRecorder.endStep(subStep);
        StartupStep step3 = startupStepRecorder.beginStep(CamelContext.class, null, "Setup Management");
        this.camelContextExtension.setupManagement(null);
        startupStepRecorder.endStep(step3);
        HealthCheckRegistry hcr = (HealthCheckRegistry)this.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        if (hcr == null) {
            StartupStep step4 = startupStepRecorder.beginStep(CamelContext.class, null, "Setup HealthCheckRegistry");
            hcr = this.createHealthCheckRegistry();
            if (hcr != null) {
                hcr.setCamelContext((CamelContext)this);
                this.getCamelContextExtension().addContextPlugin(HealthCheckRegistry.class, (Object)hcr);
            }
            startupStepRecorder.endStep(step4);
        }
        if ((dcr = (DevConsoleRegistry)this.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)) == null) {
            step5 = startupStepRecorder.beginStep(CamelContext.class, null, "Setup DevConsoleRegistry");
            dcr = this.createDevConsoleRegistry();
            if (dcr != null) {
                dcr.setCamelContext((CamelContext)this);
                this.getCamelContextExtension().addContextPlugin(DevConsoleRegistry.class, (Object)dcr);
            }
            startupStepRecorder.endStep(step5);
        }
        CamelContextTracker.notifyContextCreated((CamelContext)this);
        if (this.eagerCreateTypeConverter()) {
            step5 = startupStepRecorder.beginStep(CamelContext.class, null, "Setting up TypeConverter");
            this.camelContextExtension.getOrCreateTypeConverter();
            startupStepRecorder.endStep(step5);
        }
        startupStepRecorder.endStep(step);
        if (LOG.isDebugEnabled()) {
            this.buildTaken = watch.taken();
            LOG.debug("Apache Camel {} ({}) built in {}", new Object[]{this.getVersion(), this.camelContextExtension.getName(), TimeUtils.printDuration((long)this.buildTaken, (boolean)true)});
        }
    }

    protected void resetBuildTime() {
        this.buildTaken = 0L;
    }

    public void doInit() throws Exception {
        DebuggerFactory debuggerFactory;
        CliConnectorFactory ccf;
        StopWatch watch = new StopWatch();
        this.vetoed = null;
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        StartupStep step = startupStepRecorder.beginStep(CamelContext.class, null, "Init CamelContext");
        RouteController routeController = this.getRouteController();
        if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && routeController.getLoggingLevel().ordinal() < LoggingLevel.INFO.ordinal()) {
            routeController.setLoggingLevel(LoggingLevel.INFO);
        }
        ShutdownStrategy shutdownStrategy = this.getShutdownStrategy();
        if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && shutdownStrategy != null && shutdownStrategy.getLoggingLevel().ordinal() < LoggingLevel.INFO.ordinal()) {
            shutdownStrategy.setLoggingLevel(LoggingLevel.INFO);
        }
        this.camelContextExtension.setEventNotificationApplicable(EventHelper.eventsApplicable((CamelContext)this));
        boolean load = this.loadTypeConverters != false || this.camelContextExtension.getBasePackageScan() != null;
        TypeConverter typeConverter = this.camelContextExtension.getTypeConverter();
        if (load && typeConverter instanceof AnnotationScanTypeConverters) {
            AnnotationScanTypeConverters annotationScanTypeConverters = (AnnotationScanTypeConverters)typeConverter;
            StartupStep startupStep = startupStepRecorder.beginStep(CamelContext.class, null, "Scan TypeConverters");
            annotationScanTypeConverters.scanTypeConverters();
            startupStepRecorder.endStep(startupStep);
        }
        if (this.loadHealthChecks.booleanValue()) {
            StartupStep step3 = startupStepRecorder.beginStep(CamelContext.class, null, "Scan HealthChecks");
            HealthCheckRegistry healthCheckRegistry = (HealthCheckRegistry)this.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
            if (healthCheckRegistry != null) {
                healthCheckRegistry.loadHealthChecks();
            }
            startupStepRecorder.endStep(step3);
        }
        if (this.devConsole.booleanValue()) {
            StartupStep step4 = startupStepRecorder.beginStep(CamelContext.class, null, "Scan DevConsoles (phase 1)");
            DevConsoleRegistry devConsoleRegistry = (DevConsoleRegistry)this.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
            if (devConsoleRegistry != null) {
                devConsoleRegistry.loadDevConsoles();
            }
            startupStepRecorder.endStep(step4);
        }
        if (this.globalOptions != null && !this.globalOptions.isEmpty()) {
            for (Map.Entry entry : this.globalOptions.entrySet()) {
                Object replaced;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || value.equals(replaced = this.resolvePropertyPlaceholders(value))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Camel property with key {} replaced value from {} -> {}", new Object[]{key, value, replaced});
                }
                entry.setValue(replaced);
            }
        }
        this.forceLazyInitialization();
        if (this.hasService(CliConnector.class) == null && (ccf = (CliConnectorFactory)this.getCamelContextExtension().getContextPlugin(CliConnectorFactory.class)) != null && ccf.isEnabled()) {
            CliConnector cliConnector = ccf.createConnector();
            this.addService(cliConnector, true);
            ServiceHelper.startService((Service)cliConnector);
        }
        boolean debuggerDetected = false;
        if (this.getDebugger() == null && this.hasService(BacklogDebugger.class) == null && (debuggerFactory = (DebuggerFactory)this.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("debugger-factory", DebuggerFactory.class).orElse(null)) != null) {
            debuggerDetected = true;
            LOG.info("Detected: {} JAR (Enabling Camel Debugging)", (Object)debuggerFactory);
            this.setDebugging(true);
            Debugger newDebugger = debuggerFactory.createDebugger((CamelContext)this);
            if (newDebugger != null) {
                this.setDebugger(newDebugger);
            }
        }
        if (!debuggerDetected && (this.isDebugging().booleanValue() || this.isDebugStandby()) && this.hasService(BacklogDebugger.class) == null) {
            BacklogDebugger backlogDebugger = DefaultBacklogDebugger.createDebugger(this);
            this.addService(backlogDebugger, true, true);
        }
        this.addService(this.getManagementStrategy(), false);
        this.lifecycleStrategies.sort((Comparator<LifecycleStrategy>)OrderedComparator.get());
        ServiceHelper.initService(this.lifecycleStrategies);
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextInitializing((CamelContext)this);
            }
            catch (VetoCamelContextStartException e) {
                LOG.warn("Lifecycle strategy {} vetoed initializing CamelContext ({}) due to: {}", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Lifecycle strategy {} failed initializing CamelContext ({}) due to: {}", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
                throw e;
            }
        }
        this.camelContextExtension.setEventNotificationApplicable(EventHelper.eventsApplicable((CamelContext)this));
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            if (notifier instanceof Service) {
                Service service = (Service)notifier;
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onServiceAdd(this.getCamelContextReference(), service, null);
                }
            }
            ServiceHelper.initService((Object)notifier);
        }
        EventHelper.notifyCamelContextInitializing((CamelContext)this);
        this.endpoints = this.internalServiceManager.addService(this, this.createEndpointRegistry((Map<NormalizedEndpointUri, Endpoint>)this.endpoints));
        if (this.runtimeEndpointRegistry == null && this.getManagementStrategy() != null && this.getManagementStrategy().getManagementAgent() != null) {
            boolean extended;
            Boolean bl = this.getManagementStrategy().getManagementAgent().getEndpointRuntimeStatisticsEnabled();
            boolean isExtended = this.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended();
            boolean bl2 = extended = isExtended || bl != null && bl != false;
            if (extended) {
                this.runtimeEndpointRegistry = new DefaultRuntimeEndpointRegistry();
            }
        }
        if (this.runtimeEndpointRegistry != null) {
            if (this.runtimeEndpointRegistry instanceof EventNotifier && this.getManagementStrategy() != null) {
                this.getManagementStrategy().addEventNotifier((EventNotifier)this.runtimeEndpointRegistry);
            }
            this.addService(this.runtimeEndpointRegistry, true, true);
        }
        this.bindDataFormats();
        ServiceHelper.initService(this.components.values());
        for (RouteTemplateParameterSource source : this.camelContextExtension.getRegistry().findByType(RouteTemplateParameterSource.class)) {
            for (String routeId : source.routeIds()) {
                String id;
                HashMap map = new HashMap(source.parameters(routeId));
                Object templateId = map.remove("templateId");
                if (templateId == null) {
                    templateId = map.remove("template-id");
                }
                String string = id = templateId != null ? templateId.toString() : null;
                if (id == null) {
                    throw new IllegalArgumentException("RouteTemplateParameterSource with routeId: " + routeId + " has no templateId defined");
                }
                this.addRouteFromTemplate(routeId, id, map);
            }
        }
        StartupStep startupStep = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "Init Routes");
        this.startRouteDefinitions();
        this.internalRouteStartupManager.doInitRoutes(this, this.routeServices);
        startupStepRecorder.endStep(startupStep);
        if (!this.lifecycleStrategies.isEmpty()) {
            StartupStep startupStep2 = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "LifecycleStrategy onContextInitialized");
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                try {
                    strategy.onContextInitialized((CamelContext)this);
                }
                catch (VetoCamelContextStartException e) {
                    LOG.warn("Lifecycle strategy {} vetoed initializing CamelContext ({}) due to: {}", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Lifecycle strategy {} failed initializing CamelContext ({}) due to: {}", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
                    throw e;
                }
            }
            startupStepRecorder.endStep(startupStep2);
        }
        EventHelper.notifyCamelContextInitialized((CamelContext)this);
        startupStepRecorder.endStep(step);
        if (LOG.isDebugEnabled()) {
            this.initTaken = watch.taken();
            LOG.debug("Apache Camel {} ({}) initialized in {}", new Object[]{this.getVersion(), this.camelContextExtension.getName(), TimeUtils.printDuration((long)this.initTaken, (boolean)true)});
        }
    }

    protected void doStart() throws Exception {
        if (this.firstStartDone) {
            LOG.warn("Starting CamelContext: {} after the context has been stopped is not recommended", (Object)this.camelContextExtension.getName());
        }
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        StartupStep step = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "Start CamelContext");
        try {
            this.doStartContext();
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextStartupFailed((CamelContext)this, (Throwable)e);
            throw e;
        }
        startupStepRecorder.endStep(step);
        if (startupStepRecorder.getStartupRecorderDuration() < 0L) {
            startupStepRecorder.stop();
        }
    }

    protected void doStartContext() throws Exception {
        LOG.info("Apache Camel {} ({}) is starting", (Object)this.getVersion(), (Object)this.camelContextExtension.getName());
        this.vetoed = null;
        this.clock.add(ContextEvents.START, (Clock)new ResetableClock());
        this.stopWatch.restart();
        this.startService((Service)this.camelContextExtension.getRouteController());
        boolean bl = this.doNotStartRoutesOnFirstStart = !this.firstStartDone && this.isAutoStartup() == false;
        if (this.firstStartDone && !this.isAutoStartup().booleanValue() && this.isStarted()) {
            try {
                this.internalRouteStartupManager.doStartOrResumeRoutes(this, this.routeServices, true, true, false, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        try {
            this.firstStartDone = true;
            this.doStartCamel();
        }
        catch (Exception e) {
            VetoCamelContextStartException veto = (VetoCamelContextStartException)((Object)ObjectHelper.getException(VetoCamelContextStartException.class, (Throwable)e));
            if (veto != null) {
                this.vetoed = veto;
                return;
            }
            LOG.error("Error starting CamelContext ({}) due to exception thrown: {}", new Object[]{this.camelContextExtension.getName(), e.getMessage(), e});
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        this.logDuplicateComponents();
        this.logStartSummary();
        this.camelContextExtension.closeBootstraps();
        if (this.camelContextExtension.getExchangeFactory().isPooled()) {
            LOG.info("Pooled mode enabled. Camel pools and reuses objects to reduce JVM object allocations. The pool capacity is: {} elements.", (Object)this.camelContextExtension.getExchangeFactory().getCapacity());
        }
    }

    protected void logDuplicateComponents() {
        if (LOG.isInfoEnabled()) {
            LinkedHashMap<Class, Set> counters = new LinkedHashMap<Class, Set>();
            TreeSet<String> cnames = new TreeSet<String>(this.getComponentNames());
            for (String string : cnames) {
                Class<?> source = this.getComponent(string).getClass();
                if (counters.containsKey(source)) continue;
                for (String targetName : cnames) {
                    Class<?> target = this.getComponent(targetName).getClass();
                    if (source != target) continue;
                    Set names = counters.computeIfAbsent(source, k -> new TreeSet());
                    names.add(targetName);
                }
            }
            for (Map.Entry entry : counters.entrySet()) {
                int count = ((Set)entry.getValue()).size();
                if (count <= 1) continue;
                String fqn = ((Class)entry.getKey()).getName();
                String names = String.join((CharSequence)", ", (Iterable)entry.getValue());
                LOG.info("Using {} instances of same component class: {} with names: {}", new Object[]{count, fqn, names});
            }
        }
    }

    protected void logStartSummary() {
        boolean supervised = this.getRouteController().isSupervising();
        if (!supervised && this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off && LOG.isInfoEnabled()) {
            String cid;
            String loc;
            String uri;
            boolean skip;
            String status;
            String id;
            int started = 0;
            int total = 0;
            int kamelets = 0;
            int templates = 0;
            int rests = 0;
            int disabled = 0;
            boolean registerKamelets = false;
            boolean registerTemplates = true;
            ManagementStrategy ms = this.getManagementStrategy();
            if (ms != null && ms.getManagementAgent() != null) {
                registerKamelets = ms.getManagementAgent().getRegisterRoutesCreateByKamelet();
                registerTemplates = ms.getManagementAgent().getRegisterRoutesCreateByTemplate();
            }
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<String> configs = new ArrayList<String>();
            this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder));
            for (RouteStartupOrder order : this.routeStartupOrder) {
                ++total;
                id = order.getRoute().getRouteId();
                status = this.getRouteStatus(id).name();
                if (order.getRoute().isCreatedByKamelet()) {
                    ++kamelets;
                } else if (order.getRoute().isCreatedByRouteTemplate()) {
                    ++templates;
                } else if (order.getRoute().isCreatedByRestDsl()) {
                    ++rests;
                }
                boolean bl = skip = !registerKamelets && order.getRoute().isCreatedByKamelet() || !registerTemplates && order.getRoute().isCreatedByRouteTemplate();
                if (!skip && ServiceStatus.Started.name().equals(status)) {
                    ++started;
                }
                uri = order.getRoute().getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                loc = order.getRoute().getSourceLocationShort();
                if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && loc != null) {
                    lines.add(String.format("    %s %s (%s) (source: %s)", status, id, uri, loc));
                } else if (!skip) {
                    lines.add(String.format("    %s %s (%s)", status, id, uri));
                }
                if ((cid = order.getRoute().getConfigurationId()) == null) continue;
                configs.add(String.format("    %s (%s)", id, cid));
            }
            for (Route route : this.routes) {
                if (route.isAutoStartup().booleanValue()) continue;
                ++total;
                ++disabled;
                id = route.getRouteId();
                status = this.getRouteStatus(id).name();
                if (ServiceStatus.Stopped.name().equals(status)) {
                    status = "Disabled";
                }
                if (route.isCreatedByKamelet()) {
                    ++kamelets;
                } else if (route.isCreatedByRouteTemplate()) {
                    ++templates;
                } else if (route.isCreatedByRestDsl()) {
                    ++rests;
                }
                skip = !registerKamelets && route.isCreatedByKamelet() || !registerTemplates && route.isCreatedByRouteTemplate();
                uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                loc = route.getSourceLocationShort();
                if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && loc != null) {
                    lines.add(String.format("    %s %s (%s) (source: %s)", status, id, uri, loc));
                } else if (!skip) {
                    lines.add(String.format("    %s %s (%s)", status, id, uri));
                }
                if ((cid = route.getConfigurationId()) == null) continue;
                configs.add(String.format("    %s (%s)", id, cid));
            }
            int newTotal = total;
            if (!registerKamelets) {
                newTotal -= kamelets;
            }
            if (!registerTemplates) {
                newTotal -= templates;
            }
            StringJoiner sj = new StringJoiner(" ");
            sj.add("total:" + newTotal);
            if (total != started) {
                sj.add("started:" + started);
            }
            if (kamelets > 0) {
                sj.add("kamelets:" + kamelets);
            }
            if (templates > 0) {
                sj.add("templates:" + templates);
            }
            if (rests > 0) {
                sj.add("rest-dsl:" + rests);
            }
            if (disabled > 0) {
                sj.add("disabled:" + disabled);
            }
            LOG.info("Routes startup ({})", (Object)sj);
            if (this.startupSummaryLevel == StartupSummaryLevel.Default || this.startupSummaryLevel == StartupSummaryLevel.Verbose) {
                for (String line : lines) {
                    LOG.info(line);
                }
                if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && !configs.isEmpty()) {
                    LOG.info("Routes configuration:");
                    for (String line : configs) {
                        LOG.info(line);
                    }
                }
            }
        }
        if (this.startupSummaryLevel != StartupSummaryLevel.Off && LOG.isInfoEnabled()) {
            long taken = this.stopWatch.taken();
            long max = this.buildTaken + this.initTaken + taken;
            String total = TimeUtils.printDuration((long)max, (boolean)true);
            String start = TimeUtils.printDuration((long)taken, (boolean)true);
            String init = TimeUtils.printDuration((long)this.initTaken, (boolean)true);
            String built = TimeUtils.printDuration((long)this.buildTaken, (boolean)true);
            LOG.info("Apache Camel {} ({}) started in {} (build:{} init:{} start:{})", new Object[]{this.getVersion(), this.camelContextExtension.getName(), total, built, init, start});
        }
    }

    protected void doStartCamel() throws Exception {
        long invokedCounter;
        BeanIntrospection beanIntrospection;
        long cacheCounter;
        StartupStep step;
        Object subStep;
        if (!this.camelContextExtension.getContextPlugin(CamelBeanPostProcessor.class).isEnabled()) {
            LOG.info("BeanPostProcessor is disabled. Dependency injection of Camel annotations in beans is not supported.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using ClassResolver={}, PackageScanClassResolver={}, ApplicationContextClassLoader={}, RouteController={}", new Object[]{this.getClassResolver(), PluginHelper.getPackageScanClassResolver((ExtendedCamelContext)this.camelContextExtension), this.getApplicationContextClassLoader(), this.getRouteController()});
        }
        if (this.isStreamCaching().booleanValue()) {
            LOG.debug("StreamCaching is disabled on CamelContext: {}", (Object)this.camelContextExtension.getName());
        }
        if (this.isBacklogTracing().booleanValue()) {
            LOG.debug("Backlog Tracing is enabled on CamelContext: {}", (Object)this.camelContextExtension.getName());
        }
        if (this.isTracing().booleanValue()) {
            LOG.info("Tracing is enabled on CamelContext: {}", (Object)this.camelContextExtension.getName());
        }
        if (this.isUseMDCLogging().booleanValue()) {
            String pattern = this.getMDCLoggingKeysPattern();
            if (pattern != null) {
                LOG.info("MDC logging (keys-pattern: {}) is enabled on CamelContext: {}", (Object)pattern, (Object)this.camelContextExtension.getName());
            } else {
                LOG.info("MDC logging is enabled on CamelContext: {}", (Object)this.camelContextExtension.getName());
            }
        }
        if (this.getDelayer() != null && this.getDelayer() > 0L) {
            LOG.info("Delayer is enabled with: {} ms. on CamelContext: {}", (Object)this.getDelayer(), (Object)this.camelContextExtension.getName());
        }
        this.startService((Service)this.getManagementStrategy());
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        if (!this.lifecycleStrategies.isEmpty()) {
            subStep = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "LifecycleStrategy onContextStarting");
            this.startServices(this.lifecycleStrategies);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                try {
                    strategy.onContextStarting((CamelContext)this);
                }
                catch (VetoCamelContextStartException e) {
                    LOG.warn("Lifecycle strategy {} vetoed starting CamelContext ({}) due to: {}", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Lifecycle strategy {} failed starting CamelContext ({}) due to: {}", new Object[]{strategy, this.camelContextExtension.getName(), e.getMessage()});
                    throw e;
                }
            }
            startupStepRecorder.endStep((StartupStep)subStep);
        }
        ServiceHelper.startService((Iterable)this.getCamelContextExtension().getLogListeners());
        for (Map.Entry entry : this.components.entrySet()) {
            step = startupStepRecorder.beginStep(Component.class, (String)entry.getKey(), "Start Component");
            try {
                this.startService((Service)entry.getValue());
            }
            catch (Exception e) {
                throw new FailedToStartComponentException((String)entry.getKey(), e.getMessage(), (Throwable)e);
            }
            finally {
                startupStepRecorder.endStep(step);
            }
        }
        if (!this.startupListeners.isEmpty()) {
            subStep = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "StartupListener onCamelContextStarting");
            this.startupListeners.sort((Comparator<StartupListener>)OrderedComparator.get());
            for (StartupListener startup : this.startupListeners) {
                startup.onCamelContextStarting(this.getCamelContextReference(), this.isStarted());
            }
            startupStepRecorder.endStep((StartupStep)subStep);
        }
        for (EventNotifier eventNotifier : this.getManagementStrategy().getEventNotifiers()) {
            if (!(eventNotifier instanceof Service)) continue;
            Service service = (Service)eventNotifier;
            this.startService(service);
        }
        EventHelper.notifyCamelContextStarting((CamelContext)this);
        if (this.isUseDataType().booleanValue()) {
            LOG.debug("Message DataType is enabled on CamelContext: {}", (Object)this.camelContextExtension.getName());
        }
        if (this.isStreamCachingInUse()) {
            this.getStreamCachingStrategy().setEnabled(true);
        } else {
            LOG.debug("StreamCaching is not in use. If using streams then it's recommended to enable stream caching. See more details at https://camel.apache.org/stream-caching.html");
        }
        if (this.isAllowUseOriginalMessage().booleanValue()) {
            LOG.debug("AllowUseOriginalMessage enabled because UseOriginalMessage is in use");
        }
        LOG.debug("Using HeadersMapFactory: {}", (Object)this.camelContextExtension.getHeadersMapFactory());
        if (this.isCaseInsensitiveHeaders().booleanValue() && !this.camelContextExtension.getHeadersMapFactory().isCaseInsensitive()) {
            LOG.info("HeadersMapFactory: {} is case-sensitive which can cause problems for protocols such as HTTP based, which rely on case-insensitive headers.", (Object)this.camelContextExtension.getHeadersMapFactory());
        } else if (!this.isCaseInsensitiveHeaders().booleanValue()) {
            LOG.info("Case-insensitive headers is not in use. This can cause problems for protocols such as HTTP based, which rely on case-insensitive headers.");
        }
        ReactiveExecutor reactiveExecutor = this.camelContextExtension.getReactiveExecutor();
        if (!reactiveExecutor.getClass().getSimpleName().equals("DefaultReactiveExecutor")) {
            LOG.info("Using ReactiveExecutor: {}", (Object)reactiveExecutor);
        } else {
            LOG.debug("Using ReactiveExecutor: {}", (Object)reactiveExecutor);
        }
        if (!this.getExecutorServiceManager().getThreadPoolFactory().getClass().getSimpleName().equals("DefaultThreadPoolFactory")) {
            LOG.info("Using ThreadPoolFactory: {}", (Object)this.getExecutorServiceManager().getThreadPoolFactory());
        } else {
            LOG.debug("Using ThreadPoolFactory: {}", (Object)this.getExecutorServiceManager().getThreadPoolFactory());
        }
        HealthCheckRegistry healthCheckRegistry = (HealthCheckRegistry)this.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        if (healthCheckRegistry != null && healthCheckRegistry.isEnabled()) {
            LOG.debug("Using HealthCheck: {}", (Object)healthCheckRegistry.getId());
        }
        if (this.doNotStartRoutesOnFirstStart) {
            LOG.debug("Skip starting routes as CamelContext has been configured with autoStartup=false");
        }
        if (this.getDumpRoutes() != null && !"false".equals(this.getDumpRoutes())) {
            this.doDumpRoutes();
        }
        if (!this.getRouteController().isSupervising()) {
            StartupStep subStep2 = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "Start Routes");
            EventHelper.notifyCamelContextRoutesStarting((CamelContext)this);
            this.internalRouteStartupManager.doStartOrResumeRoutes(this, this.routeServices, true, !this.doNotStartRoutesOnFirstStart, false, true);
            EventHelper.notifyCamelContextRoutesStarted((CamelContext)this);
            startupStepRecorder.endStep(subStep2);
        }
        if (this.devConsole.booleanValue()) {
            step = startupStepRecorder.beginStep(CamelContext.class, null, "Scan DevConsoles (phase 2)");
            DevConsoleRegistry dcr = (DevConsoleRegistry)this.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class);
            if (dcr != null) {
                dcr.loadDevConsoles(true);
            }
            startupStepRecorder.endStep(step);
        }
        long l = cacheCounter = (beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this)) != null ? beanIntrospection.getCachedClassesCounter() : 0L;
        if (cacheCounter > 0L) {
            LOG.debug("Clearing BeanIntrospection cache with {} objects using during starting Camel", (Object)cacheCounter);
            beanIntrospection.clearCache();
        }
        long l2 = invokedCounter = beanIntrospection != null ? beanIntrospection.getInvokedCounter() : 0L;
        if (invokedCounter > 0L) {
            LOG.debug("BeanIntrospection invoked {} times during starting Camel", (Object)invokedCounter);
        }
    }

    protected void doStop() throws Exception {
        this.stopWatch.restart();
        ShutdownStrategy shutdownStrategy = this.getShutdownStrategy();
        if (this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off) {
            if (shutdownStrategy != null && shutdownStrategy.getTimeUnit() != null) {
                long timeout;
                String string = TimeUtils.printDuration((long)timeout, ((timeout = shutdownStrategy.getTimeUnit().toMillis(shutdownStrategy.getTimeout())) < 10000L ? 1 : 0) != 0);
                LOG.info("Apache Camel {} ({}) is shutting down (timeout:{})", new Object[]{this.getVersion(), this.camelContextExtension.getName(), string});
            } else {
                LOG.info("Apache Camel {} ({}) is shutting down", (Object)this.getVersion(), (Object)this.camelContextExtension.getName());
            }
        }
        EventHelper.notifyCamelContextStopping((CamelContext)this);
        EventHelper.notifyCamelContextRoutesStopping((CamelContext)this);
        this.camelContextExtension.stopAndShutdownRouteController();
        try {
            if (shutdownStrategy != null) {
                shutdownStrategy.shutdownForced((CamelContext)this, this.camelContextExtension.getRouteStartupOrder());
            }
        }
        catch (Exception e) {
            LOG.warn("Error occurred while shutting down routes. This exception will be ignored.", (Throwable)e);
        }
        AsyncProcessorAwaitManager asyncProcessorAwaitManager = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this);
        InternalServiceManager.shutdownServices((CamelContext)this, asyncProcessorAwaitManager);
        for (RouteService routeService : this.routeServices.values()) {
            boolean found = this.routeStartupOrder.stream().anyMatch(o -> o.getRoute().getId().equals(routeService.getId()));
            if (found) continue;
            LOG.debug("Route: {} which failed to startup will be stopped", (Object)routeService.getId());
            this.routeStartupOrder.add(this.internalRouteStartupManager.doPrepareRouteToBeStarted(this, routeService));
        }
        this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder).reversed());
        ArrayList<RouteService> list = new ArrayList<RouteService>();
        for (RouteStartupOrder startupOrder : this.routeStartupOrder) {
            DefaultRouteStartupOrder order = (DefaultRouteStartupOrder)startupOrder;
            RouteService routeService = order.getRouteService();
            list.add(routeService);
        }
        InternalServiceManager.shutdownServices(this, list, false);
        if (this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off) {
            this.logRouteStopSummary(LoggingLevel.INFO);
        }
        this.routeStartupOrder.clear();
        EventHelper.notifyCamelContextRoutesStopped((CamelContext)this);
        this.suspendedRouteServices.clear();
        this.internalServiceManager.stopConsumers(this);
        ScheduledExecutorService scheduledExecutorService = PluginHelper.getErrorHandlerExecutorService((CamelContext)this);
        if (scheduledExecutorService != null) {
            this.getExecutorServiceManager().shutdownNow((ExecutorService)scheduledExecutorService);
        }
        ServiceHelper.stopAndShutdownService((Object)this.getDebugger());
        InternalServiceManager.shutdownServices((CamelContext)this, this.endpoints.values());
        this.endpoints.clear();
        InternalServiceManager.shutdownServices((CamelContext)this, this.components.values());
        this.components.clear();
        InternalServiceManager.shutdownServices((CamelContext)this, this.languages.values());
        this.languages.clear();
        this.internalServiceManager.shutdownServices(this);
        ServiceHelper.stopAndShutdownServices((Collection)this.getCamelContextExtension().getLogListeners());
        try {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onContextStopped((CamelContext)this);
            }
        }
        catch (Exception e) {
            LOG.warn("Error occurred while stopping lifecycle strategies. This exception will be ignored.", (Throwable)e);
        }
        EventHelper.notifyCamelContextStopped((CamelContext)this);
        if (this.getManagementStrategy() != null) {
            for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
                InternalServiceManager.shutdownServices((CamelContext)this, notifier);
            }
        }
        InternalServiceManager.shutdownServices((CamelContext)this, this.camelContextExtension.getManagementStrategy());
        InternalServiceManager.shutdownServices((CamelContext)this, this.camelContextExtension.getManagementMBeanAssembler());
        InternalServiceManager.shutdownServices((CamelContext)this, this.lifecycleStrategies);
        InternalServiceManager.shutdownServices((CamelContext)this, this.camelContextExtension.getExecutorServiceManager());
        InternalServiceManager.shutdownServices((CamelContext)this, this.camelContextExtension.getReactiveExecutor());
        this.camelContextExtension.stopTypeConverter();
        this.camelContextExtension.stopTypeConverterRegistry();
        this.camelContextExtension.stopRegistry();
        this.forceStopLazyInitialization();
        if (this.startupSummaryLevel != StartupSummaryLevel.Off && LOG.isInfoEnabled()) {
            String taken = TimeUtils.printDuration((long)this.stopWatch.taken(), (boolean)true);
            LOG.info("Apache Camel {} ({}) shutdown in {} (uptime:{})", new Object[]{this.getVersion(), this.camelContextExtension.getName(), taken, CamelContextHelper.getUptime((CamelContext)this)});
        }
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        startupStepRecorder.stop();
        this.clock.add(ContextEvents.START, null);
        CamelContextTracker.notifyContextDestroyed((CamelContext)this);
        this.firstStartDone = true;
    }

    protected void doFail(Exception e) {
        super.doFail(e);
        this.firstStartDone = false;
    }

    protected void doDumpRoutes() {
    }

    protected void logRouteStopSummary(LoggingLevel loggingLevel) {
        CamelLogger logger = new CamelLogger(LOG, loggingLevel);
        if (logger.shouldLog()) {
            int total = 0;
            int stopped = 0;
            int forced = 0;
            int kamelets = 0;
            int templates = 0;
            int rests = 0;
            boolean registerKamelets = false;
            boolean registerTemplates = true;
            ManagementStrategy ms = this.getManagementStrategy();
            if (ms != null && ms.getManagementAgent() != null) {
                registerKamelets = ms.getManagementAgent().getRegisterRoutesCreateByKamelet();
                registerTemplates = ms.getManagementAgent().getRegisterRoutesCreateByTemplate();
            }
            ArrayList<String> lines = new ArrayList<String>();
            ShutdownStrategy shutdownStrategy = this.camelContextExtension.getShutdownStrategy();
            if (shutdownStrategy != null && shutdownStrategy.isShutdownRoutesInReverseOrder()) {
                this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder).reversed());
            } else {
                this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder));
            }
            for (RouteStartupOrder order : this.routeStartupOrder) {
                boolean skip;
                ++total;
                String id = order.getRoute().getRouteId();
                String status = this.getRouteStatus(id).name();
                if (order.getRoute().isCreatedByKamelet()) {
                    ++kamelets;
                } else if (order.getRoute().isCreatedByRouteTemplate()) {
                    ++templates;
                } else if (order.getRoute().isCreatedByRestDsl()) {
                    ++rests;
                }
                boolean bl = skip = !registerKamelets && order.getRoute().isCreatedByKamelet() || !registerTemplates && order.getRoute().isCreatedByRouteTemplate();
                if (!skip && ServiceStatus.Stopped.name().equals(status)) {
                    ++stopped;
                }
                if (order.getRoute().getProperties().containsKey("forcedShutdown")) {
                    ++forced;
                    status = "Forced stopped";
                }
                String uri = order.getRoute().getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri((String)uri);
                if (this.startupSummaryLevel != StartupSummaryLevel.Verbose && skip) continue;
                lines.add(String.format("    %s %s (%s)", status, id, uri));
            }
            int newTotal = total;
            if (!registerKamelets) {
                newTotal -= kamelets;
            }
            if (!registerTemplates) {
                newTotal -= templates;
            }
            StringJoiner sj = new StringJoiner(" ");
            sj.add("total:" + newTotal);
            if (total != stopped) {
                sj.add("stopped:" + stopped);
            }
            if (kamelets > 0) {
                sj.add("kamelets:" + kamelets);
            }
            if (templates > 0) {
                sj.add("templates:" + templates);
            }
            if (rests > 0) {
                sj.add("rest-dsl:" + rests);
            }
            if (forced > 0) {
                sj.add("forced:" + forced);
            }
            logger.log(String.format("Routes stopped (%s)", sj));
            if (this.startupSummaryLevel == StartupSummaryLevel.Default || this.startupSummaryLevel == StartupSummaryLevel.Verbose) {
                for (String line : lines) {
                    logger.log(line);
                }
            }
        }
    }

    public void startRouteDefinitions() throws Exception {
    }

    public void removeRouteDefinitionsFromTemplate() throws Exception {
    }

    protected boolean isStreamCachingInUse() throws Exception {
        return this.isStreamCaching();
    }

    protected void bindDataFormats() throws Exception {
    }

    protected boolean routeSupportsSuspension(String routeId) {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            return routeService.getRoute().supportsSuspension();
        }
        return false;
    }

    void startService(Service service) throws Exception {
        if (service instanceof StartupListener) {
            StartupListener listener = (StartupListener)service;
            this.addStartupListener(listener);
        }
        CamelContextAware.trySetCamelContext((Object)service, (CamelContext)this.getCamelContextReference());
        ServiceHelper.startService((Service)service);
    }

    private void startServices(Collection<?> services) throws Exception {
        for (Object element : services) {
            if (!(element instanceof Service)) continue;
            Service service = (Service)element;
            this.startService(service);
        }
    }

    private void stopServices(Object service) {
        try {
            ServiceHelper.stopService((Object)service);
        }
        catch (Exception e) {
            EventHelper.notifyServiceStopFailure((CamelContext)this.getCamelContextReference(), (Object)service, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRouteService(RouteService routeService, boolean addingRoutes) throws Exception {
        this.lock.lock();
        try {
            boolean alreadyStartingRoutes = this.isStartingRoutes();
            if (!alreadyStartingRoutes) {
                this.setStartingRoutes(true);
            }
            try {
                if (routeService.getStatus().isSuspended()) {
                    this.resumeRouteService(routeService);
                } else {
                    this.routeServices.put(routeService.getId(), routeService);
                    if (this.shouldStartRoutes()) {
                        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
                        StartupStep step = startupStepRecorder.beginStep(Route.class, routeService.getId(), "Start Route Services");
                        this.internalRouteStartupManager.safelyStartRouteServices(this, true, true, true, false, addingRoutes, routeService);
                        boolean isAutoStartup = routeService.isAutoStartup();
                        if (!addingRoutes || isAutoStartup) {
                            routeService.start();
                        }
                        startupStepRecorder.endStep(step);
                    }
                }
            }
            finally {
                if (!alreadyStartingRoutes) {
                    this.setStartingRoutes(false);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void resumeRouteService(RouteService routeService) throws Exception {
        this.lock.lock();
        try {
            if (!routeService.getStatus().isSuspended()) {
                this.startRouteService(routeService, false);
            } else if (this.shouldStartRoutes()) {
                this.internalRouteStartupManager.safelyStartRouteServices(this, true, false, true, true, false, routeService);
                routeService.resume();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRouteService(RouteService routeService, boolean removingRoutes, LoggingLevel loggingLevel) throws Exception {
        this.lock.lock();
        try {
            routeService.setRemovingRoutes(removingRoutes);
            this.stopRouteService(routeService, loggingLevel);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logRouteState(Route route, String state, LoggingLevel loggingLevel) {
        this.lock.lock();
        try {
            CamelLogger logger = new CamelLogger(LOG, loggingLevel);
            if (logger.shouldLog()) {
                if (route.getConsumer() != null) {
                    String id = route.getId();
                    String uri = route.getEndpoint().getEndpointBaseUri();
                    uri = URISupport.sanitizeUri((String)uri);
                    String line = String.format("%s %s (%s)", state, id, uri);
                    logger.log(line);
                } else {
                    String id = route.getId();
                    String line = String.format("%s %s", state, id);
                    logger.log(line);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void stopRouteService(RouteService routeService, LoggingLevel loggingLevel) {
        this.lock.lock();
        try {
            routeService.stop();
            this.logRouteState(routeService.getRoute(), "Stopped", loggingLevel);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void shutdownRouteService(RouteService routeService) throws Exception {
        this.lock.lock();
        try {
            this.shutdownRouteService(routeService, LoggingLevel.INFO);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void shutdownRouteService(RouteService routeService, LoggingLevel loggingLevel) {
        this.lock.lock();
        try {
            routeService.shutdown();
            this.logRouteState(routeService.getRoute(), "Shutdown", loggingLevel);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void suspendRouteService(RouteService routeService) {
        this.lock.lock();
        try {
            routeService.setRemovingRoutes(false);
            routeService.suspend();
            this.logRouteState(routeService.getRoute(), "Suspended", LoggingLevel.INFO);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void forceLazyInitialization() {
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        StartupStep step = startupStepRecorder.beginStep(CamelContext.class, this.camelContextExtension.getName(), "Start Mandatory Services");
        this.initEagerMandatoryServices();
        startupStepRecorder.endStep(step);
        step = startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Start Standard Services");
        this.doStartStandardServices();
        startupStepRecorder.endStep(step);
    }

    protected void initEagerMandatoryServices() {
        this.camelContextExtension.initEagerMandatoryServices(this.isCaseInsensitiveHeaders(), this::createHeadersMapFactory);
    }

    protected void doStartStandardServices() {
        this.getVersion();
        this.getClassResolver();
        this.camelContextExtension.getRegistry();
        this.camelContextExtension.getBootstrapFactoryFinder();
        this.getTypeConverterRegistry();
        this.getInjector();
        this.camelContextExtension.getDefaultFactoryFinder();
        this.getPropertiesComponent();
        this.getExecutorServiceManager();
        this.camelContextExtension.getExchangeFactoryManager();
        this.camelContextExtension.getExchangeFactory();
        this.getShutdownStrategy();
        this.getUuidGenerator();
        this.resolveLanguage("simple");
    }

    protected void forceStopLazyInitialization() {
        this.camelContextExtension.resetInjector();
        this.camelContextExtension.resetTypeConverterRegistry();
        this.camelContextExtension.resetTypeConverter();
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.camelContextExtension.getRegistry().lookupByName(uri);
        if (value instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)value;
            return endpoint;
        }
        if (value instanceof Processor) {
            Processor processor = (Processor)value;
            return new ProcessorEndpoint(uri, this.getCamelContextReference(), processor);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    public Map<String, String> getGlobalOptions() {
        return this.globalOptions;
    }

    public void setGlobalOptions(Map<String, String> globalOptions) {
        this.globalOptions = globalOptions;
    }

    protected FactoryFinder createBootstrapFactoryFinder(String path) {
        return PluginHelper.getFactoryFinderResolver((ExtendedCamelContext)this.camelContextExtension).resolveBootstrapFactoryFinder(this.getClassResolver(), path);
    }

    protected FactoryFinder createFactoryFinder(String path) {
        return PluginHelper.getFactoryFinderResolver((ExtendedCamelContext)this.camelContextExtension).resolveFactoryFinder(this.getClassResolver(), path);
    }

    public ClassResolver getClassResolver() {
        return this.camelContextExtension.getClassResolver();
    }

    public void setClassResolver(ClassResolver classResolver) {
        this.camelContextExtension.setClassResolver(classResolver);
    }

    public Set<String> getComponentNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    public Set<String> getLanguageNames() {
        return Collections.unmodifiableSet(this.languages.keySet());
    }

    public ManagementStrategy getManagementStrategy() {
        return this.camelContextExtension.getManagementStrategy();
    }

    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.camelContextExtension.setManagementStrategy(managementStrategy);
    }

    public void disableJMX() {
        if (this.isNew()) {
            this.disableJMX = true;
        } else if (this.isInit() || this.isBuild()) {
            this.disableJMX = true;
            this.camelContextExtension.setupManagement(null);
        } else {
            throw new IllegalStateException("Disabling JMX can only be done when CamelContext has not been started");
        }
    }

    public boolean isJMXDisabled() {
        String override = System.getProperty("org.apache.camel.jmx.disabled");
        if (override != null) {
            return Boolean.parseBoolean(override);
        }
        return this.disableJMX;
    }

    void enableDebugging(DebuggerFactory df) throws Exception {
        this.setDebugging(true);
        Debugger newDebugger = df.createDebugger((CamelContext)this);
        if (newDebugger != null) {
            this.setDebugger(newDebugger);
        }
    }

    public InflightRepository getInflightRepository() {
        return this.camelContextExtension.getInflightRepository();
    }

    public void setInflightRepository(InflightRepository repository) {
        this.camelContextExtension.setInflightRepository(repository);
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Boolean isAutoStartup() {
        return this.autoStartup != null && this.autoStartup != false;
    }

    public Boolean isLoadTypeConverters() {
        return this.loadTypeConverters != null && this.loadTypeConverters != false;
    }

    public void setLoadTypeConverters(Boolean loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    public Boolean isLoadHealthChecks() {
        return this.loadHealthChecks != null && this.loadHealthChecks != false;
    }

    public void setLoadHealthChecks(Boolean loadHealthChecks) {
        this.loadHealthChecks = loadHealthChecks;
    }

    public Boolean isModeline() {
        return this.modeline != null && this.modeline != false;
    }

    public void setModeline(Boolean modeline) {
        this.modeline = modeline;
    }

    public Boolean isDevConsole() {
        return this.devConsole != null && this.devConsole != false;
    }

    public void setDevConsole(Boolean loadDevConsoles) {
        this.devConsole = loadDevConsoles;
    }

    public Boolean isTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled != null && this.typeConverterStatisticsEnabled != false;
    }

    public Boolean isSourceLocationEnabled() {
        return this.sourceLocationEnabled;
    }

    public void setSourceLocationEnabled(Boolean sourceLocationEnabled) {
        this.sourceLocationEnabled = sourceLocationEnabled;
    }

    public void setTypeConverterStatisticsEnabled(Boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    public String getDumpRoutes() {
        return this.dumpRoutes;
    }

    public void setDumpRoutes(String dumpRoutes) {
        this.dumpRoutes = dumpRoutes;
    }

    public Boolean isUseMDCLogging() {
        return this.useMDCLogging != null && this.useMDCLogging != false;
    }

    public void setUseMDCLogging(Boolean useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    public String getMDCLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    public void setMDCLoggingKeysPattern(String pattern) {
        this.mdcLoggingKeysPattern = pattern;
    }

    public Boolean isUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(Boolean useDataType) {
        this.useDataType = useDataType;
    }

    public Boolean isUseBreadcrumb() {
        return this.useBreadcrumb != null && this.useBreadcrumb != false;
    }

    public void setUseBreadcrumb(Boolean useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        this.applicationContextClassLoader = classLoader;
    }

    private DataFormat doResolveDataFormat(String name) {
        DataFormat df;
        StartupStep step = null;
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        if (!this.isStarted() && startupStepRecorder.isEnabled()) {
            step = startupStepRecorder.beginStep(DataFormat.class, name, "Resolve DataFormat");
        }
        if ((df = Optional.ofNullable(ResolverHelper.lookupDataFormatInRegistryWithFallback((CamelContext)this.getCamelContextReference(), (String)name)).orElseGet(() -> PluginHelper.getDataFormatResolver((ExtendedCamelContext)this.camelContextExtension).createDataFormat(name, this.getCamelContextReference()))) != null) {
            CamelContextAware.trySetCamelContext((Object)df, (CamelContext)this.getCamelContextReference());
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onDataFormatCreated(name, df);
            }
        }
        if (step != null) {
            startupStepRecorder.endStep(step);
        }
        return df;
    }

    public DataFormat resolveDataFormat(String name) {
        return this.dataformats.computeIfAbsent(name, s -> this.doResolveDataFormat(name));
    }

    public DataFormat createDataFormat(String name) {
        StartupStep step = null;
        StartupStepRecorder startupStepRecorder = this.camelContextExtension.getStartupStepRecorder();
        if (!this.isStarted() && startupStepRecorder.isEnabled()) {
            step = startupStepRecorder.beginStep(DataFormat.class, name, "Create DataFormat");
        }
        DataFormat answer = PluginHelper.getDataFormatResolver((ExtendedCamelContext)this.camelContextExtension).createDataFormat(name, this.getCamelContextReference());
        CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.getCamelContextReference());
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onDataFormatCreated(name, answer);
        }
        if (step != null) {
            startupStepRecorder.endStep(step);
        }
        return answer;
    }

    public Set<String> getDataFormatNames() {
        return Collections.unmodifiableSet(this.dataformats.keySet());
    }

    public ShutdownStrategy getShutdownStrategy() {
        return this.camelContextExtension.getShutdownStrategy();
    }

    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.camelContextExtension.setShutdownStrategy(shutdownStrategy);
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    public Boolean isAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage != null && this.allowUseOriginalMessage != false;
    }

    public Boolean isCaseInsensitiveHeaders() {
        return this.caseInsensitiveHeaders != null && this.caseInsensitiveHeaders != false;
    }

    public void setCaseInsensitiveHeaders(Boolean caseInsensitiveHeaders) {
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    public Boolean isAutowiredEnabled() {
        return this.autowiredEnabled != null && this.autowiredEnabled != false;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public ExecutorServiceManager getExecutorServiceManager() {
        return this.camelContextExtension.getExecutorServiceManager();
    }

    public void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        this.camelContextExtension.setExecutorServiceManager(executorServiceManager);
    }

    public MessageHistoryFactory getMessageHistoryFactory() {
        return this.camelContextExtension.getMessageHistoryFactory();
    }

    public void setMessageHistoryFactory(MessageHistoryFactory messageHistoryFactory) {
        this.camelContextExtension.setMessageHistoryFactory(messageHistoryFactory);
        this.setMessageHistory(true);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(Debugger debugger) {
        if (this.isStartingOrStarted()) {
            throw new IllegalStateException("Cannot set debugger on a started CamelContext");
        }
        this.debugger = this.internalServiceManager.addService(this, debugger, true, false, true);
    }

    public Tracer getTracer() {
        return this.camelContextExtension.getTracer();
    }

    public void setTracer(Tracer tracer) {
        if (!this.isTracingStandby() && this.isStartingOrStarted()) {
            throw new IllegalStateException("Cannot set tracer on a started CamelContext");
        }
        this.camelContextExtension.setTracer(tracer);
    }

    public void setTracingStandby(boolean tracingStandby) {
        this.traceStandby = tracingStandby;
    }

    public boolean isTracingStandby() {
        return this.traceStandby != null && this.traceStandby != false;
    }

    public void setTracingTemplates(boolean tracingTemplates) {
        this.traceTemplates = tracingTemplates;
    }

    public boolean isTracingTemplates() {
        return this.traceTemplates != null && this.traceTemplates != false;
    }

    public void setBacklogTracingTemplates(boolean backlogTracingTemplates) {
        this.backlogTraceTemplates = backlogTracingTemplates;
    }

    public boolean isBacklogTracingTemplates() {
        return this.backlogTraceTemplates != null && this.backlogTraceTemplates != false;
    }

    public void setBacklogTracingStandby(boolean backlogTracingStandby) {
        this.backlogTraceStandby = backlogTracingStandby;
    }

    public boolean isBacklogTracingStandby() {
        return this.backlogTraceStandby != null && this.backlogTraceStandby != false;
    }

    public UuidGenerator getUuidGenerator() {
        return this.camelContextExtension.getUuidGenerator();
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.camelContextExtension.setUuidGenerator(uuidGenerator);
    }

    public StreamCachingStrategy getStreamCachingStrategy() {
        return this.camelContextExtension.getStreamCachingStrategy();
    }

    public void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        this.camelContextExtension.setStreamCachingStrategy(streamCachingStrategy);
    }

    public RestRegistry getRestRegistry() {
        return this.camelContextExtension.getRestRegistry();
    }

    public void setRestRegistry(RestRegistry restRegistry) {
        this.camelContextExtension.setRestRegistry(restRegistry);
    }

    protected RestRegistry createRestRegistry() {
        RestRegistryFactory factory = this.camelContextExtension.getRestRegistryFactory();
        return factory.createRegistry();
    }

    public String getGlobalOption(String key) {
        String value = this.getGlobalOptions().get(key);
        if (ObjectHelper.isNotEmpty((String)value)) {
            try {
                value = this.resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error getting global option: " + key, (Throwable)e);
            }
        }
        return value;
    }

    public Transformer resolveTransformer(String name) {
        return this.getTransformerRegistry().resolveTransformer(new TransformerKey(name));
    }

    public Transformer resolveTransformer(DataType from, DataType to) {
        return this.getTransformerRegistry().resolveTransformer(new TransformerKey(from, to));
    }

    public TransformerRegistry getTransformerRegistry() {
        return this.camelContextExtension.getTransformerRegistry();
    }

    public Validator resolveValidator(DataType type) {
        return this.getValidatorRegistry().resolveValidator(new ValidatorKey(type));
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this.camelContextExtension.getValidatorRegistry();
    }

    public SSLContextParameters getSSLContextParameters() {
        return this.sslContextParameters;
    }

    public void setSSLContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public StartupSummaryLevel getStartupSummaryLevel() {
        return this.startupSummaryLevel;
    }

    public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
        this.startupSummaryLevel = startupSummaryLevel;
    }

    protected Map<String, RouteService> getRouteServices() {
        return this.routeServices;
    }

    public String toString() {
        return "CamelContext(" + this.camelContextExtension.getName() + ")";
    }

    protected void failOnStartup(Exception e) {
        if (e instanceof VetoCamelContextStartException) {
            VetoCamelContextStartException vetoException = (VetoCamelContextStartException)((Object)e);
            if (vetoException.isRethrowException()) {
                this.fail(e);
            } else {
                this.status = (byte)12;
            }
        } else {
            this.fail(e);
        }
    }

    protected abstract ExchangeFactory createExchangeFactory();

    protected abstract ExchangeFactoryManager createExchangeFactoryManager();

    protected abstract ProcessorExchangeFactory createProcessorExchangeFactory();

    protected abstract HealthCheckRegistry createHealthCheckRegistry();

    protected abstract DevConsoleRegistry createDevConsoleRegistry();

    protected abstract ReactiveExecutor createReactiveExecutor();

    protected abstract StreamCachingStrategy createStreamCachingStrategy();

    protected abstract TypeConverter createTypeConverter();

    protected abstract TypeConverterRegistry createTypeConverterRegistry();

    protected abstract Injector createInjector();

    protected abstract PropertiesComponent createPropertiesComponent();

    protected abstract CamelBeanPostProcessor createBeanPostProcessor();

    protected abstract CamelDependencyInjectionAnnotationFactory createDependencyInjectionAnnotationFactory();

    protected abstract ComponentResolver createComponentResolver();

    protected abstract ComponentNameResolver createComponentNameResolver();

    protected abstract Registry createRegistry();

    protected abstract UuidGenerator createUuidGenerator();

    protected abstract ModelJAXBContextFactory createModelJAXBContextFactory();

    protected abstract NodeIdFactory createNodeIdFactory();

    protected abstract ModelineFactory createModelineFactory();

    protected abstract PeriodTaskResolver createPeriodTaskResolver();

    protected abstract PeriodTaskScheduler createPeriodTaskScheduler();

    protected abstract FactoryFinderResolver createFactoryFinderResolver();

    protected abstract ClassResolver createClassResolver();

    protected abstract ProcessorFactory createProcessorFactory();

    protected abstract InternalProcessorFactory createInternalProcessorFactory();

    protected abstract InterceptEndpointFactory createInterceptEndpointFactory();

    protected abstract RouteFactory createRouteFactory();

    protected abstract DataFormatResolver createDataFormatResolver();

    protected abstract HealthCheckResolver createHealthCheckResolver();

    protected abstract DevConsoleResolver createDevConsoleResolver();

    protected abstract MessageHistoryFactory createMessageHistoryFactory();

    protected abstract InflightRepository createInflightRepository();

    protected abstract AsyncProcessorAwaitManager createAsyncProcessorAwaitManager();

    protected abstract RouteController createRouteController();

    protected abstract ShutdownStrategy createShutdownStrategy();

    protected abstract PackageScanClassResolver createPackageScanClassResolver();

    protected abstract PackageScanResourceResolver createPackageScanResourceResolver();

    protected abstract ExecutorServiceManager createExecutorServiceManager();

    protected abstract UnitOfWorkFactory createUnitOfWorkFactory();

    protected abstract CamelContextNameStrategy createCamelContextNameStrategy();

    protected abstract ManagementNameStrategy createManagementNameStrategy();

    protected abstract HeadersMapFactory createHeadersMapFactory();

    protected abstract BeanProxyFactory createBeanProxyFactory();

    protected abstract AnnotationBasedProcessorFactory createAnnotationBasedProcessorFactory();

    protected abstract DeferServiceFactory createDeferServiceFactory();

    protected abstract BeanProcessorFactory createBeanProcessorFactory();

    protected abstract BeanIntrospection createBeanIntrospection();

    protected abstract RoutesLoader createRoutesLoader();

    protected abstract ResourceLoader createResourceLoader();

    protected abstract ModelToXMLDumper createModelToXMLDumper();

    protected abstract ModelToYAMLDumper createModelToYAMLDumper();

    protected abstract RestBindingJaxbDataFormatFactory createRestBindingJaxbDataFormatFactory();

    protected abstract RuntimeCamelCatalog createRuntimeCamelCatalog();

    protected abstract DumpRoutesStrategy createDumpRoutesStrategy();

    protected abstract Tracer createTracer();

    protected abstract LanguageResolver createLanguageResolver();

    protected abstract ConfigurerResolver createConfigurerResolver();

    protected abstract UriFactoryResolver createUriFactoryResolver();

    protected abstract RestRegistryFactory createRestRegistryFactory();

    protected abstract EndpointRegistry createEndpointRegistry(Map<NormalizedEndpointUri, Endpoint> var1);

    protected abstract TransformerRegistry createTransformerRegistry();

    protected abstract ValidatorRegistry createValidatorRegistry();

    protected abstract VariableRepositoryFactory createVariableRepositoryFactory();

    protected abstract EndpointServiceRegistry createEndpointServiceRegistry();

    protected RestConfiguration createRestConfiguration() {
        RestConfiguration conf = (RestConfiguration)CamelContextHelper.lookup((CamelContext)this, (String)"rest-configuration", RestConfiguration.class);
        if (conf == null) {
            conf = (RestConfiguration)CamelContextHelper.findSingleByType((CamelContext)this, RestConfiguration.class);
        }
        if (conf == null) {
            conf = new RestConfiguration();
        }
        return conf;
    }

    public abstract Processor createErrorHandler(Route var1, Processor var2) throws Exception;

    @Deprecated
    public abstract void disposeModel();

    public abstract String getTestExcludeRoutes();

    public ExtendedCamelContext getCamelContextExtension() {
        return this.camelContextExtension;
    }

    public String getName() {
        return this.camelContextExtension.getName();
    }

    public String getDescription() {
        return this.camelContextExtension.getDescription();
    }

    public void addRoute(Route route) {
        this.routesLock.lock();
        try {
            this.routes.add(route);
        }
        finally {
            this.routesLock.unlock();
        }
    }

    public void removeRoute(Route route) {
        this.routesLock.lock();
        try {
            this.routes.remove(route);
        }
        finally {
            this.routesLock.unlock();
        }
    }

    protected Lock getLock() {
        return this.lock;
    }

    byte getStatusPhase() {
        return this.status;
    }

    public Registry getRegistry() {
        return this.camelContextExtension.getRegistry();
    }

    Set<EndpointStrategy> getEndpointStrategies() {
        return this.endpointStrategies;
    }

    List<RouteStartupOrder> getRouteStartupOrder() {
        return this.routeStartupOrder;
    }

    InternalServiceManager getInternalServiceManager() {
        return this.internalServiceManager;
    }

    private List<BootstrapCloseable> getBootstraps() {
        return this.camelContextExtension.getBootstraps();
    }

    class LifecycleHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();

        LifecycleHelper() {
            if (AbstractCamelContext.this.applicationContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(AbstractCamelContext.this.applicationContextClassLoader);
            }
            if (AbstractCamelContext.this.isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)AbstractCamelContext.this.camelContextExtension.getName());
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (AbstractCamelContext.this.isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
            Thread.currentThread().setContextClassLoader(this.tccl);
        }
    }
}

