/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.impl.engine.CamelInternalProcessor;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.ErrorHandlerRedeliveryCustomizer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.InterceptableProcessor;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.WrapAwareProcessor;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannel
extends CamelInternalProcessor
implements Channel {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChannel.class);
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ManagementInterceptStrategy.InstrumentationProcessor<?> instrumentationProcessor;
    private Route route;

    public DefaultChannel(CamelContext camelContext) {
        super(camelContext);
    }

    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    public void setOutput(Processor output) {
        this.output = output;
    }

    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public Route getRoute() {
        return this.route;
    }

    protected void doStart() throws Exception {
        this.setProcessor(this.getOutput());
        ServiceHelper.startService((Object[])new Object[]{this.errorHandler, this.output});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.output, this.errorHandler});
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.output, this.errorHandler});
    }

    public void initChannel(Route route, NamedNode definition, NamedNode childDefinition, List<InterceptStrategy> interceptors, Processor nextProcessor, NamedRoute routeDefinition, boolean first) throws Exception {
        boolean skip;
        boolean debugging;
        MessageHistoryFactory messageHistoryFactory;
        this.route = route;
        this.nextProcessor = nextProcessor;
        CamelContextAware.trySetCamelContext((Object)nextProcessor, (CamelContext)this.camelContext);
        NamedNode targetOutputDef = childDefinition != null ? childDefinition : definition;
        LOG.trace("Initialize channel for target: {}", (Object)targetOutputDef);
        ManagementInterceptStrategy managed = route.getManagementInterceptStrategy();
        if (managed != null) {
            this.instrumentationProcessor = managed.createProcessor(targetOutputDef, nextProcessor);
        }
        if (this.camelContext.isDebugStandby() || route.isDebugging().booleanValue()) {
            BacklogDebugger debugger;
            Debugger customDebugger = this.camelContext.getDebugger();
            messageHistoryFactory = this.camelContext.getMessageHistoryFactory();
            if (customDebugger != null) {
                this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(messageHistoryFactory, targetOutputDef));
                this.addAdvice(new CamelInternalProcessor.DebuggerAdvice(customDebugger, nextProcessor, targetOutputDef));
            }
            if ((debugger = DefaultChannel.getBacklogDebugger(this.camelContext, customDebugger == null)) != null) {
                boolean skip2;
                if (!this.camelContext.hasService((Object)debugger)) {
                    this.camelContext.addService((Object)debugger);
                }
                boolean bl = skip2 = routeDefinition != null && (routeDefinition.isCreatedFromRest() || routeDefinition.isCreatedFromTemplate());
                if (!skip2 && routeDefinition != null) {
                    this.backlogDebuggerSetupInitialBreakpoints(definition, routeDefinition, first, debugger, targetOutputDef);
                    if (first && debugger.isSingleStepIncludeStartEnd()) {
                        this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(this.camelContext.getMessageHistoryFactory(), routeDefinition.getInput()));
                        this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice(debugger, nextProcessor, routeDefinition.getInput()));
                    }
                    this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(messageHistoryFactory, targetOutputDef));
                    this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice(debugger, nextProcessor, targetOutputDef));
                }
            }
        }
        if (this.camelContext.isBacklogTracingStandby() || route.isBacklogTracing().booleanValue()) {
            BacklogTracer backlogTracer = DefaultChannel.getOrCreateBacklogTracer(this.camelContext);
            this.addAdvice(new CamelInternalProcessor.BacklogTracerAdvice(this.camelContext, backlogTracer, targetOutputDef, routeDefinition, first));
        }
        if (route.isTracing().booleanValue() || this.camelContext.isTracingStandby()) {
            Tracer tracer = this.camelContext.getTracer();
            this.addAdvice(new CamelInternalProcessor.TracingAdvice(this.camelContext, tracer, targetOutputDef, routeDefinition, first));
        }
        boolean bl = debugging = this.camelContext.isDebugStandby() || route.isDebugging() != false;
        if (!debugging && route.isMessageHistory().booleanValue()) {
            messageHistoryFactory = this.camelContext.getMessageHistoryFactory();
            this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(messageHistoryFactory, targetOutputDef));
        }
        this.addAdvice(new CamelInternalProcessor.NodeHistoryAdvice(targetOutputDef));
        interceptors.sort((Comparator<InterceptStrategy>)OrderedComparator.get());
        Collections.reverse(interceptors);
        Processor target = nextProcessor;
        boolean bl2 = skip = target instanceof InterceptableProcessor && !((InterceptableProcessor)target).canIntercept();
        if (!skip) {
            for (InterceptStrategy strategy : interceptors) {
                Processor next = target == nextProcessor ? null : nextProcessor;
                Processor wrapped = strategy.wrapProcessorInInterceptors(route.getCamelContext(), targetOutputDef, target, next);
                if (!(wrapped instanceof AsyncProcessor)) {
                    LOG.warn("Interceptor: {} at: {} does not return an AsyncProcessor instance. This causes the asynchronous routing engine to not work as optimal as possible. See more details at the InterceptStrategy javadoc. Camel will use a bridge to adapt the interceptor to the asynchronous routing engine, but its not the most optimal solution. Please consider changing your interceptor to comply.", (Object)strategy, (Object)definition);
                }
                if (!(wrapped instanceof WrapAwareProcessor)) {
                    wrapped = PluginHelper.getInternalProcessorFactory((CamelContext)this.camelContext).createWrapProcessor(wrapped, target);
                }
                target = wrapped;
            }
        }
        if (route.isStreamCaching().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.StreamCachingAdvice(this.camelContext.getStreamCachingStrategy()));
        }
        if (route.getDelayer() != null && route.getDelayer() > 0L) {
            this.addAdvice(new CamelInternalProcessor.DelayerAdvice(route.getDelayer()));
        }
        this.output = target;
    }

    public void postInitChannel() throws Exception {
        if (this.instrumentationProcessor != null) {
            ErrorHandlerRedeliveryCustomizer erh;
            boolean redeliveryPossible = false;
            Processor processor = this.errorHandler;
            if (processor instanceof ErrorHandlerRedeliveryCustomizer && (redeliveryPossible = (erh = (ErrorHandlerRedeliveryCustomizer)processor).determineIfRedeliveryIsEnabled())) {
                Processor currentOutput = erh.getOutput();
                this.instrumentationProcessor.setProcessor(currentOutput);
                erh.changeOutput(this.instrumentationProcessor);
            }
            if (!redeliveryPossible) {
                this.addAdvice(CamelInternalProcessor.wrap(this.instrumentationProcessor));
            }
        }
    }

    private static BacklogTracer getOrCreateBacklogTracer(CamelContext camelContext) {
        Map map;
        BacklogTracer tracer = null;
        if (camelContext.getRegistry() != null && (map = camelContext.getRegistry().findByTypeWithName(BacklogTracer.class)).size() == 1) {
            tracer = (BacklogTracer)((Object)map.values().iterator().next());
        }
        if (tracer == null) {
            tracer = (BacklogTracer)((Object)camelContext.getCamelContextExtension().getContextPlugin(BacklogTracer.class));
        }
        if (tracer == null) {
            tracer = BacklogTracer.createTracer(camelContext);
            tracer.setEnabled(camelContext.isBacklogTracing() != null && camelContext.isBacklogTracing() != false);
            tracer.setStandby(camelContext.isBacklogTracingStandby());
            boolean restOrTemplates = camelContext.isBacklogTracingTemplates();
            tracer.setTraceTemplates(restOrTemplates);
            tracer.setTraceRests(restOrTemplates);
            camelContext.getCamelContextExtension().addContextPlugin(BacklogTracer.class, (Object)tracer);
        }
        return tracer;
    }

    private static BacklogDebugger getBacklogDebugger(CamelContext camelContext, boolean createIfAbsent) {
        Map map;
        BacklogDebugger debugger = null;
        if (camelContext.getRegistry() != null && (map = camelContext.getRegistry().findByTypeWithName(BacklogDebugger.class)).size() == 1) {
            debugger = (BacklogDebugger)map.values().iterator().next();
        }
        if (debugger == null) {
            debugger = (BacklogDebugger)camelContext.hasService(BacklogDebugger.class);
        }
        if (debugger == null && createIfAbsent) {
            debugger = DefaultBacklogDebugger.createDebugger(camelContext);
        }
        return debugger;
    }

    private void backlogDebuggerSetupInitialBreakpoints(NamedNode definition, NamedRoute routeDefinition, boolean first, BacklogDebugger debugger, NamedNode targetOutputDef) {
        if (debugger.getInitialBreakpoints() != null) {
            boolean match = false;
            String id = definition.getId();
            for (String pattern : debugger.getInitialBreakpoints().split(",")) {
                int num;
                Object pnum;
                if (!(match |= "_all_routes_".equals(pattern = pattern.trim()) && first)) {
                    match = PatternHelper.matchPattern((String)id, (String)pattern);
                }
                if (!match) {
                    match = PatternHelper.matchPattern((String)definition.getShortName(), (String)pattern);
                }
                if (!match && pattern.contains(":") && (pnum = StringHelper.afterLast((String)pattern, (String)":")) != null) {
                    String ploc = StringHelper.beforeLast((String)pattern, (String)":");
                    String loc = definition.getLocation();
                    if (loc != null && loc.contains(":")) {
                        loc = StringHelper.after((String)loc, (String)":");
                    }
                    String num2 = String.valueOf(definition.getLineNumber());
                    if (PatternHelper.matchPattern((String)loc, (String)ploc) && ((String)pnum).equals(num2)) {
                        match = true;
                    }
                }
                if (match || (pnum = (Integer)this.camelContext.getTypeConverter().tryConvertTo(Integer.class, (Object)pattern)) == null || (num = definition.getLineNumber()) != (Integer)pnum) continue;
                match = true;
            }
            if (match) {
                if (first && debugger.isSingleStepIncludeStartEnd()) {
                    id = routeDefinition.getInput().getId();
                    debugger.addBreakpoint(id);
                    LOG.debug("BacklogDebugger added breakpoint: {}", (Object)id);
                } else {
                    id = targetOutputDef.getId();
                    debugger.addBreakpoint(id);
                    LOG.debug("BacklogDebugger added breakpoint: {}", (Object)id);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

