/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ContentTypeAware;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.ResourceResolver;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ResourceResolverSupport;
import org.apache.camel.support.ResourceSupport;
import org.apache.camel.util.FileUtil;

public final class DefaultResourceResolvers {
    private DefaultResourceResolvers() {
    }

    static final class HttpResource
    extends ResourceSupport
    implements ContentTypeAware {
        private String contentType;

        HttpResource(String scheme, String location) {
            super(scheme, location);
        }

        public boolean exists() {
            URLConnection connection = null;
            try {
                connection = new URL(this.getLocation()).openConnection();
                if (connection instanceof HttpURLConnection) {
                    boolean bl = ((HttpURLConnection)connection).getResponseCode() == 200;
                    return bl;
                }
                boolean bl = connection.getContentLengthLong() > 0L;
                return bl;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
            }
        }

        public InputStream getInputStream() throws IOException {
            URLConnection con = new URL(this.getLocation()).openConnection();
            con.setUseCaches(false);
            try {
                this.setContentType(con.getContentType());
                return con.getInputStream();
            }
            catch (IOException e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw e;
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    @ResourceResolver(value="mem")
    public static class MemResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "mem";

        public MemResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, final String remaining) {
            return new ResourceSupport(SCHEME, location){

                public boolean exists() {
                    return remaining != null;
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new IOException("No memory content defined");
                    }
                    return new ByteArrayInputStream(remaining.getBytes());
                }
            };
        }
    }

    @ResourceResolver(value="gzip")
    public static class GzipResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "gzip";

        public GzipResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, final String remaining) {
            return new ResourceSupport(SCHEME, location){

                public boolean exists() {
                    return remaining != null;
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new IOException("No gzip content defined");
                    }
                    byte[] decoded = Base64.getDecoder().decode(remaining);
                    ByteArrayInputStream is = new ByteArrayInputStream(decoded);
                    return new GZIPInputStream(is);
                }
            };
        }
    }

    @ResourceResolver(value="base64")
    public static class Base64Resolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "base64";

        public Base64Resolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, final String remaining) {
            return new ResourceSupport(SCHEME, location){

                public boolean exists() {
                    return remaining != null;
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new IOException("No base64 content defined");
                    }
                    byte[] decoded = Base64.getDecoder().decode(remaining);
                    return new ByteArrayInputStream(decoded);
                }
            };
        }
    }

    @ResourceResolver(value="ref")
    public static class RefResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "ref";

        public RefResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, final String remaining) {
            final String val = (String)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)remaining, String.class);
            return new ResourceSupport(SCHEME, location){

                public boolean exists() {
                    return val != null;
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new IOException("There is no bean in the registry with name " + remaining + " and type String");
                    }
                    return new ByteArrayInputStream(val.getBytes());
                }
            };
        }
    }

    @ResourceResolver(value="classpath")
    public static class ClasspathResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "classpath";

        public ClasspathResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, String remaining) {
            final String path = this.getPath(remaining);
            return new ResourceSupport(SCHEME, location){

                public boolean exists() {
                    return this.getURI() != null;
                }

                public URI getURI() {
                    URL url = this.getCamelContext().getClassResolver().loadResourceAsURL(path);
                    try {
                        return url != null ? url.toURI() : null;
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(e);
                    }
                }

                public InputStream getInputStream() throws IOException {
                    return this.getCamelContext().getClassResolver().loadResourceAsStream(path);
                }
            };
        }

        private String getPath(String location) {
            String uri = this.tryDecodeUri(location);
            return FileUtil.compactPath((String)uri, (char)'/');
        }

        protected String tryDecodeUri(String uri) {
            try {
                uri = URLDecoder.decode(uri, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                this.getLogger().trace("Error URL decoding uri using UTF-8 encoding: {}. This exception is ignored.", (Object)uri);
            }
            return uri;
        }
    }

    @ResourceResolver(value="https")
    public static class HttpsResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "https";

        public HttpsResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, String remaining) {
            return new HttpResource(SCHEME, location);
        }
    }

    @ResourceResolver(value="http")
    public static class HttpResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "http";

        public HttpResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, String remaining) {
            return new HttpResource(SCHEME, location);
        }
    }

    @ResourceResolver(value="file")
    public static class FileResolver
    extends ResourceResolverSupport {
        public static final String SCHEME = "file";

        public FileResolver() {
            super(SCHEME);
        }

        public Resource createResource(String location, String remaining) {
            final File path = new File(this.tryDecodeUri(remaining));
            return new ResourceSupport(SCHEME, location){

                public boolean exists() {
                    return path.exists();
                }

                public URI getURI() {
                    return path.toURI();
                }

                public InputStream getInputStream() throws IOException {
                    if (!this.exists()) {
                        throw new FileNotFoundException(path + " does not exists");
                    }
                    if (path.isDirectory()) {
                        throw new FileNotFoundException(path + " is a directory");
                    }
                    return new FileInputStream(path);
                }
            };
        }

        protected String tryDecodeUri(String uri) {
            try {
                uri = URLDecoder.decode(uri, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                this.getLogger().trace("Error URL decoding uri using UTF-8 encoding: {}. This exception is ignored.", (Object)uri);
            }
            return uri;
        }
    }
}

