/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.engine.DefaultUnitOfWork;
import org.apache.camel.impl.engine.MDCUnitOfWork;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.slf4j.Logger;

public class DefaultUnitOfWorkFactory
implements UnitOfWorkFactory {
    private InflightRepository inflightRepository;
    private boolean usedMDCLogging;
    private String mdcLoggingKeysPattern;
    private boolean allowUseOriginalMessage;
    private boolean useBreadcrumb;

    public void warmup(Logger log) {
        DefaultUnitOfWork.warmup(log);
    }

    public UnitOfWork createUnitOfWork(Exchange exchange) {
        DefaultUnitOfWork answer = this.usedMDCLogging ? new MDCUnitOfWork(exchange, this.inflightRepository, this.mdcLoggingKeysPattern, this.allowUseOriginalMessage, this.useBreadcrumb) : new DefaultUnitOfWork(exchange, this.inflightRepository, this.allowUseOriginalMessage, this.useBreadcrumb);
        return answer;
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
        this.inflightRepository = camelContext.getInflightRepository();
        this.usedMDCLogging = camelContext.isUseMDCLogging() != null && camelContext.isUseMDCLogging() != false;
        this.mdcLoggingKeysPattern = camelContext.getMDCLoggingKeysPattern();
        this.allowUseOriginalMessage = camelContext.isAllowUseOriginalMessage() != null ? camelContext.isAllowUseOriginalMessage() : false;
        this.useBreadcrumb = camelContext.isUseBreadcrumb() != null ? camelContext.isUseBreadcrumb() : false;
    }
}

