/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInflightRepository.class);
    private final AtomicInteger size = new AtomicInteger();
    private final ConcurrentMap<String, Exchange> inflight = new ConcurrentHashMap<String, Exchange>();
    private final ConcurrentMap<String, AtomicInteger> routeCount = new ConcurrentHashMap<String, AtomicInteger>();
    private boolean inflightExchangeEnabled;

    public void add(Exchange exchange) {
        this.size.incrementAndGet();
        if (this.inflightExchangeEnabled) {
            this.inflight.put(exchange.getExchangeId(), exchange);
        }
    }

    public void remove(Exchange exchange) {
        this.size.decrementAndGet();
        if (this.inflightExchangeEnabled) {
            this.inflight.remove(exchange.getExchangeId());
        }
    }

    public void add(Exchange exchange, String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        if (existing != null) {
            existing.incrementAndGet();
        }
    }

    public void remove(Exchange exchange, String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        if (existing != null) {
            existing.decrementAndGet();
        }
    }

    public int size() {
        return this.size.get();
    }

    public void addRoute(String routeId) {
        this.routeCount.putIfAbsent(routeId, new AtomicInteger());
    }

    public void removeRoute(String routeId) {
        this.routeCount.remove(routeId);
    }

    public int size(String routeId) {
        AtomicInteger existing = (AtomicInteger)this.routeCount.get(routeId);
        return existing != null ? existing.get() : 0;
    }

    public boolean isInflightBrowseEnabled() {
        return this.inflightExchangeEnabled;
    }

    public void setInflightBrowseEnabled(boolean inflightBrowseEnabled) {
        this.inflightExchangeEnabled = inflightBrowseEnabled;
    }

    public Collection<InflightRepository.InflightExchange> browse() {
        return this.browse(null, -1, false);
    }

    public Collection<InflightRepository.InflightExchange> browse(String fromRouteId) {
        return this.browse(fromRouteId, -1, false);
    }

    public Collection<InflightRepository.InflightExchange> browse(int limit, boolean sortByLongestDuration) {
        return this.browse(null, limit, sortByLongestDuration);
    }

    public Collection<InflightRepository.InflightExchange> browse(String fromRouteId, int limit, boolean sortByLongestDuration) {
        if (!this.inflightExchangeEnabled) {
            return Collections.emptyList();
        }
        Stream<Object> values = fromRouteId == null ? this.inflight.values().stream() : this.inflight.values().stream().filter(e -> fromRouteId.equals(e.getFromRouteId()));
        values = sortByLongestDuration ? values.sorted((e1, e2) -> {
            long d1 = DefaultInflightRepository.getExchangeDuration(e1);
            long d2 = DefaultInflightRepository.getExchangeDuration(e2);
            return -1 * Long.compare(d1, d2);
        }) : values.sorted(Comparator.comparing(Exchange::getExchangeId));
        if (limit > 0) {
            values = values.limit(limit);
        }
        List answer = values.map(x$0 -> new InflightExchangeEntry((Exchange)x$0)).collect(Collectors.toList());
        return Collections.unmodifiableCollection(answer);
    }

    public InflightRepository.InflightExchange oldest(String fromRouteId) {
        if (!this.inflightExchangeEnabled) {
            return null;
        }
        Stream<Object> values = fromRouteId == null ? this.inflight.values().stream() : this.inflight.values().stream().filter(e -> fromRouteId.equals(e.getFromRouteId()));
        Exchange first = values.sorted((e1, e2) -> {
            long d1 = DefaultInflightRepository.getExchangeDuration(e1);
            long d2 = DefaultInflightRepository.getExchangeDuration(e2);
            return -1 * Long.compare(d1, d2);
        }).findFirst().orElse(null);
        if (first != null) {
            return new InflightExchangeEntry(first);
        }
        return null;
    }

    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still {} inflight exchanges.", (Object)count);
        } else {
            LOG.debug("Shutting down with no inflight exchanges.");
        }
        this.routeCount.clear();
    }

    private static long getExchangeDuration(Exchange exchange) {
        return System.currentTimeMillis() - exchange.getCreated();
    }

    private static final class InflightExchangeEntry
    implements InflightRepository.InflightExchange {
        private final Exchange exchange;

        private InflightExchangeEntry(Exchange exchange) {
            this.exchange = exchange;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public long getDuration() {
            return DefaultInflightRepository.getExchangeDuration(this.exchange);
        }

        public long getElapsed() {
            List list = (List)this.exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
            if (list == null || list.isEmpty()) {
                return 0L;
            }
            MessageHistory history = (MessageHistory)list.get(list.size() - 1);
            if (history != null) {
                long elapsed = history.getElapsed();
                if (elapsed == 0L && history.getTime() > 0L) {
                    elapsed = System.currentTimeMillis() - history.getTime();
                }
                return elapsed;
            }
            return 0L;
        }

        public String getNodeId() {
            return ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).getHistoryNodeId();
        }

        public String getFromRouteId() {
            return this.exchange.getFromRouteId();
        }

        public String getAtRouteId() {
            return ExchangeHelper.getAtRouteId((Exchange)this.exchange);
        }

        public String toString() {
            return "InflightExchangeEntry[exchangeId=" + this.exchange.getExchangeId() + "]";
        }
    }
}

