/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.barcode.BarcodeImageType;
import org.apache.camel.dataformat.barcode.BarcodeParameters;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="barcode")
public class BarcodeDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final Logger LOG = LoggerFactory.getLogger(BarcodeDataFormat.class);
    private BarcodeFormat barcodeFormat;
    private BarcodeImageType imageType;
    private Integer width;
    private Integer height;
    private BarcodeParameters params;
    private final Map<EncodeHintType, Object> writerHintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
    private final Map<DecodeHintType, Object> readerHintMap = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);

    public BarcodeDataFormat() {
    }

    public BarcodeDataFormat(BarcodeFormat format) {
        this.setBarcodeFormat(format);
    }

    public BarcodeDataFormat(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public BarcodeDataFormat(BarcodeImageType type) {
        this.setImageType(type);
    }

    public BarcodeDataFormat(int width, int height, BarcodeImageType type, BarcodeFormat format) {
        this.setWidth(width);
        this.setHeight(height);
        this.setImageType(type);
        this.setBarcodeFormat(format);
    }

    public String getDataFormatName() {
        return "barcode";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.printImage(exchange, graph, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.readImage(exchange, stream);
    }

    protected final void optimizeHints() {
        this.writerHintMap.clear();
        this.readerHintMap.clear();
        String format = this.params.getFormat().toString();
        if (format.equals(BarcodeFormat.QR_CODE.toString())) {
            this.writerHintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        }
        if (format.equals(BarcodeFormat.DATA_MATRIX.toString())) {
            this.writerHintMap.put(EncodeHintType.DATA_MATRIX_SHAPE, SymbolShapeHint.FORCE_SQUARE);
        }
        this.readerHintMap.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
    }

    private void printImage(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String payload = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)graph);
        MultiFormatWriter writer = new MultiFormatWriter();
        String type = this.params.getType().toString();
        BitMatrix matrix = writer.encode(payload, this.params.getFormat(), this.params.getWidth().intValue(), this.params.getHeight().intValue(), this.writerHintMap);
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)type, (OutputStream)stream);
    }

    private String readImage(Exchange exchange, InputStream stream) throws Exception {
        MultiFormatReader reader = new MultiFormatReader();
        BufferedInputStream in = (BufferedInputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(BufferedInputStream.class, (Object)stream);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(ImageIO.read(in))));
        Result result = reader.decode(bitmap, this.readerHintMap);
        exchange.getOut().setHeader("BarcodeFormat", (Object)result.getBarcodeFormat());
        if (result.getResultMetadata() != null) {
            result.getResultMetadata().forEach((k, v) -> exchange.getOut().setHeader(k.toString(), v));
        }
        return result.getText();
    }

    public final void addToHintMap(EncodeHintType hintType, Object value) {
        this.writerHintMap.put(hintType, value);
        LOG.info("Added '{}' with value '{}' to writer hint map.", (Object)hintType, value);
    }

    public final void addToHintMap(DecodeHintType hintType, Object value) {
        this.readerHintMap.put(hintType, value);
    }

    public final void removeFromHintMap(EncodeHintType hintType) {
        if (this.writerHintMap.containsKey(hintType)) {
            this.writerHintMap.remove(hintType);
            LOG.info("Removed '{}' from writer hint map.", (Object)hintType);
        } else {
            LOG.warn("Could not find encode hint type '{}' in writer hint map.", (Object)hintType);
        }
    }

    public final void removeFromHintMap(DecodeHintType hintType) {
        if (this.readerHintMap.containsKey(hintType)) {
            this.readerHintMap.remove(hintType);
            LOG.info("Removed '{}' from reader hint map.", (Object)hintType);
        } else {
            LOG.warn("Could not find decode hint type '{}' in reader hint map.", (Object)hintType);
        }
    }

    public final BarcodeParameters getParams() {
        return this.params;
    }

    public final Map<EncodeHintType, Object> getWriterHintMap() {
        return this.writerHintMap;
    }

    public final Map<DecodeHintType, Object> getReaderHintMap() {
        return this.readerHintMap;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.barcodeFormat;
    }

    public void setBarcodeFormat(BarcodeFormat barcodeFormat) {
        this.barcodeFormat = barcodeFormat;
    }

    public BarcodeImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(BarcodeImageType imageType) {
        this.imageType = imageType;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    protected void doStart() throws Exception {
        this.params = new BarcodeParameters();
        if (this.barcodeFormat != null) {
            this.params.setFormat(this.barcodeFormat);
        }
        if (this.imageType != null) {
            this.params.setType(this.imageType);
        }
        if (this.width != null) {
            this.params.setWidth(this.width);
        }
        if (this.height != null) {
            this.params.setHeight(this.height);
        }
        this.optimizeHints();
    }

    protected void doStop() throws Exception {
    }
}

