/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DataLakeEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":accountName/fileSystemName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "azure-storage-datalake".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "accountName", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "fileSystemName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(55);
        props.add("accountKey");
        props.add("accountName");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("clientId");
        props.add("clientSecret");
        props.add("clientSecretCredential");
        props.add("close");
        props.add("closeStreamAfterRead");
        props.add("credentialType");
        props.add("dataCount");
        props.add("dataLakeServiceClient");
        props.add("delay");
        props.add("directoryName");
        props.add("downloadLinkExpiration");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("expression");
        props.add("fileDir");
        props.add("fileName");
        props.add("fileOffset");
        props.add("fileSystemName");
        props.add("greedy");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("maxResults");
        props.add("maxRetryRequests");
        props.add("openOptions");
        props.add("operation");
        props.add("path");
        props.add("permission");
        props.add("pollStrategy");
        props.add("position");
        props.add("recursive");
        props.add("regex");
        props.add("repeatCount");
        props.add("retainUncommitedData");
        props.add("runLoggingLevel");
        props.add("sasCredential");
        props.add("sasSignature");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("serviceClient");
        props.add("sharedKeyCredential");
        props.add("startScheduler");
        props.add("tenantId");
        props.add("timeUnit");
        props.add("timeout");
        props.add("umask");
        props.add("useFixedDelay");
        props.add("userPrincipalNameReturned");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("accountKey");
        secretProps.add("clientSecret");
        secretProps.add("clientSecretCredential");
        secretProps.add("sasCredential");
        secretProps.add("sasSignature");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

