/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.client;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.Context;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.models.PublicAccessType;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeDirectoryClientWrapper;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileClientWrapper;
import org.apache.camel.util.ObjectHelper;

public class DataLakeFileSystemClientWrapper {
    private final DataLakeFileSystemClient client;

    public DataLakeFileSystemClientWrapper(DataLakeFileSystemClient client) {
        this.client = client;
    }

    public HttpHeaders createFileSystem(Map<String, String> metadata, PublicAccessType publicAccessType, Duration timeout) {
        return this.client.createWithResponse(metadata, publicAccessType, timeout, Context.NONE).getHeaders();
    }

    public HttpHeaders deleteFileSystem(DataLakeRequestConditions dataLakeRequestConditions, Duration timeout) {
        return this.client.deleteWithResponse(dataLakeRequestConditions, timeout, Context.NONE).getHeaders();
    }

    public List<PathItem> listPaths(ListPathsOptions listPathsOptions, Duration timeout) {
        return this.client.listPaths(listPathsOptions, timeout).stream().toList();
    }

    public DataLakeDirectoryClientWrapper getDataLakeDirectoryClientWrapper(String directoryName) {
        if (!ObjectHelper.isEmpty((String)directoryName)) {
            return new DataLakeDirectoryClientWrapper(this.client.getDirectoryClient(directoryName));
        }
        throw new IllegalArgumentException("Cannot initialize a directory since no directory name was provided.");
    }

    public DataLakeFileClientWrapper getDataLakeFileClientWrapper(String fileName) {
        if (!ObjectHelper.isEmpty((String)fileName)) {
            return new DataLakeFileClientWrapper(this.client.getFileClient(fileName));
        }
        throw new IllegalArgumentException("Cannot initialize a directory since no directory name was provided.");
    }
}

