/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import org.apache.camel.spi.Metadata;

public final class FilesConstants {
    @Metadata(label="consumer", description="A `long` value containing the file size.", javaType="long")
    public static final String FILE_LENGTH = "CamelFileLength";
    @Metadata(label="consumer", description="A `Long` value containing the last modified timestamp of the file.", javaType="long")
    public static final String FILE_LAST_MODIFIED = "CamelFileLastModified";
    @Metadata(label="consumer", description="Only the file name (the name with no leading paths).", javaType="String")
    public static final String FILE_NAME_ONLY = "CamelFileNameOnly";
    @Metadata(description="(producer) Specifies the name of the file to write (relative to the endpoint directory). This name can be a `String`; a `String` with a file or simple Language expression; or an Expression object. If it's `null` then Camel will auto-generate a filename based on the message unique ID. (consumer) Name of the consumed file as a relative file path with offset from the starting directory configured on the endpoint.", javaType="String")
    public static final String FILE_NAME = "CamelFileName";
    @Metadata(label="consumer", description="The name of the file that has been consumed", javaType="String")
    public static final String FILE_NAME_CONSUMED = "CamelFileNameConsumed";
    @Metadata(label="consumer", description="A `boolean` option specifying whether the consumed file denotes an absolute path or not. Should normally be `false` for relative paths. Absolute paths should normally not be used but we added to the move option to allow moving files to absolute paths. But can be used elsewhere as well.", javaType="Boolean")
    public static final String FILE_ABSOLUTE = "CamelFileAbsolute";
    @Metadata(label="consumer", description="The absolute path to the file. For relative files this path holds the relative path instead.", javaType="String")
    public static final String FILE_ABSOLUTE_PATH = "CamelFileAbsolutePath";
    @Metadata(label="consumer", description="The file path. For relative files this is the starting directory. For absolute files this is the absolute path.", javaType="String")
    public static final String FILE_PATH = "CamelFilePath";
    @Metadata(label="consumer", description="The relative path.", javaType="String")
    public static final String FILE_RELATIVE_PATH = "CamelFileRelativePath";
    @Metadata(description="The parent path.", javaType="String")
    public static final String FILE_PARENT = "CamelFileParent";
    @Metadata(label="producer", description="The actual absolute filepath (path + name) for the output file that was written. This header is set by Camel and its purpose is providing end-users with the name of the file that was written.", javaType="String")
    public static final String FILE_NAME_PRODUCED = "CamelFileNameProduced";
    @Metadata(label="producer", description="Is used for overruling `CamelFileName` header and use the value instead (but only once, as the producer will remove this header after writing the file). The value can be only be a String. Notice that if the option `fileName` has been configured, then this is still being evaluated.", javaType="Object")
    public static final String OVERRULE_FILE_NAME = "CamelOverruleFileName";
    @Metadata(description="The remote file input stream.", javaType="java.io.InputStream")
    public static final String REMOTE_FILE_INPUT_STREAM = "CamelRemoteFileInputStream";
    @Metadata(description="Path to the local work file, if local work directory is used.", javaType="String")
    public static final String FILE_LOCAL_WORK_PATH = "CamelFileLocalWorkPath";
    @Metadata(description="The remote hostname.", javaType="String")
    public static final String FILE_HOST = "CamelFileHost";

    private FilesConstants() {
    }
}

