/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.transcribe;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.transcribe.Transcribe2Configuration;
import org.apache.camel.component.aws2.transcribe.Transcribe2Endpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyResponse;

public class Transcribe2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Transcribe2Producer.class);
    private transient String transcribeProducerToString;

    public Transcribe2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.getConfiguration().getOperation()) {
            case startTranscriptionJob: {
                this.startTranscriptionJob(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case getTranscriptionJob: {
                this.getTranscriptionJob(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listTranscriptionJobs: {
                this.listTranscriptionJobs(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case deleteTranscriptionJob: {
                this.deleteTranscriptionJob(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case createVocabulary: {
                this.createVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case getVocabulary: {
                this.getVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listVocabularies: {
                this.listVocabularies(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case updateVocabulary: {
                this.updateVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case deleteVocabulary: {
                this.deleteVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case createVocabularyFilter: {
                this.createVocabularyFilter(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case getVocabularyFilter: {
                this.getVocabularyFilter(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listVocabularyFilters: {
                this.listVocabularyFilters(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case updateVocabularyFilter: {
                this.updateVocabularyFilter(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case deleteVocabularyFilter: {
                this.deleteVocabularyFilter(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case createLanguageModel: {
                this.createLanguageModel(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case describeLanguageModel: {
                this.describeLanguageModel(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listLanguageModels: {
                this.listLanguageModels(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case deleteLanguageModel: {
                this.deleteLanguageModel(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case createMedicalVocabulary: {
                this.createMedicalVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case getMedicalVocabulary: {
                this.getMedicalVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listMedicalVocabularies: {
                this.listMedicalVocabularies(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case updateMedicalVocabulary: {
                this.updateMedicalVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case deleteMedicalVocabulary: {
                this.deleteMedicalVocabulary(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case startMedicalTranscriptionJob: {
                this.startMedicalTranscriptionJob(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case getMedicalTranscriptionJob: {
                this.getMedicalTranscriptionJob(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listMedicalTranscriptionJobs: {
                this.listMedicalTranscriptionJobs(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case deleteMedicalTranscriptionJob: {
                this.deleteMedicalTranscriptionJob(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case tagResource: {
                this.tagResource(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case untagResource: {
                this.untagResource(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            case listTagsForResource: {
                this.listTagsForResource(this.getEndpoint().getTranscribeClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void startTranscriptionJob(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartTranscriptionJobRequest) {
                StartTranscriptionJobResponse result;
                try {
                    result = transcribeClient.startTranscriptionJob((StartTranscriptionJobRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Transcription Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartTranscriptionJobResponse result;
            StartTranscriptionJobRequest.Builder builder = StartTranscriptionJobRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeTranscriptionJobName"))) {
                String jobName = (String)exchange.getIn().getHeader("CamelAwsTranscribeTranscriptionJobName", String.class);
                builder.transcriptionJobName(jobName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeLanguageCode"))) {
                String languageCode = (String)exchange.getIn().getHeader("CamelAwsTranscribeLanguageCode", String.class);
                builder.languageCode(languageCode);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeMediaFormat"))) {
                String mediaFormat = (String)exchange.getIn().getHeader("CamelAwsTranscribeMediaFormat", String.class);
                builder.mediaFormat(mediaFormat);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeMediaUri"))) {
                String mediaUri = (String)exchange.getIn().getHeader("CamelAwsTranscribeMediaUri", String.class);
                builder.media((Media)Media.builder().mediaFileUri(mediaUri).build());
            }
            try {
                result = transcribeClient.startTranscriptionJob((StartTranscriptionJobRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Transcription Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getTranscriptionJob(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetTranscriptionJobRequest) {
                GetTranscriptionJobResponse result;
                try {
                    result = transcribeClient.getTranscriptionJob((GetTranscriptionJobRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Transcription Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetTranscriptionJobResponse result;
            GetTranscriptionJobRequest.Builder builder = GetTranscriptionJobRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeTranscriptionJobName"))) {
                String jobName = (String)exchange.getIn().getHeader("CamelAwsTranscribeTranscriptionJobName", String.class);
                builder.transcriptionJobName(jobName);
            }
            try {
                result = transcribeClient.getTranscriptionJob((GetTranscriptionJobRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Transcription Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listTranscriptionJobs(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListTranscriptionJobsRequest) {
                ListTranscriptionJobsResponse result;
                try {
                    result = transcribeClient.listTranscriptionJobs((ListTranscriptionJobsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Transcription Jobs command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListTranscriptionJobsResponse result;
            ListTranscriptionJobsRequest.Builder builder = ListTranscriptionJobsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeJobNameContains"))) {
                String jobNameContains = (String)exchange.getIn().getHeader("CamelAwsTranscribeJobNameContains", String.class);
                builder.jobNameContains(jobNameContains);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeStatus"))) {
                String status = (String)exchange.getIn().getHeader("CamelAwsTranscribeStatus", String.class);
                builder.status(status);
            }
            try {
                result = transcribeClient.listTranscriptionJobs((ListTranscriptionJobsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Transcription Jobs command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteTranscriptionJob(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteTranscriptionJobRequest) {
                try {
                    transcribeClient.deleteTranscriptionJob((DeleteTranscriptionJobRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Transcription Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
            }
        } else {
            DeleteTranscriptionJobRequest.Builder builder = DeleteTranscriptionJobRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeTranscriptionJobName"))) {
                String jobName = (String)exchange.getIn().getHeader("CamelAwsTranscribeTranscriptionJobName", String.class);
                builder.transcriptionJobName(jobName);
            }
            try {
                transcribeClient.deleteTranscriptionJob((DeleteTranscriptionJobRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Transcription Job command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
        }
    }

    private void createVocabulary(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateVocabularyRequest) {
                CreateVocabularyResponse result;
                try {
                    result = transcribeClient.createVocabulary((CreateVocabularyRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateVocabularyResponse result;
            CreateVocabularyRequest.Builder builder = CreateVocabularyRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName"))) {
                String vocabularyName = (String)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName", String.class);
                builder.vocabularyName(vocabularyName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeLanguageCode"))) {
                String languageCode = (String)exchange.getIn().getHeader("CamelAwsTranscribeLanguageCode", String.class);
                builder.languageCode(languageCode);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyPhrases"))) {
                String phrases = (String)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyPhrases", String.class);
                builder.phrases(new String[]{phrases});
            }
            try {
                result = transcribeClient.createVocabulary((CreateVocabularyRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getVocabulary(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetVocabularyRequest) {
                GetVocabularyResponse result;
                try {
                    result = transcribeClient.getVocabulary((GetVocabularyRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetVocabularyResponse result;
            GetVocabularyRequest.Builder builder = GetVocabularyRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName"))) {
                String vocabularyName = (String)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName", String.class);
                builder.vocabularyName(vocabularyName);
            }
            try {
                result = transcribeClient.getVocabulary((GetVocabularyRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listVocabularies(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListVocabulariesRequest) {
                ListVocabulariesResponse result;
                try {
                    result = transcribeClient.listVocabularies((ListVocabulariesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Vocabularies command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListVocabulariesResponse result;
            ListVocabulariesRequest.Builder builder = ListVocabulariesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeStatus"))) {
                String status = (String)exchange.getIn().getHeader("CamelAwsTranscribeStatus", String.class);
                builder.stateEquals(status);
            }
            try {
                result = transcribeClient.listVocabularies((ListVocabulariesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Vocabularies command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateVocabulary(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateVocabularyRequest) {
                UpdateVocabularyResponse result;
                try {
                    result = transcribeClient.updateVocabulary((UpdateVocabularyRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Update Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = this.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateVocabularyResponse result;
            UpdateVocabularyRequest.Builder builder = UpdateVocabularyRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName"))) {
                String vocabularyName = (String)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName", String.class);
                builder.vocabularyName(vocabularyName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeLanguageCode"))) {
                String languageCode = (String)exchange.getIn().getHeader("CamelAwsTranscribeLanguageCode", String.class);
                builder.languageCode(languageCode);
            }
            try {
                result = transcribeClient.updateVocabulary((UpdateVocabularyRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Update Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = this.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteVocabulary(TranscribeClient transcribeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteVocabularyRequest) {
                try {
                    transcribeClient.deleteVocabulary((DeleteVocabularyRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
            }
        } else {
            DeleteVocabularyRequest.Builder builder = DeleteVocabularyRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName"))) {
                String vocabularyName = (String)exchange.getIn().getHeader("CamelAwsTranscribeVocabularyName", String.class);
                builder.vocabularyName(vocabularyName);
            }
            try {
                transcribeClient.deleteVocabulary((DeleteVocabularyRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Vocabulary command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
        }
    }

    private void createVocabularyFilter(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void getVocabularyFilter(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void listVocabularyFilters(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void updateVocabularyFilter(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void deleteVocabularyFilter(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void createLanguageModel(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void describeLanguageModel(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void listLanguageModels(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void deleteLanguageModel(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void createMedicalVocabulary(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void getMedicalVocabulary(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void listMedicalVocabularies(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void updateMedicalVocabulary(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void deleteMedicalVocabulary(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void startMedicalTranscriptionJob(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void getMedicalTranscriptionJob(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void listMedicalTranscriptionJobs(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void deleteMedicalTranscriptionJob(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void tagResource(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void untagResource(TranscribeClient transcribeClient, Exchange exchange) {
    }

    private void listTagsForResource(TranscribeClient transcribeClient, Exchange exchange) {
    }

    protected Transcribe2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Transcribe2Endpoint getEndpoint() {
        return (Transcribe2Endpoint)super.getEndpoint();
    }

    private Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    public String toString() {
        if (this.transcribeProducerToString == null) {
            this.transcribeProducerToString = "Transcribe2Producer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.transcribeProducerToString;
    }
}

