/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.transcribe;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.transcribe.Transcribe2ComponentVerifierExtension;
import org.apache.camel.component.aws2.transcribe.Transcribe2Configuration;
import org.apache.camel.component.aws2.transcribe.Transcribe2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="aws2-transcribe")
public class Transcribe2Component
extends DefaultComponent {
    @Metadata
    private Transcribe2Configuration configuration = new Transcribe2Configuration();

    public Transcribe2Component() {
        this(null);
    }

    public Transcribe2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Transcribe2ComponentVerifierExtension("aws2-transcribe"));
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Label must be specified.");
        }
        Transcribe2Configuration configuration = this.configuration != null ? this.configuration.clone() : new Transcribe2Configuration();
        configuration.setLabel(remaining);
        Transcribe2Endpoint endpoint = new Transcribe2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ObjectHelper.isEmpty((String)endpoint.getConfiguration().getAccessKey())) {
            this.setAccessKeyOnEndpoint(endpoint);
        }
        if (ObjectHelper.isEmpty((String)endpoint.getConfiguration().getSecretKey())) {
            this.setSecretKeyOnEndpoint(endpoint);
        }
        if (ObjectHelper.isEmpty((String)endpoint.getConfiguration().getRegion())) {
            this.setRegionOnEndpoint(endpoint);
        }
        if (endpoint.getConfiguration().getTranscribeClient() == null && (endpoint.getConfiguration().getAccessKey() == null || endpoint.getConfiguration().getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon transcribe client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Transcribe2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Transcribe2Configuration configuration) {
        this.configuration = configuration;
    }

    private void setAccessKeyOnEndpoint(Transcribe2Endpoint endpoint) {
        String accessKey = System.getProperty("aws.accessKeyId");
        if (accessKey == null) {
            accessKey = System.getenv("AWS_ACCESS_KEY_ID");
        }
        if (accessKey != null) {
            endpoint.getConfiguration().setAccessKey(accessKey);
        }
    }

    private void setSecretKeyOnEndpoint(Transcribe2Endpoint endpoint) {
        String secretKey = System.getProperty("aws.secretKey");
        if (secretKey == null) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        }
        if (secretKey != null) {
            endpoint.getConfiguration().setSecretKey(secretKey);
        }
    }

    private void setRegionOnEndpoint(Transcribe2Endpoint endpoint) {
        String region = System.getProperty("aws.region");
        if (region == null) {
            region = System.getenv("AWS_REGION");
        }
        if (region != null) {
            endpoint.getConfiguration().setRegion(region);
        }
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isNotEmpty((Object)this.configuration) && ObjectHelper.isNotEmpty((Object)this.configuration.getTranscribeClient())) {
            this.configuration.getTranscribeClient().close();
        }
        super.doStop();
    }
}

