/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream.query;

import java.util.Map;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.query.Timestream2QueryEndpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;

public class Timestream2QueryProducerHealthCheck
extends AbstractHealthCheck {
    private final Timestream2QueryEndpoint timestream2QueryEndpoint;

    public Timestream2QueryProducerHealthCheck(Timestream2QueryEndpoint timestream2QueryEndpoint, String clientId) {
        super("camel", "producer:aws2-timestream-query-" + clientId);
        this.timestream2QueryEndpoint = timestream2QueryEndpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        Timestream2Configuration configuration = this.timestream2QueryEndpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !TimestreamQueryClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            TimestreamQueryClient client = this.timestream2QueryEndpoint.getAwsTimestreamQueryClient();
            client.describeEndpoints((DescribeEndpointsRequest)DescribeEndpointsRequest.builder().build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

