/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.timestream.Timestream2ClientType;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.query.Timestream2QueryEndpoint;
import org.apache.camel.component.aws2.timestream.write.Timestream2WriteEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-timestream")
public class Timestream2Component
extends HealthCheckComponent {
    @Metadata
    private Timestream2Configuration configuration = new Timestream2Configuration();

    public Timestream2Component() {
        this(null);
    }

    public Timestream2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Timestream2Configuration configuration;
        Timestream2Configuration timestream2Configuration = configuration = this.configuration != null ? this.configuration.copy() : new Timestream2Configuration();
        if (!remaining.isBlank()) {
            String[] uriPath = remaining.split(":");
            Timestream2ClientType timestream2ClientType = Timestream2ClientType.valueOf(uriPath[0]);
            if (Timestream2ClientType.write.equals((Object)timestream2ClientType)) {
                Timestream2WriteEndpoint timestream2WriteEndpoint = new Timestream2WriteEndpoint(uri, (Component)this, configuration);
                this.setProperties((Endpoint)timestream2WriteEndpoint, parameters);
                if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && configuration.getAwsTimestreamWriteClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
                    throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, Amazon Timestream Write client or accessKey and secretKey must be specified");
                }
                return timestream2WriteEndpoint;
            }
            if (Timestream2ClientType.query.equals((Object)timestream2ClientType)) {
                Timestream2QueryEndpoint timestream2QueryEndpoint = new Timestream2QueryEndpoint(uri, (Component)this, configuration);
                this.setProperties((Endpoint)timestream2QueryEndpoint, parameters);
                if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && configuration.getAwsTimestreamQueryClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
                    throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, Amazon Timestream Query client or accessKey and secretKey must be specified");
                }
                return timestream2QueryEndpoint;
            }
            throw new IllegalArgumentException("Invalid Endpoint Type. It should be either write or query");
        }
        throw new IllegalArgumentException("Type of Endpoint is missing from uri, it should be either write or query");
    }

    public Timestream2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Timestream2Configuration configuration) {
        this.configuration = configuration;
    }
}

