/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.textract;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.textract.Textract2Configuration;
import org.apache.camel.component.aws2.textract.Textract2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-textract")
public class Textract2Component
extends HealthCheckComponent {
    @Metadata
    private Textract2Configuration configuration = new Textract2Configuration();

    public Textract2Component() {
        this(null);
    }

    public Textract2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Textract2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Textract2Configuration();
        Textract2Endpoint endpoint = new Textract2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getTextractClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, Amazon Textract client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Textract2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Textract2Configuration configuration) {
        this.configuration = configuration;
    }
}

