/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.textract;

import java.util.Map;
import org.apache.camel.component.aws2.textract.Textract2Configuration;
import org.apache.camel.component.aws2.textract.Textract2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.Document;

public class Textract2ProducerHealthCheck
extends AbstractHealthCheck {
    private final Textract2Endpoint textract2Endpoint;

    public Textract2ProducerHealthCheck(Textract2Endpoint textract2Endpoint, String clientId) {
        super("camel", "producer:aws2-textract-" + clientId);
        this.textract2Endpoint = textract2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        Textract2Configuration configuration = this.textract2Endpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !TextractClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            TextractClient textractClient = this.textract2Endpoint.getTextractClient();
            byte[] testData = "test".getBytes();
            Document testDocument = (Document)Document.builder().bytes(SdkBytes.fromByteArray((byte[])testData)).build();
            DetectDocumentTextRequest testRequest = (DetectDocumentTextRequest)DetectDocumentTextRequest.builder().document(testDocument).build();
            textractClient.detectDocumentText(testRequest);
        }
        catch (AwsServiceException e) {
            if ("InvalidParameterException".equals(e.awsErrorDetails().errorCode()) || "UnsupportedDocumentException".equals(e.awsErrorDetails().errorCode())) {
                builder.up();
                return;
            }
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

