/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns.client;

import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.client.Sns2InternalClient;
import org.apache.camel.component.aws2.sns.client.impl.Sns2ClientIAMOptimized;
import org.apache.camel.component.aws2.sns.client.impl.Sns2ClientIAMProfileOptimized;
import org.apache.camel.component.aws2.sns.client.impl.Sns2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.sns.client.impl.Sns2ClientStandardImpl;

public final class Sns2ClientFactory {
    private Sns2ClientFactory() {
    }

    public static Sns2InternalClient getSnsClient(Sns2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new Sns2ClientIAMOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new Sns2ClientIAMProfileOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new Sns2ClientSessionTokenImpl(configuration);
        }
        return new Sns2ClientStandardImpl(configuration);
    }
}

