/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses.client;

import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.client.Ses2InternalClient;
import org.apache.camel.component.aws2.ses.client.impl.Ses2ClientOptimizedImpl;
import org.apache.camel.component.aws2.ses.client.impl.Ses2ClientProfileOptimizedImpl;
import org.apache.camel.component.aws2.ses.client.impl.Ses2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.ses.client.impl.Ses2ClientStandardImpl;

public final class Ses2ClientFactory {
    private Ses2ClientFactory() {
    }

    public static Ses2InternalClient getSesClient(Ses2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new Ses2ClientOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new Ses2ClientProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new Ses2ClientSessionTokenImpl(configuration);
        }
        return new Ses2ClientStandardImpl(configuration);
    }
}

