/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import java.util.Map;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.Ses2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ses.SesClient;

public class Ses2ProducerHealthCheck
extends AbstractHealthCheck {
    private final Ses2Endpoint ses2Endpoint;

    public Ses2ProducerHealthCheck(Ses2Endpoint ses2Endpoint, String clientId) {
        super("camel", "producer:aws2-ses-" + clientId);
        this.ses2Endpoint = ses2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        Ses2Configuration configuration = this.ses2Endpoint.getConfiguration();
        try {
            if (!SesClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            SesClient client = this.ses2Endpoint.getSESClient();
            client.getSendStatistics();
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            builder.down();
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

