/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Consumer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="aws2-s3", displayName="AWS S3", description="AWS S3 Consumer")
public class AWS2S3Console
extends AbstractDevConsole {
    public AWS2S3Console() {
        super("camel", "aws2-s3", "AWS S3", "AWS S3 Consumer");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> AWS2S3Consumer.class.getName().equals(c.getClass().getName())).collect(Collectors.toList());
        sb.append(String.format("    %s:%s:%s:%s:%s:%s:%s\n", "bucket", "accessKeys", "defaultCredentialsProvider", "profileCredentialsProvider", "maxMessages", "moveAfterRead", "deleteAfterRead"));
        for (Consumer c2 : list) {
            AWS2S3Consumer nc = (AWS2S3Consumer)c2;
            AWS2S3Configuration conf = nc.getEndpoint().getConfiguration();
            sb.append(String.format("    %s:%s:%s:%s:%s:%s:%s\n", conf.getBucketName(), conf.isUseDefaultCredentialsProvider() == false && !conf.isUseProfileCredentialsProvider(), conf.isUseDefaultCredentialsProvider(), conf.isUseProfileCredentialsProvider(), nc.getMaxMessagesPerPoll(), conf.isMoveAfterRead(), conf.isDeleteAfterRead()));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> AWS2S3Consumer.class.getName().equals(c.getClass().getName())).collect(Collectors.toList());
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        for (Consumer c2 : list) {
            AWS2S3Consumer nc = (AWS2S3Consumer)c2;
            AWS2S3Configuration conf = nc.getEndpoint().getConfiguration();
            JsonObject jo = new JsonObject();
            jo.put((Object)"bucket", (Object)conf.getBucketName());
            jo.put((Object)"accessKeys", (Object)(conf.isUseDefaultCredentialsProvider() == false && !conf.isUseProfileCredentialsProvider() ? 1 : 0));
            jo.put((Object)"defaultCredentialsProvider", (Object)conf.isUseDefaultCredentialsProvider());
            jo.put((Object)"profileCredentialsProvider", (Object)conf.isUseProfileCredentialsProvider());
            jo.put((Object)"maxMessages", (Object)nc.getMaxMessagesPerPoll());
            jo.put((Object)"moveAfterRead", (Object)conf.isMoveAfterRead());
            jo.put((Object)"deleteAfterRead", (Object)conf.isDeleteAfterRead());
            arr.add(jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"consumers", arr);
        }
        return root;
    }
}

