/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.stream;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import org.apache.camel.component.aws2.s3.utils.AWS2S3Utils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

public class AWS2S3StreamUploadProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3StreamUploadProducer.class);
    private static final String TIMEOUT_CHECKER_EXECUTOR_NAME = "S3_Streaming_Upload_Timeout_Checker";
    private AtomicInteger part = new AtomicInteger();
    private UploadState uploadAggregate = null;
    private final Map<Long, UploadState> timestampBasedUploads = new ConcurrentHashMap<Long, UploadState>();
    private final Lock lock = new ReentrantLock();
    private transient String s3ProducerToString;
    private ScheduledExecutorService timeoutCheckerExecutorService;
    private ChecksumAlgorithm algorithm = ChecksumAlgorithm.CRC32;

    public AWS2S3StreamUploadProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getConfiguration().getStreamingUploadTimeout() > 0L) {
            this.timeoutCheckerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, TIMEOUT_CHECKER_EXECUTOR_NAME);
            this.timeoutCheckerExecutorService.scheduleAtFixedRate(new StreamingUploadTimeoutTask(), this.getConfiguration().getStreamingUploadTimeout(), this.getConfiguration().getStreamingUploadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.getConfiguration().getRestartingPolicy().equals((Object)AWSS3RestartingPolicyEnum.lastPart)) {
            this.setStartingPart();
        }
    }

    protected void doStop() throws Exception {
        this.lock.lock();
        try {
            if (ObjectHelper.isNotEmpty((Object)this.uploadAggregate)) {
                this.uploadPart(this.uploadAggregate);
                this.completeUpload(this.uploadAggregate);
            }
            for (UploadState state : this.timestampBasedUploads.values()) {
                if (!ObjectHelper.isNotEmpty((Object)state) || state.buffer.size() <= 0) continue;
                this.uploadPart(state);
                this.completeUpload(state);
            }
            this.timestampBasedUploads.clear();
        }
        finally {
            this.lock.unlock();
        }
        if (this.timeoutCheckerExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getConfiguration().isTimestampGroupingEnabled()) {
            this.processWithTimestampGrouping(exchange);
        } else {
            this.processWithoutTimestampGrouping(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithoutTimestampGrouping(Exchange exchange) throws Exception {
        byte[] b;
        int maxRead;
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        UploadState state = null;
        int totalSize = 0;
        int n = maxRead = this.getConfiguration().isMultiPartUpload() ? Math.toIntExact(this.getConfiguration().getPartSize()) : this.getConfiguration().getBufferSize();
        if (this.uploadAggregate != null) {
            ++this.uploadAggregate.index;
            maxRead -= this.uploadAggregate.buffer.size();
        }
        while ((b = AWS2S3Utils.toByteArray(is, maxRead)).length > 0) {
            BucketCannedACL acl;
            String cannedAcl;
            totalSize += b.length;
            if (this.getConfiguration().isMultiPartUpload()) {
                maxRead -= b.length;
            }
            this.lock.lock();
            try {
                if (ObjectHelper.isNotEmpty((Object)this.uploadAggregate)) {
                    this.uploadAggregate.buffer.write(b);
                    if (this.getConfiguration().isMultiPartUpload() && (long)this.uploadAggregate.buffer.size() >= this.getConfiguration().getPartSize()) {
                        this.uploadPart(this.uploadAggregate);
                        maxRead = Math.toIntExact(this.getConfiguration().getPartSize());
                        continue;
                    }
                    if (this.uploadAggregate.buffer.size() < this.getConfiguration().getBatchSize() && (this.uploadAggregate.index < this.getConfiguration().getBatchMessageNumber() || (long)this.uploadAggregate.buffer.size() >= this.getConfiguration().getPartSize())) continue;
                    if (this.uploadAggregate.buffer.size() > 0) {
                        this.uploadPart(this.uploadAggregate);
                    }
                    CompleteMultipartUploadResponse uploadResult = this.completeUpload(this.uploadAggregate);
                    this.uploadAggregate = null;
                    Message message = AWS2S3StreamUploadProducer.getMessageForResponse(exchange);
                    message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
                    if (uploadResult.versionId() == null) continue;
                    message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
                    continue;
                }
            }
            finally {
                this.lock.unlock();
                continue;
            }
            if (state == null) {
                state = new UploadState();
            } else {
                state.index = 1;
            }
            state.buffer.write(b);
            String keyName = this.getConfiguration().getKeyName();
            String fileName = AWS2S3Utils.determineFileName(keyName);
            String extension = AWS2S3Utils.determineFileExtension(keyName);
            if (state.index == 1 && this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.random)) {
                state.id = UUID.randomUUID();
            }
            if (state.index == 1 && this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.timestamp)) {
                state.timestamp = System.currentTimeMillis();
            }
            state.dynamicKeyName = this.fileNameToUpload(fileName, this.getConfiguration().getNamingStrategy(), extension, state.part, state.id, state.timestamp);
            CreateMultipartUploadRequest.Builder createMultipartUploadRequest = CreateMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).checksumAlgorithm(this.algorithm);
            String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
            if (storageClass != null) {
                createMultipartUploadRequest.storageClass(storageClass);
            }
            if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
                ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
                createMultipartUploadRequest.acl(objectAcl);
            }
            if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
                createMultipartUploadRequest.acl(acl.toString());
            }
            AWS2S3Utils.setEncryption(createMultipartUploadRequest, this.getConfiguration());
            LOG.trace("Initiating multipart upload [{}] from exchange [{}]...", (Object)createMultipartUploadRequest, (Object)exchange);
            if (state.index == 1) {
                state.initResponse = this.getEndpoint().getS3Client().createMultipartUpload((CreateMultipartUploadRequest)createMultipartUploadRequest.build());
            }
            try {
                if (totalSize >= this.getConfiguration().getBatchSize() || state.buffer.size() >= this.getConfiguration().getBatchSize() || state.index >= this.getConfiguration().getBatchMessageNumber()) {
                    this.uploadPart(state);
                    CompleteMultipartUploadResponse uploadResult = this.completeUpload(state);
                    Message message = AWS2S3StreamUploadProducer.getMessageForResponse(exchange);
                    message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
                    if (uploadResult.versionId() != null) {
                        message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
                    }
                    state = null;
                    continue;
                }
                if (!this.getConfiguration().isMultiPartUpload() || (long)state.buffer.size() < this.getConfiguration().getPartSize()) continue;
                this.uploadPart(state);
                maxRead = Math.toIntExact(this.getConfiguration().getPartSize());
            }
            catch (Exception e) {
                this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build());
                throw e;
            }
        }
        if (ObjectHelper.isNotEmpty(state)) {
            this.lock.lock();
            try {
                if (ObjectHelper.isEmpty((Object)this.uploadAggregate)) {
                    this.uploadAggregate = state;
                } else {
                    this.uploadAggregate.buffer.write(state.buffer.toByteArray());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void processWithTimestampGrouping(Exchange exchange) throws Exception {
        byte[] b;
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        Long messageTimestamp = this.extractTimestampFromExchange(exchange);
        if (messageTimestamp == null) {
            LOG.warn("No valid timestamp found in exchange header '{}', falling back to current time", (Object)this.getConfiguration().getTimestampHeaderName());
            messageTimestamp = System.currentTimeMillis();
        }
        long timestampWindow = this.getTimestampWindow(messageTimestamp);
        int totalSize = 0;
        int maxRead = this.getConfiguration().isMultiPartUpload() ? Math.toIntExact(this.getConfiguration().getPartSize()) : this.getConfiguration().getBufferSize();
        UploadState state = this.timestampBasedUploads.get(timestampWindow);
        if (state != null) {
            ++state.index;
            maxRead -= state.buffer.size();
        }
        while ((b = AWS2S3Utils.toByteArray(is, maxRead)).length > 0) {
            totalSize += b.length;
            if (this.getConfiguration().isMultiPartUpload()) {
                maxRead -= b.length;
            }
            this.lock.lock();
            try {
                if (!this.timestampBasedUploads.containsKey(timestampWindow)) {
                    BucketCannedACL acl;
                    String cannedAcl;
                    UploadState newState = new UploadState();
                    String keyName = this.getConfiguration().getKeyName();
                    String fileName = AWS2S3Utils.determineFileName(keyName);
                    String extension = AWS2S3Utils.determineFileExtension(keyName);
                    newState.dynamicKeyName = this.generateTimestampBasedFileName(fileName, extension, timestampWindow);
                    CreateMultipartUploadRequest.Builder createMultipartUploadRequest = CreateMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(newState.dynamicKeyName).checksumAlgorithm(this.algorithm);
                    String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
                    if (storageClass != null) {
                        createMultipartUploadRequest.storageClass(storageClass);
                    }
                    if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
                        ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
                        createMultipartUploadRequest.acl(objectAcl);
                    }
                    if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
                        createMultipartUploadRequest.acl(acl.toString());
                    }
                    AWS2S3Utils.setEncryption(createMultipartUploadRequest, this.getConfiguration());
                    LOG.trace("Initiating multipart upload [{}] for timestamp window {}", (Object)createMultipartUploadRequest, (Object)timestampWindow);
                    newState.initResponse = this.getEndpoint().getS3Client().createMultipartUpload((CreateMultipartUploadRequest)createMultipartUploadRequest.build());
                    this.timestampBasedUploads.put(timestampWindow, newState);
                }
                state = this.timestampBasedUploads.get(timestampWindow);
                state.buffer.write(b);
                if (this.getConfiguration().isMultiPartUpload() && (long)state.buffer.size() >= this.getConfiguration().getPartSize()) {
                    this.uploadPart(state);
                    maxRead = Math.toIntExact(this.getConfiguration().getPartSize());
                    continue;
                }
                if (state.buffer.size() < this.getConfiguration().getBatchSize() && (state.index < this.getConfiguration().getBatchMessageNumber() || (long)state.buffer.size() >= this.getConfiguration().getPartSize())) continue;
                if (state.buffer.size() > 0) {
                    this.uploadPart(state);
                }
                CompleteMultipartUploadResponse uploadResult = this.completeUpload(state);
                this.timestampBasedUploads.remove(timestampWindow);
                Message message = AWS2S3StreamUploadProducer.getMessageForResponse(exchange);
                message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
                if (uploadResult.versionId() == null) continue;
                message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
            }
            catch (Exception e) {
                if (state != null && state.initResponse != null) {
                    this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build());
                    this.timestampBasedUploads.remove(timestampWindow);
                }
                throw e;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private CompleteMultipartUploadResponse completeUpload(UploadState state) {
        CompletedMultipartUpload completeMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(state.completedParts).build();
        CompleteMultipartUploadRequest compRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().multipartUpload(completeMultipartUpload).bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build();
        try {
            CompleteMultipartUploadResponse uploadResult = this.getEndpoint().getS3Client().completeMultipartUpload(compRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completed upload for the part {}, multipart {} with etag {} at index {}", new Object[]{this.part, state.multipartIndex, uploadResult.eTag(), state.index});
            }
            this.part.getAndIncrement();
            return uploadResult;
        }
        catch (Exception e) {
            LOG.warn("Error completing multipart upload - Multipart upload will be aborted", (Throwable)e);
            this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build());
            throw e;
        }
    }

    private void uploadPart(UploadState state) {
        UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).partNumber(Integer.valueOf(state.multipartIndex)).checksumAlgorithm(this.algorithm).build();
        LOG.trace("Uploading part {}, multipart {} at index {} for {}", new Object[]{state.part, state.multipartIndex, state.index, this.getConfiguration().getKeyName()});
        UploadPartResponse partResponse = this.getEndpoint().getS3Client().uploadPart(uploadRequest, RequestBody.fromBytes((byte[])state.buffer.toByteArray()));
        CompletedPart partUpload = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(state.multipartIndex)).checksumCRC32(partResponse.checksumCRC32()).eTag(partResponse.eTag()).build();
        state.completedParts.add(partUpload);
        state.buffer.reset();
        ++state.multipartIndex;
    }

    private String fileNameToUpload(String fileName, AWSS3NamingStrategyEnum strategy, String ext, int part, UUID id, long timestamp) {
        return switch (strategy) {
            case AWSS3NamingStrategyEnum.progressive -> {
                if (part > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        yield fileName + "-" + part + ext;
                    }
                    yield fileName + "-" + part;
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    yield fileName + ext;
                }
                yield fileName;
            }
            case AWSS3NamingStrategyEnum.random -> {
                if (part > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        yield fileName + "-" + id.toString() + ext;
                    }
                    yield fileName + "-" + id.toString();
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    yield fileName + ext;
                }
                yield fileName;
            }
            case AWSS3NamingStrategyEnum.timestamp -> {
                if (part > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        yield fileName + "-" + timestamp + ext;
                    }
                    yield fileName + "-" + timestamp;
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    yield fileName + ext;
                }
                yield fileName;
            }
            default -> throw new IllegalArgumentException("Unsupported operation");
        };
    }

    private long getTimestampWindow(long timestamp) {
        long windowSize = this.getConfiguration().getTimestampWindowSizeMillis();
        return timestamp / windowSize * windowSize;
    }

    private String generateTimestampBasedFileName(String baseFileName, String extension, long timestampWindow) {
        String timePattern;
        String datePattern;
        Date windowStart = new Date(timestampWindow);
        Date windowEnd = new Date(timestampWindow + this.getConfiguration().getTimestampWindowSizeMillis());
        if (this.getConfiguration().getTimestampWindowSizeMillis() < 60000L) {
            datePattern = "yyyyMMdd_HHmmss";
            timePattern = "HHmmss";
        } else {
            datePattern = "yyyyMMdd_HHmm";
            timePattern = "HHmm";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat timeFormat = new SimpleDateFormat(timePattern);
        timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timeRange = timeFormat.format(windowStart) + "-" + timeFormat.format(windowEnd);
        if (extension != null && !extension.isEmpty()) {
            return baseFileName + "_" + sdf.format(windowStart) + "_" + timeRange + extension;
        }
        return baseFileName + "_" + sdf.format(windowStart) + "_" + timeRange;
    }

    private Long extractTimestampFromExchange(Exchange exchange) {
        String headerName = this.getConfiguration().getTimestampHeaderName();
        Object timestampObj = exchange.getIn().getHeader(headerName);
        if (timestampObj instanceof Long) {
            return (Long)timestampObj;
        }
        if (timestampObj instanceof Date) {
            return ((Date)timestampObj).getTime();
        }
        if (timestampObj instanceof String) {
            try {
                return Long.parseLong((String)timestampObj);
            }
            catch (NumberFormatException e) {
                LOG.warn("Cannot parse timestamp header '{}' with value '{}'", (Object)headerName, timestampObj);
                return null;
            }
        }
        if (timestampObj != null) {
            LOG.warn("Unsupported timestamp header type: {} for header '{}'", timestampObj.getClass(), (Object)headerName);
        }
        return null;
    }

    private void setStartingPart() {
        if (this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.progressive)) {
            ArrayList<S3Object> list = new ArrayList<S3Object>();
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.getConfiguration().getBucketName()).prefix(AWS2S3Utils.determineFileName(this.getConfiguration().getKeyName())).build();
            ListObjectsV2Iterable listRes = this.getEndpoint().getS3Client().listObjectsV2Paginator(request);
            listRes.stream().flatMap(r -> r.contents().stream()).forEach(content -> list.add((S3Object)content));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(S3Object::lastModified));
                int listSize = list.size();
                String fileName = AWS2S3Utils.determineFileName(((S3Object)list.get(listSize - 1)).key());
                int position = fileName.lastIndexOf("-");
                if (position != -1) {
                    String partString = fileName.substring(position + 1);
                    if (ObjectHelper.isNotEmpty((String)partString)) {
                        this.part.getAndSet(Integer.parseInt(partString) + 1);
                    }
                } else {
                    this.part.getAndSet(1);
                }
            }
        } else {
            LOG.info("lastPart restarting policy can be used only with progressive naming strategy");
        }
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.s3ProducerToString == null) {
            this.s3ProducerToString = "AWS2S3StreamUploadProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ProducerToString;
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private class UploadState {
        int index = 1;
        int multipartIndex = 1;
        int part;
        List<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        ByteArrayOutputStream buffer;
        String dynamicKeyName;
        UUID id;
        long timestamp;
        CreateMultipartUploadResponse initResponse;

        UploadState() {
            this.part = AWS2S3StreamUploadProducer.this.part.get();
            this.buffer = new ByteArrayOutputStream();
        }
    }

    private final class StreamingUploadTimeoutTask
    implements Runnable {
        private StreamingUploadTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AWS2S3StreamUploadProducer.this.lock.lock();
            try {
                if (ObjectHelper.isNotEmpty((Object)AWS2S3StreamUploadProducer.this.uploadAggregate)) {
                    AWS2S3StreamUploadProducer.this.uploadPart(AWS2S3StreamUploadProducer.this.uploadAggregate);
                    AWS2S3StreamUploadProducer.this.completeUpload(AWS2S3StreamUploadProducer.this.uploadAggregate);
                    AWS2S3StreamUploadProducer.this.uploadAggregate = null;
                }
                if (AWS2S3StreamUploadProducer.this.getConfiguration().isTimestampGroupingEnabled()) {
                    ArrayList<Long> keysToRemove = new ArrayList<Long>();
                    for (Map.Entry<Long, UploadState> entry : AWS2S3StreamUploadProducer.this.timestampBasedUploads.entrySet()) {
                        UploadState state = entry.getValue();
                        if (!ObjectHelper.isNotEmpty((Object)state) || state.buffer.size() <= 0) continue;
                        AWS2S3StreamUploadProducer.this.uploadPart(state);
                        AWS2S3StreamUploadProducer.this.completeUpload(state);
                        keysToRemove.add(entry.getKey());
                    }
                    keysToRemove.forEach(AWS2S3StreamUploadProducer.this.timestampBasedUploads::remove);
                }
            }
            finally {
                AWS2S3StreamUploadProducer.this.lock.unlock();
            }
        }
    }
}

