/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.component.aws2.s3.utils.AWS2S3Utils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.BucketLocationConstraint;
import software.amazon.awssdk.services.s3.model.BucketVersioningStatus;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GlacierJobParameters;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.MFADelete;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.RestoreRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.model.Tier;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

public class AWS2S3Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3Producer.class);

    public AWS2S3Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        AWS2S3Operations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            if (this.getConfiguration().isMultiPartUpload()) {
                this.processMultiPart(exchange);
            } else {
                this.processSingleOp(exchange);
            }
        } else {
            switch (operation) {
                case copyObject: {
                    this.copyObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteObject: {
                    this.deleteObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteObjects: {
                    this.deleteObjects(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case listBuckets: {
                    this.listBuckets(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteBucket: {
                    this.deleteBucket(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case listObjects: {
                    this.listObjects(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getObject: {
                    this.getObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getObjectRange: {
                    this.getObjectRange(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case createDownloadLink: {
                    this.createDownloadLink(exchange);
                    break;
                }
                case createUploadLink: {
                    this.createUploadLink(exchange);
                    break;
                }
                case headBucket: {
                    this.headBucket(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case headObject: {
                    this.headObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case restoreObject: {
                    this.restoreObject(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getObjectTagging: {
                    this.getObjectTagging(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case putObjectTagging: {
                    this.putObjectTagging(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteObjectTagging: {
                    this.deleteObjectTagging(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getObjectAcl: {
                    this.getObjectAcl(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case putObjectAcl: {
                    this.putObjectAcl(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case createBucket: {
                    this.createBucket(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getBucketTagging: {
                    this.getBucketTagging(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case putBucketTagging: {
                    this.putBucketTagging(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteBucketTagging: {
                    this.deleteBucketTagging(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getBucketVersioning: {
                    this.getBucketVersioning(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case putBucketVersioning: {
                    this.putBucketVersioning(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case getBucketPolicy: {
                    this.getBucketPolicy(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case putBucketPolicy: {
                    this.putBucketPolicy(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                case deleteBucketPolicy: {
                    this.deleteBucketPolicy(this.getEndpoint().getS3Client(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    public void processMultiPart(Exchange exchange) throws Exception {
        CompleteMultipartUploadResponse uploadResult;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        BucketCannedACL acl;
        String cannedAcl;
        InputStream inputStream;
        Object obj = exchange.getIn().getBody();
        File filePayload = null;
        long contentLength = (Long)exchange.getIn().getHeader("CamelAwsS3ContentLength", (Object)-1, Long.class);
        if (obj instanceof WrappedFile) {
            WrappedFile wf = (WrappedFile)obj;
            obj = wf.getFile();
        }
        if (obj instanceof File) {
            File f;
            filePayload = f = (File)obj;
            inputStream = new FileInputStream(f);
            contentLength = f.length();
        } else {
            inputStream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            if (contentLength <= 0L && (contentLength = AWS2S3Utils.determineLengthInputStream(inputStream)) == -1L) {
                LOG.debug("The content length is not defined. It needs to be determined by reading the data into memory");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOHelper.copyAndCloseInput((InputStream)inputStream, (OutputStream)baos);
                byte[] arr = baos.toByteArray();
                contentLength = arr.length;
                inputStream = new ByteArrayInputStream(arr);
            }
        }
        Map<String, String> objectMetadata = this.determineMetadata(exchange);
        long partSize = this.getConfiguration().getPartSize();
        if (contentLength == 0L || contentLength < partSize) {
            LOG.debug("Payload size < partSize ({} > {}). Uploading payload in single operation", (Object)contentLength, (Object)partSize);
            this.doPutObject(exchange, objectMetadata, filePayload, inputStream, contentLength);
            return;
        }
        LOG.debug("Payload size >= partSize ({} > {}). Uploading payload using multi-part operation", (Object)contentLength, (Object)partSize);
        objectMetadata.put("Content-Length", "" + contentLength);
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        CreateMultipartUploadRequest.Builder createMultipartUploadRequest = CreateMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(keyName);
        String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
        if (storageClass != null) {
            createMultipartUploadRequest.storageClass(storageClass);
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
            createMultipartUploadRequest.acl(objectAcl);
        }
        if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
            createMultipartUploadRequest.acl(acl.toString());
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            createMultipartUploadRequest.contentType(contentType);
        }
        if ((cacheControl = (String)exchange.getIn().getHeader("CamelAwsS3ContentControl", String.class)) != null) {
            createMultipartUploadRequest.cacheControl(cacheControl);
        }
        if ((contentDisposition = (String)exchange.getIn().getHeader("CamelAwsS3ContentDisposition", String.class)) != null) {
            createMultipartUploadRequest.contentDisposition(contentDisposition);
        }
        if ((contentEncoding = (String)exchange.getIn().getHeader("CamelAwsS3ContentEncoding", String.class)) != null) {
            createMultipartUploadRequest.contentEncoding(contentEncoding);
        }
        AWS2S3Utils.setEncryption(createMultipartUploadRequest, this.getConfiguration());
        LOG.trace("Initiating multipart upload [{}] from exchange [{}]...", (Object)createMultipartUploadRequest, (Object)exchange);
        CreateMultipartUploadResponse initResponse = this.getEndpoint().getS3Client().createMultipartUpload((CreateMultipartUploadRequest)createMultipartUploadRequest.build());
        ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        long position = 0L;
        try {
            int part = 1;
            while (position < contentLength) {
                partSize = Math.min(partSize, contentLength - position);
                UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.getConfiguration().getBucketName()).key(keyName).uploadId(initResponse.uploadId()).partNumber(Integer.valueOf(part)).build();
                LOG.debug("Uploading multi-part [{}] at position: [{}] for {}", new Object[]{part, position, keyName});
                String etag = this.getEndpoint().getS3Client().uploadPart(uploadRequest, RequestBody.fromInputStream((InputStream)inputStream, (long)partSize)).eTag();
                CompletedPart partUpload = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(part)).eTag(etag).build();
                completedParts.add(partUpload);
                position += partSize;
                ++part;
            }
            LOG.debug("Completing multi-part upload for {}", (Object)keyName);
            CompletedMultipartUpload completeMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
            CompleteMultipartUploadRequest.Builder compRequestBuilder = CompleteMultipartUploadRequest.builder().multipartUpload(completeMultipartUpload).bucket(this.getConfiguration().getBucketName()).key(keyName).uploadId(initResponse.uploadId());
            if (this.getConfiguration().isConditionalWritesEnabled()) {
                compRequestBuilder.ifNoneMatch("*");
            }
            uploadResult = this.getEndpoint().getS3Client().completeMultipartUpload((CompleteMultipartUploadRequest)compRequestBuilder.build());
        }
        catch (Exception e) {
            this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(keyName).uploadId(initResponse.uploadId()).build());
            throw e;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
        message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
        message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        if (uploadResult.versionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
        }
        if (filePayload != null && this.getConfiguration().isDeleteAfterWrite()) {
            FileUtil.deleteFile((File)filePayload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSingleOp(Exchange exchange) throws Exception {
        long contentLength = (Long)exchange.getIn().getHeader("CamelAwsS3ContentLength", (Object)-1, Long.class);
        Object obj = exchange.getIn().getMandatoryBody();
        InputStream inputStream = null;
        File filePayload = null;
        try {
            if (obj instanceof WrappedFile) {
                obj = ((WrappedFile)obj).getFile();
            }
            if (obj instanceof File) {
                filePayload = (File)obj;
                contentLength = filePayload.length();
            } else {
                inputStream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                if (contentLength <= 0L && (contentLength = AWS2S3Utils.determineLengthInputStream(inputStream)) == -1L) {
                    LOG.debug("The content length is not defined. It needs to be determined by reading the data into memory");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOHelper.copyAndCloseInput((InputStream)inputStream, (OutputStream)baos);
                    byte[] arr = baos.toByteArray();
                    contentLength = arr.length;
                    inputStream = new ByteArrayInputStream(arr);
                }
            }
            Map<String, String> objectMetadata = this.determineMetadata(exchange);
            this.doPutObject(exchange, objectMetadata, filePayload, inputStream, contentLength);
        }
        catch (Throwable throwable) {
            IOHelper.close(inputStream);
            throw throwable;
        }
        IOHelper.close((Closeable)inputStream);
        if (this.getConfiguration().isDeleteAfterWrite() && filePayload != null) {
            FileUtil.deleteFile((File)filePayload);
        }
    }

    private void doPutObject(Exchange exchange, Map<String, String> objectMetadata, File file, InputStream inputStream, long contentLength) {
        String contentMd5;
        BucketCannedACL acl;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        String cannedAcl;
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        PutObjectRequest.Builder putObjectRequest = PutObjectRequest.builder();
        putObjectRequest.bucket(bucketName).key(keyName).metadata(objectMetadata);
        String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
        if (storageClass != null) {
            putObjectRequest.storageClass(storageClass);
        }
        if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
            ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
            putObjectRequest.acl(objectAcl);
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            putObjectRequest.contentType(contentType);
        }
        if ((cacheControl = (String)exchange.getIn().getHeader("CamelAwsS3ContentControl", String.class)) != null) {
            putObjectRequest.cacheControl(cacheControl);
        }
        if ((contentDisposition = (String)exchange.getIn().getHeader("CamelAwsS3ContentDisposition", String.class)) != null) {
            putObjectRequest.contentDisposition(contentDisposition);
        }
        if ((contentEncoding = (String)exchange.getIn().getHeader("CamelAwsS3ContentEncoding", String.class)) != null) {
            putObjectRequest.contentEncoding(contentEncoding);
        }
        if (contentLength > 0L) {
            putObjectRequest.contentLength(Long.valueOf(contentLength));
        }
        if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
            putObjectRequest.acl(acl.toString());
        }
        if ((contentMd5 = (String)exchange.getIn().getHeader("CamelAwsS3ContentMD5", String.class)) != null) {
            putObjectRequest.contentMD5(contentMd5);
        }
        if (this.getConfiguration().isUseAwsKMS() && ObjectHelper.isNotEmpty((String)this.getConfiguration().getAwsKMSKeyId())) {
            putObjectRequest.ssekmsKeyId(this.getConfiguration().getAwsKMSKeyId());
            putObjectRequest.serverSideEncryption(ServerSideEncryption.AWS_KMS);
        }
        if (this.getConfiguration().isUseSSES3()) {
            putObjectRequest.serverSideEncryption(ServerSideEncryption.AES256);
        }
        if (this.getConfiguration().isUseCustomerKey()) {
            if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerKeyId())) {
                putObjectRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
            }
            if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerKeyMD5())) {
                putObjectRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
            }
            if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerAlgorithm())) {
                putObjectRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
            }
        }
        if (this.getConfiguration().isConditionalWritesEnabled()) {
            putObjectRequest.ifNoneMatch("*");
        }
        LOG.trace("Put object [{}] from exchange [{}]...", (Object)putObjectRequest, (Object)exchange);
        RequestBody rb = file != null ? RequestBody.fromFile((File)file) : RequestBody.fromInputStream((InputStream)inputStream, (long)contentLength);
        PutObjectResponse putObjectResult = this.getEndpoint().getS3Client().putObject((PutObjectRequest)putObjectRequest.build(), rb);
        LOG.trace("Received result [{}]", (Object)putObjectResult);
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)putObjectResult.eTag());
        message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
        message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        if (putObjectResult.versionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)putObjectResult.versionId());
        }
    }

    private void copyObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        String destinationKey = (String)exchange.getIn().getHeader("CamelAwsS3DestinationKey", String.class);
        String bucketNameDestination = (String)exchange.getIn().getHeader("CamelAwsS3BucketDestinationName", String.class);
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CopyObjectRequest) {
                CopyObjectResponse result = s3Client.copyObject((CopyObjectRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            if (ObjectHelper.isEmpty((String)bucketNameDestination)) {
                throw new IllegalArgumentException("Bucket Name Destination must be specified for copyObject Operation");
            }
            if (ObjectHelper.isEmpty((String)destinationKey)) {
                throw new IllegalArgumentException("Destination Key must be specified for copyObject Operation");
            }
            CopyObjectRequest.Builder copyObjectRequest = CopyObjectRequest.builder().destinationBucket(bucketNameDestination).destinationKey(destinationKey).sourceBucket(bucketName).sourceKey(keyName);
            if (this.getConfiguration().isUseAwsKMS() && ObjectHelper.isNotEmpty((String)this.getConfiguration().getAwsKMSKeyId())) {
                copyObjectRequest.ssekmsKeyId(this.getConfiguration().getAwsKMSKeyId());
                copyObjectRequest.serverSideEncryption(ServerSideEncryption.AWS_KMS);
            }
            if (this.getConfiguration().isUseSSES3()) {
                copyObjectRequest.serverSideEncryption(ServerSideEncryption.AES256);
            }
            if (this.getConfiguration().isUseCustomerKey()) {
                if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerKeyId())) {
                    copyObjectRequest.sseCustomerKey(this.getConfiguration().getCustomerKeyId());
                }
                if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerKeyMD5())) {
                    copyObjectRequest.sseCustomerKeyMD5(this.getConfiguration().getCustomerKeyMD5());
                }
                if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getCustomerAlgorithm())) {
                    copyObjectRequest.sseCustomerAlgorithm(this.getConfiguration().getCustomerAlgorithm());
                }
            }
            String ifMatchCondition = (String)exchange.getMessage().getHeader("CamelAwsS3IfMatchCondition", String.class);
            Instant ifModifiedSinceCondition = (Instant)exchange.getMessage().getHeader("CamelAwsS3IfModifiedSinceCondition", Instant.class);
            String ifNoneMatchCondition = (String)exchange.getMessage().getHeader("CamelAwsS3IfNoneMatchCondition", String.class);
            Instant ifUnmodifiedSince = (Instant)exchange.getMessage().getHeader("CamelAwsS3IfUnmodifiedSinceCondition", Instant.class);
            if (ObjectHelper.isNotEmpty((String)ifMatchCondition)) {
                copyObjectRequest.copySourceIfMatch(ifMatchCondition);
            }
            if (ObjectHelper.isNotEmpty((Object)ifModifiedSinceCondition)) {
                copyObjectRequest.copySourceIfModifiedSince(ifModifiedSinceCondition);
            }
            if (ObjectHelper.isNotEmpty((String)ifNoneMatchCondition)) {
                copyObjectRequest.copySourceIfNoneMatch(ifNoneMatchCondition);
            }
            if (ObjectHelper.isNotEmpty((Object)ifUnmodifiedSince)) {
                copyObjectRequest.copySourceIfUnmodifiedSince(ifUnmodifiedSince);
            }
            CopyObjectResponse copyObjectResult = s3Client.copyObject((CopyObjectRequest)copyObjectRequest.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            if (copyObjectResult.versionId() != null) {
                message.setHeader("CamelAwsS3VersionId", (Object)copyObjectResult.versionId());
            }
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void deleteObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteObjectRequest) {
                s3Client.deleteObject((DeleteObjectRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)true);
            }
        } else {
            DeleteObjectRequest.Builder deleteObjectRequest = DeleteObjectRequest.builder().bucket(bucketName).key(keyName);
            s3Client.deleteObject((DeleteObjectRequest)deleteObjectRequest.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)true);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void listBuckets(S3Client s3Client, Exchange exchange) {
        ListBucketsResponse bucketsList = s3Client.listBuckets();
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setBody((Object)bucketsList.buckets());
    }

    private void deleteBucket(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteBucketRequest) {
                DeleteBucketResponse resp = s3Client.deleteBucket((DeleteBucketRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)resp);
            }
        } else {
            DeleteBucketRequest.Builder deleteBucketRequest = DeleteBucketRequest.builder().bucket(bucketName);
            DeleteBucketResponse resp = s3Client.deleteBucket((DeleteBucketRequest)deleteBucketRequest.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)resp);
        }
    }

    private void getObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetObjectRequest) {
                ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)payload, ResponseTransformer.toInputStream());
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                if (!this.getConfiguration().isIgnoreBody()) {
                    message.setBody((Object)res);
                }
                AWS2S3Producer.populateMetadata((ResponseInputStream<GetObjectResponse>)res, message);
            }
        } else {
            String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
            String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
            String ifMatchCondition = (String)exchange.getMessage().getHeader("CamelAwsS3IfMatchCondition", String.class);
            Instant ifModifiedSinceCondition = (Instant)exchange.getMessage().getHeader("CamelAwsS3IfModifiedSinceCondition", Instant.class);
            String ifNoneMatchCondition = (String)exchange.getMessage().getHeader("CamelAwsS3IfNoneMatchCondition", String.class);
            Instant ifUnmodifiedSince = (Instant)exchange.getMessage().getHeader("CamelAwsS3IfUnmodifiedSinceCondition", Instant.class);
            GetObjectRequest.Builder req = GetObjectRequest.builder().bucket(bucketName).key(keyName);
            if (ObjectHelper.isNotEmpty((String)ifMatchCondition)) {
                req.ifMatch(ifMatchCondition);
            }
            if (ObjectHelper.isNotEmpty((Object)ifModifiedSinceCondition)) {
                req.ifModifiedSince(ifModifiedSinceCondition);
            }
            if (ObjectHelper.isNotEmpty((String)ifNoneMatchCondition)) {
                req.ifNoneMatch(ifNoneMatchCondition);
            }
            if (ObjectHelper.isNotEmpty((Object)ifUnmodifiedSince)) {
                req.ifUnmodifiedSince(ifUnmodifiedSince);
            }
            ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)req.build(), ResponseTransformer.toInputStream());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            if (!this.getConfiguration().isIgnoreBody()) {
                message.setBody((Object)res);
            }
            AWS2S3Producer.populateMetadata((ResponseInputStream<GetObjectResponse>)res, message);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void getObjectRange(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        String rangeStart = (String)exchange.getIn().getHeader("CamelAwsS3RangeStart", String.class);
        String rangeEnd = (String)exchange.getIn().getHeader("CamelAwsS3RangeEnd", String.class);
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetObjectRequest) {
                ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)payload, ResponseTransformer.toInputStream());
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)res);
            }
        } else {
            if (ObjectHelper.isEmpty((String)rangeStart) || ObjectHelper.isEmpty((String)rangeEnd)) {
                throw new IllegalArgumentException("A Range start and range end header must be configured to perform a range get operation.");
            }
            GetObjectRequest.Builder req = GetObjectRequest.builder().bucket(bucketName).key(keyName).range("bytes=" + Long.parseLong(rangeStart) + "-" + Long.parseLong(rangeEnd));
            ResponseInputStream res = (ResponseInputStream)s3Client.getObject((GetObjectRequest)req.build(), ResponseTransformer.toInputStream());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)res);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void listObjects(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListObjectsRequest) {
                ListObjectsResponse objectList = s3Client.listObjects((ListObjectsRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)objectList.contents());
            }
        } else {
            String delimiter = (String)exchange.getIn().getHeader("CamelAwsS3Delimiter", (Object)this.getConfiguration().getDelimiter(), String.class);
            String prefix = (String)exchange.getIn().getHeader("CamelAwsS3Prefix", (Object)this.getConfiguration().getPrefix(), String.class);
            ListObjectsRequest listObjectsRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(bucketName).delimiter(delimiter).prefix(prefix).build();
            ListObjectsResponse objectList = s3Client.listObjects(listObjectsRequest);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)objectList.contents());
        }
    }

    private void createDownloadLink(Exchange exchange) {
        S3Presigner presigner;
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        long milliSeconds = 0L;
        Long expirationMillis = (Long)exchange.getIn().getHeader("CamelAwsS3DowloadLinkExpirationTime", Long.class);
        milliSeconds = expirationMillis != null ? (milliSeconds += expirationMillis.longValue()) : (milliSeconds += 3600000L);
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAmazonS3Presigner())) {
            presigner = this.getConfiguration().getAmazonS3Presigner();
        } else {
            S3Presigner.Builder builder = S3Presigner.builder();
            builder.credentialsProvider((AwsCredentialsProvider)(this.getConfiguration().isUseDefaultCredentialsProvider() != false ? DefaultCredentialsProvider.create() : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getConfiguration().getAccessKey(), (String)this.getConfiguration().getSecretKey())))).region(Region.of((String)this.getConfiguration().getRegion()));
            String uriEndpointOverride = this.getConfiguration().getUriEndpointOverride();
            if (ObjectHelper.isNotEmpty((String)uriEndpointOverride)) {
                builder.endpointOverride(URI.create(uriEndpointOverride));
            }
            presigner = builder.build();
        }
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(keyName).build();
        GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMillis(milliSeconds)).getObjectRequest(getObjectRequest).build();
        PresignedGetObjectRequest presignedGetObjectRequest = presigner.presignGetObject(getObjectPresignRequest);
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setBody((Object)presignedGetObjectRequest.url().toString());
        message.setHeader("CamelAwsS3DownloadLinkBrowserCompatible", (Object)presignedGetObjectRequest.isBrowserExecutable());
        message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
        message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        if (!presignedGetObjectRequest.isBrowserExecutable()) {
            LOG.debug("The download link url is not browser compatible and please check the option of checksum validations in Amazon S3 client");
            message.setHeader("CamelAwsS3DownloadLinkHttpRequestHeaders", (Object)presignedGetObjectRequest.httpRequest().headers());
            presignedGetObjectRequest.signedPayload().ifPresent(payload -> message.setHeader("CamelAwsS3DownloadLinkSignedPayload", (Object)payload.asUtf8String()));
        }
        if (ObjectHelper.isEmpty((Object)this.getConfiguration().getAmazonS3Presigner())) {
            presigner.close();
        }
    }

    private void headBucket(S3Client s3Client, Exchange exchange) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3OverrideBucketName", String.class);
        if (ObjectHelper.isEmpty((String)bucketName)) {
            throw new IllegalArgumentException("Head Bucket operation requires to specify a bucket name via Header");
        }
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        boolean exists = true;
        try {
            HeadBucketResponse headBucketResponse = s3Client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
            if (!this.getConfiguration().isIgnoreBody()) {
                message.setBody((Object)headBucketResponse);
            }
        }
        catch (NoSuchBucketException e) {
            exists = false;
        }
        message.setHeader("CamelAwsS3BucketExists", (Object)exists);
    }

    private void headObject(S3Client s3Client, Exchange exchange) {
        String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (ObjectHelper.isEmpty((String)key)) {
            throw new IllegalArgumentException("Head Object operation requires to specify a bucket name via Header");
        }
        HeadObjectResponse headObjectResponse = s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(AWS2S3Utils.determineBucketName(exchange, this.getConfiguration())).key(key).build());
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setBody((Object)headObjectResponse);
    }

    private void deleteObjects(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteObjectsRequest) {
                DeleteObjectsResponse result = s3Client.deleteObjects((DeleteObjectsRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            List keysToDelete = (List)exchange.getIn().getHeader("CamelAwsS3KeysToDelete", List.class);
            if (ObjectHelper.isEmpty((Collection)keysToDelete)) {
                throw new IllegalArgumentException("Keys to delete must be specified for deleteObjects Operation");
            }
            ArrayList<ObjectIdentifier> objectIdentifiers = new ArrayList<ObjectIdentifier>();
            for (String key : keysToDelete) {
                objectIdentifiers.add((ObjectIdentifier)ObjectIdentifier.builder().key(key).build());
            }
            Delete delete = (Delete)Delete.builder().objects(objectIdentifiers).build();
            DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete(delete).build();
            DeleteObjectsResponse result = s3Client.deleteObjects(deleteObjectsRequest);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void restoreObject(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RestoreObjectRequest) {
                RestoreObjectResponse result = s3Client.restoreObject((RestoreObjectRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            Integer days = (Integer)exchange.getIn().getHeader("CamelAwsS3RestoreDays", (Object)1, Integer.class);
            String tier = (String)exchange.getIn().getHeader("CamelAwsS3RestoreTier", (Object)"Standard", String.class);
            GlacierJobParameters glacierJobParameters = (GlacierJobParameters)GlacierJobParameters.builder().tier(Tier.fromValue((String)tier)).build();
            RestoreRequest restoreRequest = (RestoreRequest)RestoreRequest.builder().days(days).glacierJobParameters(glacierJobParameters).build();
            RestoreObjectRequest.Builder requestBuilder = RestoreObjectRequest.builder().bucket(bucketName).key(keyName).restoreRequest(restoreRequest);
            RestoreObjectResponse result = s3Client.restoreObject((RestoreObjectRequest)requestBuilder.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void getObjectTagging(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetObjectTaggingRequest) {
                GetObjectTaggingResponse result = s3Client.getObjectTagging((GetObjectTaggingRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result.tagSet());
            }
        } else {
            GetObjectTaggingRequest request = (GetObjectTaggingRequest)GetObjectTaggingRequest.builder().bucket(bucketName).key(keyName).build();
            GetObjectTaggingResponse result = s3Client.getObjectTagging(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result.tagSet());
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void putObjectTagging(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutObjectTaggingRequest) {
                PutObjectTaggingResponse result = s3Client.putObjectTagging((PutObjectTaggingRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            Map tags = (Map)exchange.getIn().getHeader("CamelAwsS3ObjectTags", Map.class);
            if (ObjectHelper.isEmpty((Map)tags)) {
                throw new IllegalArgumentException("Object tags must be specified for putObjectTagging Operation");
            }
            ArrayList<Tag> tagSet = new ArrayList<Tag>();
            for (Map.Entry entry : tags.entrySet()) {
                tagSet.add((Tag)Tag.builder().key((String)entry.getKey()).value((String)entry.getValue()).build());
            }
            Tagging tagging = (Tagging)Tagging.builder().tagSet(tagSet).build();
            PutObjectTaggingRequest request = (PutObjectTaggingRequest)PutObjectTaggingRequest.builder().bucket(bucketName).key(keyName).tagging(tagging).build();
            PutObjectTaggingResponse result = s3Client.putObjectTagging(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void deleteObjectTagging(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteObjectTaggingRequest) {
                DeleteObjectTaggingResponse result = s3Client.deleteObjectTagging((DeleteObjectTaggingRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteObjectTaggingRequest request = (DeleteObjectTaggingRequest)DeleteObjectTaggingRequest.builder().bucket(bucketName).key(keyName).build();
            DeleteObjectTaggingResponse result = s3Client.deleteObjectTagging(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void getObjectAcl(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetObjectAclRequest) {
                GetObjectAclResponse result = s3Client.getObjectAcl((GetObjectAclRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetObjectAclRequest request = (GetObjectAclRequest)GetObjectAclRequest.builder().bucket(bucketName).key(keyName).build();
            GetObjectAclResponse result = s3Client.getObjectAcl(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void putObjectAcl(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutObjectAclRequest) {
                PutObjectAclResponse result = s3Client.putObjectAcl((PutObjectAclRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            String cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class);
            if (ObjectHelper.isEmpty((String)cannedAcl)) {
                throw new IllegalArgumentException("Canned ACL must be specified for putObjectAcl Operation");
            }
            ObjectCannedACL objectCannedACL = ObjectCannedACL.valueOf((String)cannedAcl);
            PutObjectAclRequest request = (PutObjectAclRequest)PutObjectAclRequest.builder().bucket(bucketName).key(keyName).acl(objectCannedACL).build();
            PutObjectAclResponse result = s3Client.putObjectAcl(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void createUploadLink(Exchange exchange) {
        S3Presigner presigner;
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        String keyName = AWS2S3Utils.determineKey(exchange, this.getConfiguration());
        long milliSeconds = 0L;
        Long expirationMillis = (Long)exchange.getIn().getHeader("CamelAwsS3UploadLinkExpirationTime", Long.class);
        milliSeconds = expirationMillis != null ? (milliSeconds += expirationMillis.longValue()) : (milliSeconds += 3600000L);
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getAmazonS3Presigner())) {
            presigner = this.getConfiguration().getAmazonS3Presigner();
        } else {
            S3Presigner.Builder builder = S3Presigner.builder();
            builder.credentialsProvider((AwsCredentialsProvider)(this.getConfiguration().isUseDefaultCredentialsProvider() != false ? DefaultCredentialsProvider.create() : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getConfiguration().getAccessKey(), (String)this.getConfiguration().getSecretKey())))).region(Region.of((String)this.getConfiguration().getRegion()));
            String uriEndpointOverride = this.getConfiguration().getUriEndpointOverride();
            if (ObjectHelper.isNotEmpty((String)uriEndpointOverride)) {
                builder.endpointOverride(URI.create(uriEndpointOverride));
            }
            presigner = builder.build();
        }
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(keyName).build();
        PutObjectPresignRequest putObjectPresignRequest = PutObjectPresignRequest.builder().signatureDuration(Duration.ofMillis(milliSeconds)).putObjectRequest(putObjectRequest).build();
        PresignedPutObjectRequest presignedPutObjectRequest = presigner.presignPutObject(putObjectPresignRequest);
        Message message = AWS2S3Producer.getMessageForResponse(exchange);
        message.setBody((Object)presignedPutObjectRequest.url().toString());
        message.setHeader("CamelAwsS3UploadLinkBrowserCompatible", (Object)presignedPutObjectRequest.isBrowserExecutable());
        message.setHeader("CamelAwsS3ProducedKey", (Object)keyName);
        message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        if (!presignedPutObjectRequest.isBrowserExecutable()) {
            LOG.debug("The upload link url is not browser compatible and please check the option of checksum validations in Amazon S3 client");
            message.setHeader("CamelAwsS3UploadLinkHttpRequestHeaders", (Object)presignedPutObjectRequest.httpRequest().headers());
            presignedPutObjectRequest.signedPayload().ifPresent(payload -> message.setHeader("CamelAwsS3UploadLinkSignedPayload", (Object)payload.asUtf8String()));
        }
        if (ObjectHelper.isEmpty((Object)this.getConfiguration().getAmazonS3Presigner())) {
            presigner.close();
        }
    }

    private void createBucket(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateBucketRequest) {
                CreateBucketResponse result = s3Client.createBucket((CreateBucketRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateBucketRequest.Builder requestBuilder = CreateBucketRequest.builder().bucket(bucketName);
            String region = this.getConfiguration().getRegion();
            if (region != null && !region.equals("us-east-1")) {
                CreateBucketConfiguration bucketConfiguration = (CreateBucketConfiguration)CreateBucketConfiguration.builder().locationConstraint(BucketLocationConstraint.fromValue((String)region)).build();
                requestBuilder.createBucketConfiguration(bucketConfiguration);
            }
            CreateBucketResponse result = s3Client.createBucket((CreateBucketRequest)requestBuilder.build());
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void getBucketTagging(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetBucketTaggingRequest) {
                GetBucketTaggingResponse result = s3Client.getBucketTagging((GetBucketTaggingRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result.tagSet());
            }
        } else {
            GetBucketTaggingRequest request = (GetBucketTaggingRequest)GetBucketTaggingRequest.builder().bucket(bucketName).build();
            GetBucketTaggingResponse result = s3Client.getBucketTagging(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result.tagSet());
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void putBucketTagging(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutBucketTaggingRequest) {
                PutBucketTaggingResponse result = s3Client.putBucketTagging((PutBucketTaggingRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            Map tags = (Map)exchange.getIn().getHeader("CamelAwsS3BucketTags", Map.class);
            if (ObjectHelper.isEmpty((Map)tags)) {
                throw new IllegalArgumentException("Bucket tags must be specified for putBucketTagging Operation");
            }
            ArrayList<Tag> tagSet = new ArrayList<Tag>();
            for (Map.Entry entry : tags.entrySet()) {
                tagSet.add((Tag)Tag.builder().key((String)entry.getKey()).value((String)entry.getValue()).build());
            }
            Tagging tagging = (Tagging)Tagging.builder().tagSet(tagSet).build();
            PutBucketTaggingRequest request = (PutBucketTaggingRequest)PutBucketTaggingRequest.builder().bucket(bucketName).tagging(tagging).build();
            PutBucketTaggingResponse result = s3Client.putBucketTagging(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void deleteBucketTagging(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteBucketTaggingRequest) {
                DeleteBucketTaggingResponse result = s3Client.deleteBucketTagging((DeleteBucketTaggingRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteBucketTaggingRequest request = (DeleteBucketTaggingRequest)DeleteBucketTaggingRequest.builder().bucket(bucketName).build();
            DeleteBucketTaggingResponse result = s3Client.deleteBucketTagging(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void getBucketVersioning(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetBucketVersioningRequest) {
                GetBucketVersioningResponse result = s3Client.getBucketVersioning((GetBucketVersioningRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetBucketVersioningRequest request = (GetBucketVersioningRequest)GetBucketVersioningRequest.builder().bucket(bucketName).build();
            GetBucketVersioningResponse result = s3Client.getBucketVersioning(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void putBucketVersioning(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutBucketVersioningRequest) {
                PutBucketVersioningResponse result = s3Client.putBucketVersioning((PutBucketVersioningRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            String versioningStatus = (String)exchange.getIn().getHeader("CamelAwsS3VersioningStatus", String.class);
            if (ObjectHelper.isEmpty((String)versioningStatus)) {
                throw new IllegalArgumentException("Versioning status must be specified for putBucketVersioning Operation");
            }
            VersioningConfiguration.Builder versioningConfigBuilder = VersioningConfiguration.builder().status(BucketVersioningStatus.fromValue((String)versioningStatus));
            String mfaDelete = (String)exchange.getIn().getHeader("CamelAwsS3MfaDelete", String.class);
            if (ObjectHelper.isNotEmpty((String)mfaDelete)) {
                versioningConfigBuilder.mfaDelete(MFADelete.fromValue((String)mfaDelete));
            }
            PutBucketVersioningRequest request = (PutBucketVersioningRequest)PutBucketVersioningRequest.builder().bucket(bucketName).versioningConfiguration((VersioningConfiguration)versioningConfigBuilder.build()).build();
            PutBucketVersioningResponse result = s3Client.putBucketVersioning(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void getBucketPolicy(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetBucketPolicyRequest) {
                GetBucketPolicyResponse result = s3Client.getBucketPolicy((GetBucketPolicyRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result.policy());
            }
        } else {
            GetBucketPolicyRequest request = (GetBucketPolicyRequest)GetBucketPolicyRequest.builder().bucket(bucketName).build();
            GetBucketPolicyResponse result = s3Client.getBucketPolicy(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result.policy());
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void putBucketPolicy(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutBucketPolicyRequest) {
                PutBucketPolicyResponse result = s3Client.putBucketPolicy((PutBucketPolicyRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            String policy = (String)exchange.getIn().getHeader("CamelAwsS3BucketPolicy", String.class);
            if (ObjectHelper.isEmpty((String)policy)) {
                throw new IllegalArgumentException("Bucket policy must be specified for putBucketPolicy Operation");
            }
            PutBucketPolicyRequest request = (PutBucketPolicyRequest)PutBucketPolicyRequest.builder().bucket(bucketName).policy(policy).build();
            PutBucketPolicyResponse result = s3Client.putBucketPolicy(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private void deleteBucketPolicy(S3Client s3Client, Exchange exchange) throws InvalidPayloadException {
        String bucketName = AWS2S3Utils.determineBucketName(exchange, this.getConfiguration());
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteBucketPolicyRequest) {
                DeleteBucketPolicyResponse result = s3Client.deleteBucketPolicy((DeleteBucketPolicyRequest)payload);
                Message message = AWS2S3Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteBucketPolicyRequest request = (DeleteBucketPolicyRequest)DeleteBucketPolicyRequest.builder().bucket(bucketName).build();
            DeleteBucketPolicyResponse result = s3Client.deleteBucketPolicy(request);
            Message message = AWS2S3Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
            message.setHeader("CamelAwsS3ProducedBucketName", (Object)bucketName);
        }
    }

    private AWS2S3Operations determineOperation(Exchange exchange) {
        AWS2S3Operations operation = (AWS2S3Operations)((Object)exchange.getIn().getHeader("CamelAwsS3Operation", AWS2S3Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    private Map<String, String> determineMetadata(Exchange exchange) {
        HashMap<String, String> objectMetadata = new HashMap<String, String>();
        Map metadata = (Map)exchange.getIn().getHeader("CamelAwsS3Metadata", Map.class);
        if (metadata != null) {
            objectMetadata.putAll(metadata);
        }
        return objectMetadata;
    }

    private static void populateMetadata(ResponseInputStream<GetObjectResponse> res, Message message) {
        message.setHeader("CamelAwsS3ETag", (Object)((GetObjectResponse)res.response()).eTag());
        message.setHeader("CamelAwsS3VersionId", (Object)((GetObjectResponse)res.response()).versionId());
        message.setHeader("CamelAwsS3ContentType", (Object)((GetObjectResponse)res.response()).contentType());
        message.setHeader("CamelAwsS3ContentLength", (Object)((GetObjectResponse)res.response()).contentLength());
        message.setHeader("CamelAwsS3ContentEncoding", (Object)((GetObjectResponse)res.response()).contentEncoding());
        message.setHeader("CamelAwsS3ContentDisposition", (Object)((GetObjectResponse)res.response()).contentDisposition());
        message.setHeader("CamelAwsS3ContentControl", (Object)((GetObjectResponse)res.response()).cacheControl());
        message.setHeader("CamelAwsS3ServerSideEncryption", (Object)((GetObjectResponse)res.response()).serverSideEncryption());
        message.setHeader("CamelAwsS3ExpirationTime", (Object)((GetObjectResponse)res.response()).expiration());
        message.setHeader("CamelAwsS3ReplicationStatus", (Object)((GetObjectResponse)res.response()).replicationStatus());
        message.setHeader("CamelAwsS3StorageClass", (Object)((GetObjectResponse)res.response()).storageClass());
        message.setHeader("CamelAwsS3Metadata", (Object)((GetObjectResponse)res.response()).metadata());
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

