/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.component.aws2.kinesis.client.KinesisClientFactory;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisConnection
implements Closeable {
    private KinesisClient kinesisClient;
    private KinesisAsyncClient kinesisAsyncClient;
    private final Lock lock = new ReentrantLock();

    public KinesisClient getClient(Kinesis2Endpoint endpoint) {
        this.lock.lock();
        try {
            if (Objects.isNull(this.kinesisClient)) {
                this.kinesisClient = endpoint.getConfiguration().getAmazonKinesisClient() != null ? endpoint.getConfiguration().getAmazonKinesisClient() : KinesisClientFactory.getKinesisClient(endpoint.getConfiguration()).getKinesisClient();
            }
            KinesisClient kinesisClient = this.kinesisClient;
            return kinesisClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public KinesisAsyncClient getAsyncClient(Kinesis2Endpoint endpoint) {
        this.lock.lock();
        try {
            if (Objects.isNull(this.kinesisAsyncClient)) {
                this.kinesisAsyncClient = endpoint.getConfiguration().getAmazonKinesisAsyncClient() != null ? endpoint.getConfiguration().getAmazonKinesisAsyncClient() : KinesisClientFactory.getKinesisAsyncClient(endpoint.getConfiguration()).getKinesisAsyncClient();
            }
            KinesisAsyncClient kinesisAsyncClient = this.kinesisAsyncClient;
            return kinesisAsyncClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setKinesisClient(KinesisClient kinesisClient) {
        this.kinesisClient = kinesisClient;
    }

    public void setKinesisAsyncClient(KinesisAsyncClient kinesisAsyncClient) {
        this.kinesisAsyncClient = kinesisAsyncClient;
    }

    @Override
    public void close() throws IOException {
        if (this.kinesisClient != null) {
            this.kinesisClient.close();
        }
        if (this.kinesisAsyncClient != null) {
            this.kinesisAsyncClient.close();
        }
    }
}

