/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import org.apache.camel.spi.Metadata;

public interface AWS2EC2Constants {
    @Metadata(description="An image ID of the AWS marketplace", javaType="String")
    public static final String IMAGE_ID = "CamelAwsEC2ImageId";
    @Metadata(description="The instance type we want to create and run", javaType="software.amazon.awssdk.services.ec2.model.InstanceType")
    public static final String INSTANCE_TYPE = "CamelAwsEC2InstanceType";
    @Metadata(description="The operation we want to perform", javaType="String")
    public static final String OPERATION = "CamelAwsEC2Operation";
    @Metadata(description="The minimum number of instances we want to run.", javaType="Integer")
    public static final String INSTANCE_MIN_COUNT = "CamelAwsEC2InstanceMinCount";
    @Metadata(description="The maximum number of instances we want to run.", javaType="Integer")
    public static final String INSTANCE_MAX_COUNT = "CamelAwsEC2InstanceMaxCount";
    @Metadata(description="Define if we want the running instances to be monitored", javaType="Boolean")
    public static final String INSTANCE_MONITORING = "CamelAwsEC2InstanceMonitoring";
    @Metadata(description="The ID of the kernel.", javaType="String")
    public static final String INSTANCE_KERNEL_ID = "CamelAwsEC2InstanceKernelId";
    @Metadata(description="Define if the creating instance is optimized for EBS I/O.", javaType="Boolean")
    public static final String INSTANCE_EBS_OPTIMIZED = "CamelAwsEC2InstanceEbsOptimized";
    @Metadata(description="The security groups to associate to the instances", javaType="Collection<String>")
    public static final String INSTANCE_SECURITY_GROUPS = "CamelAwsEC2InstanceSecurityGroups";
    @Metadata(description="A collection of instances IDS to execute start, stop, describe and\nterminate operations on.", javaType="Collection<String>")
    public static final String INSTANCES_IDS = "CamelAwsEC2InstancesIds";
    @Metadata(description="The name of the key pair.", javaType="String")
    public static final String INSTANCES_KEY_PAIR = "CamelAwsEC2InstancesKeyPair";
    @Metadata(description="Unique, case-sensitive identifier you provide to ensure the idempotency of the request.", javaType="String")
    public static final String INSTANCES_CLIENT_TOKEN = "CamelAwsEC2InstancesClientToken";
    @Metadata(description="The placement for the instance.", javaType="software.amazon.awssdk.services.ec2.model.Placement")
    public static final String INSTANCES_PLACEMENT = "CamelAwsEC2InstancesPlacement";
    @Metadata(description="A collection of tags to add or remove from EC2 resources", javaType="Collection<Tag>")
    public static final String INSTANCES_TAGS = "CamelAwsEC2InstancesTags";
    @Metadata(description="The ID of the subnet to launch the instance into.", javaType="String")
    public static final String SUBNET_ID = "CamelAwsEC2SubnetId";
}

