/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws2.ddb.BatchGetItemsCommand;
import org.apache.camel.component.aws2.ddb.Db2ProducerHealthCheck;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Endpoint;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.component.aws2.ddb.DeleteItemCommand;
import org.apache.camel.component.aws2.ddb.DeleteTableCommand;
import org.apache.camel.component.aws2.ddb.DescribeTableCommand;
import org.apache.camel.component.aws2.ddb.GetItemCommand;
import org.apache.camel.component.aws2.ddb.PutItemCommand;
import org.apache.camel.component.aws2.ddb.QueryCommand;
import org.apache.camel.component.aws2.ddb.ScanCommand;
import org.apache.camel.component.aws2.ddb.UpdateItemCommand;
import org.apache.camel.component.aws2.ddb.UpdateTableCommand;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.URISupport;

public class Ddb2Producer
extends DefaultProducer {
    private transient String ddbProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public Ddb2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case BatchGetItems: {
                new BatchGetItemsCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DeleteItem: {
                new DeleteItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DeleteTable: {
                new DeleteTableCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DescribeTable: {
                new DescribeTableCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case GetItem: {
                new GetItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case PutItem: {
                new PutItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case Query: {
                new QueryCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case Scan: {
                new ScanCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case UpdateItem: {
                new UpdateItemCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case UpdateTable: {
                new UpdateTableCommand(this.getEndpoint().getDdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private Ddb2Operations determineOperation(Exchange exchange) {
        Ddb2Operations operation = (Ddb2Operations)((Object)exchange.getIn().getHeader("CamelAwsDdbOperation", Ddb2Operations.class));
        return operation != null ? operation : this.getConfiguration().getOperation();
    }

    protected Ddb2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.ddbProducerToString == null) {
            this.ddbProducerToString = "DdbProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.ddbProducerToString;
    }

    public Ddb2Endpoint getEndpoint() {
        return (Ddb2Endpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new Db2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

