/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SqsProducer.class);

    public SqsProducer(SqsEndpoint endpoint) throws NoFactoryAvailableException {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getIn().getBody(String.class);
        SendMessageRequest request = new SendMessageRequest(this.getQueueUrl(), body);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        SendMessageResult result = this.getClient().sendMessage(request);
        LOG.trace("Received result [{}]", (Object)result);
        Message message = this.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSqsMessageId", (Object)result.getMessageId());
        message.setHeader("CamelAwsSqsMD5OfBody", (Object)result.getMD5OfMessageBody());
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    protected AmazonSQSClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    public SqsEndpoint getEndpoint() {
        return (SqsEndpoint)super.getEndpoint();
    }

    public String toString() {
        return "SqsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }
}

