/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.kinesis.KinesisComponentVerifierExtension;
import org.apache.camel.component.aws.kinesis.KinesisConfiguration;
import org.apache.camel.component.aws.kinesis.KinesisEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

public class KinesisComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private KinesisConfiguration configuration = new KinesisConfiguration();

    public KinesisComponent() {
        this(null);
    }

    public KinesisComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KinesisComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KinesisConfiguration configuration = this.configuration.copy();
        configuration.setStreamName(remaining);
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        if (configuration.getAmazonKinesisClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonKinesisClient or accessKey and secretKey must be specified");
        }
        KinesisEndpoint endpoint = new KinesisEndpoint(uri, configuration, this);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public KinesisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KinesisConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }
}

