/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws.mq;

/**
 * Constants used in Camel AWS MQ module
 * 
 */
public interface MQConstants {
    String OPERATION                  = "CamelAwsMQOperation";
    String MAX_RESULTS                = "CamelAwsMQMaxResults";
    String BROKER_NAME                = "CamelAwsMQBrokerName";
    String BROKER_ENGINE              = "CamelAwsMQBrokerEngine";
    String BROKER_ENGINE_VERSION      = "CamelAwsMQBrokerEngineVersion";
    String BROKER_ID                  = "CamelAwsMQBrokerID";
    String CONFIGURATION_ID           = "CamelAwsMQConfigurationID";
    String BROKER_DEPLOYMENT_MODE     = "CamelAwsMQBrokerDeploymentMode";
    String BROKER_INSTANCE_TYPE       = "CamelAwsMQBrokerInstanceType";
    String BROKER_USERS               = "CamelAwsMQBrokerUsers";
    String BROKER_PUBLICLY_ACCESSIBLE = "CamelAwsMQBrokerPubliclyAccessible";
}
