/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.amazonaws.services.dynamodb.model.UpdateItemResult;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class UpdateItemCommand
extends AbstractDdbCommand {
    public UpdateItemCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        UpdateItemResult result = this.ddbClient.updateItem(new UpdateItemRequest().withTableName(this.determineTableName()).withKey(this.determineKey()).withAttributeUpdates(this.determineUpdateValues()).withExpected(this.determineUpdateCondition()).withReturnValues(this.determineReturnValues()));
        this.addAttributesToResult(result.getAttributes());
    }

    private Map<String, AttributeValueUpdate> determineUpdateValues() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbUpdateValues", Map.class);
    }
}

