/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;

public class TitanStreamParser
implements StreamResponseParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String extractText(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return "";
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode outputText = node.get("outputText");
        return outputText != null && !outputText.isNull() ? outputText.asText() : "";
    }

    @Override
    public String extractCompletionReason(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode completionReason = node.get("completionReason");
        return completionReason != null && !completionReason.isNull() ? completionReason.asText() : null;
    }

    @Override
    public Integer extractTokenCount(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode tokenCount = node.get("totalOutputTextTokenCount");
        return tokenCount != null && !tokenCount.isNull() ? Integer.valueOf(tokenCount.asInt()) : null;
    }

    @Override
    public boolean isFinalChunk(String chunk) throws JsonProcessingException {
        String completionReason = this.extractCompletionReason(chunk);
        return completionReason != null && !completionReason.isEmpty();
    }
}

