/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import org.apache.camel.component.aws2.bedrock.runtime.stream.ClaudeStreamParser;
import org.apache.camel.component.aws2.bedrock.runtime.stream.CohereStreamParser;
import org.apache.camel.component.aws2.bedrock.runtime.stream.LlamaStreamParser;
import org.apache.camel.component.aws2.bedrock.runtime.stream.MistralStreamParser;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;
import org.apache.camel.component.aws2.bedrock.runtime.stream.TitanStreamParser;

public final class StreamParserFactory {
    private StreamParserFactory() {
    }

    public static StreamResponseParser getParser(String modelId) {
        if (modelId == null) {
            throw new IllegalArgumentException("Model ID cannot be null");
        }
        if (modelId.startsWith("amazon.titan")) {
            return new TitanStreamParser();
        }
        if (modelId.startsWith("anthropic.claude")) {
            return new ClaudeStreamParser();
        }
        if (modelId.startsWith("meta.llama")) {
            return new LlamaStreamParser();
        }
        if (modelId.startsWith("mistral.")) {
            return new MistralStreamParser();
        }
        if (modelId.startsWith("cohere.")) {
            return new CohereStreamParser();
        }
        if (modelId.startsWith("amazon.nova")) {
            return new ClaudeStreamParser();
        }
        if (modelId.startsWith("ai21.")) {
            return new TitanStreamParser();
        }
        throw new IllegalArgumentException("Unsupported model for streaming: " + modelId);
    }
}

