/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockComponent;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockConfiguration;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockConstants;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockProducer;
import org.apache.camel.component.aws2.bedrock.runtime.client.BedrockClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;

@UriEndpoint(firstVersion="4.5.0", scheme="aws-bedrock", title="AWS Bedrock", syntax="aws-bedrock:label", producerOnly=true, category={Category.AI, Category.CLOUD}, headersClass=BedrockConstants.class)
public class BedrockEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private BedrockRuntimeClient bedrockRuntimeClient;
    private BedrockRuntimeAsyncClient bedrockRuntimeAsyncClient;
    @UriParam
    private BedrockConfiguration configuration;

    public BedrockEndpoint(String uri, Component component, BedrockConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new BedrockProducer((Endpoint)this);
    }

    public BedrockComponent getComponent() {
        return (BedrockComponent)super.getComponent();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.bedrockRuntimeClient = this.configuration.getBedrockRuntimeClient() != null ? this.configuration.getBedrockRuntimeClient() : BedrockClientFactory.getBedrockRuntimeClient(this.configuration).getBedrockRuntimeClient();
        this.bedrockRuntimeAsyncClient = this.configuration.getBedrockRuntimeAsyncClient() != null ? this.configuration.getBedrockRuntimeAsyncClient() : BedrockClientFactory.getBedrockRuntimeClient(this.configuration).getBedrockRuntimeAsyncClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getBedrockRuntimeClient()) && this.bedrockRuntimeClient != null) {
            this.bedrockRuntimeClient.close();
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getBedrockRuntimeAsyncClient()) && this.bedrockRuntimeAsyncClient != null) {
            this.bedrockRuntimeAsyncClient.close();
        }
        super.doStop();
    }

    public BedrockConfiguration getConfiguration() {
        return this.configuration;
    }

    public BedrockRuntimeClient getBedrockRuntimeClient() {
        return this.bedrockRuntimeClient;
    }

    public BedrockRuntimeAsyncClient getBedrockRuntimeAsyncClient() {
        return this.bedrockRuntimeAsyncClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "bedrock-runtime";
    }

    public Map<String, String> getServiceMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.configuration.getModelId() != null) {
            metadata.put("modelId", this.configuration.getModelId());
        }
        return metadata;
    }
}

