/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.URISupport;

@Component(value="atom")
public class AtomComponent
extends FeedComponent {
    @Override
    protected FeedEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return new AtomEndpoint(uri, this, null);
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        String feedUri;
        AtomEndpoint atom = (AtomEndpoint)endpoint;
        if (atom.getFeedUri() != null) {
            return;
        }
        if (!parameters.isEmpty()) {
            URI remainingUri = URISupport.createRemainingURI((URI)new URI(remaining), parameters);
            feedUri = remainingUri.toString();
        } else {
            feedUri = remaining;
        }
        atom.setFeedUri(feedUri);
    }
}

