/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.util.iri.IRISyntaxException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(AtomProducer.class);
    private final AtomEndpoint endpoint;

    public AtomProducer(AtomEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Document<Feed> document = this.getDocument(exchange);
        OutputStream out = this.endpoint.createProducerOutputStream();
        try {
            document.writeTo(out);
        }
        finally {
            ObjectHelper.close((Closeable)out, (String)"Atom document output stream", (Log)LOG);
        }
    }

    protected Document<Feed> getDocument(Exchange exchange) throws IRISyntaxException, IOException {
        String title;
        String summary;
        String content;
        Document<Feed> document = this.endpoint.parseDocument();
        Feed root = (Feed)document.getRoot();
        Entry entry = root.addEntry();
        entry.setPublished((Date)ExchangeHelper.getExchangeProperty((Exchange)exchange, (String)"org.apache.camel.atom.published", Date.class, (Object)new Date()));
        String id = (String)exchange.getProperty("org.apache.camel.atom.id", String.class);
        if (id != null) {
            entry.setId(id);
        }
        if ((content = (String)exchange.getProperty("org.apache.camel.atom.content", String.class)) != null) {
            entry.setContent(content);
        }
        if ((summary = (String)exchange.getProperty("org.apache.camel.atom.summary", String.class)) != null) {
            entry.setSummary(summary);
        }
        if ((title = (String)exchange.getProperty("org.apache.camel.atom.title", String.class)) != null) {
            entry.setTitle(title);
        }
        return document;
    }
}

