/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.api.AS2AsyncMDNServerConnection;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS2ConnectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AS2ConnectionHelper.class);
    private static final Map<Integer, AS2ServerConnection> serverConnections = new ConcurrentHashMap<Integer, AS2ServerConnection>();
    private static final Map<Integer, AS2AsyncMDNServerConnection> asyncMdnServerConnections = new ConcurrentHashMap<Integer, AS2AsyncMDNServerConnection>();

    private AS2ConnectionHelper() {
    }

    public static AS2ClientConnection createAS2ClientConnection(AS2Configuration configuration) throws IOException {
        return new AS2ClientConnection(configuration.getAs2Version(), configuration.getUserAgent(), configuration.getClientFqdn(), configuration.getTargetHostname(), Integer.valueOf(configuration.getTargetPortNumber()), configuration.getHttpSocketTimeout(), configuration.getHttpConnectionTimeout(), configuration.getHttpConnectionPoolSize(), configuration.getHttpConnectionPoolTtl(), configuration.getSslContext(), configuration.getHostnameVerifier());
    }

    public static AS2AsyncMDNServerConnection createAS2AsyncMDNServerConnection(AS2Configuration configuration) throws IOException {
        try {
            return asyncMdnServerConnections.computeIfAbsent(configuration.getAsyncMdnPortNumber(), key -> {
                try {
                    return new AS2AsyncMDNServerConnection(configuration.getAsyncMdnPortNumber(), configuration.getSslContext());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static AS2ServerConnection createAS2ServerConnection(AS2Configuration configuration) throws IOException {
        try {
            return serverConnections.computeIfAbsent(configuration.getServerPortNumber(), key -> {
                try {
                    return new AS2ServerConnection(configuration.getAs2Version(), configuration.getServer(), configuration.getServerFqdn(), configuration.getServerPortNumber(), configuration.getSigningAlgorithm(), configuration.getSigningCertificateChain(), configuration.getSigningPrivateKey(), configuration.getDecryptingPrivateKey(), configuration.getMdnMessageTemplate(), configuration.getValidateSigningCertificateChain(), configuration.getSslContext());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static void closeAllConnections() {
        AS2ConnectionHelper.closeAllServerConnections();
        AS2ConnectionHelper.closeAllAsyncMdnServerConnections();
    }

    public static void closeAllServerConnections() {
        for (Map.Entry<Integer, AS2ServerConnection> entry : serverConnections.entrySet()) {
            try {
                int port = entry.getKey();
                LOG.debug("Stopping and closing AS2ServerConnection on port: {}", (Object)port);
                AS2ServerConnection conn = entry.getValue();
                conn.close();
            }
            catch (Exception e) {
                LOG.debug("Error stopping and closing AS2ServerConnection due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
            }
        }
        serverConnections.clear();
    }

    public static void closeAllAsyncMdnServerConnections() {
        for (Map.Entry<Integer, AS2AsyncMDNServerConnection> entry : asyncMdnServerConnections.entrySet()) {
            try {
                int port = entry.getKey();
                LOG.debug("Stopping and closing AsyncMdnServerConnection on port: {}", (Object)port);
                entry.getValue().close();
            }
            catch (Exception e) {
                LOG.debug("Error stopping and closing AsyncMdnServerConnection due to {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
            }
        }
        asyncMdnServerConnections.clear();
    }
}

