/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="client", producerOnly=true, description="Sends EDI Messages over HTTP", apiMethods={@ApiMethod(methodName="send", description="Send ediMessage to trading partner", signatures={"org.apache.hc.core5.http.protocol.HttpCoreContext send(Object ediMessage, String requestUri, String subject, String from, String as2From, String as2To, org.apache.camel.component.as2.api.AS2MessageStructure as2MessageStructure, String ediMessageContentType, String ediMessageCharset, String ediMessageTransferEncoding, org.apache.camel.component.as2.api.AS2SignatureAlgorithm signingAlgorithm, java.security.cert.Certificate[] signingCertificateChain, java.security.PrivateKey signingPrivateKey, org.apache.camel.component.as2.api.AS2CompressionAlgorithm compressionAlgorithm, String dispositionNotificationTo, String signedReceiptMicAlgorithms, org.apache.camel.component.as2.api.AS2EncryptionAlgorithm encryptingAlgorithm, java.security.cert.Certificate[] encryptingCertificateChain, String attachedFileName, String receiptDeliveryOption, String userName, String password, String accessToken)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class AS2ClientManagerEndpointConfiguration
extends AS2Configuration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The access token that is used by the client for bearer authentication")})
    private String accessToken;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="AS2 name of sender")})
    private String as2From;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="The structure of AS2 to send; see AS2MessageStructure")})
    private AS2MessageStructure as2MessageStructure;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="AS2 name of recipient")})
    private String as2To;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The name of the attached file or null if user doesn't want to specify it")})
    private String attachedFileName;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The algorithm used to compress the message or null if sending EDI message uncompressed")})
    private AS2CompressionAlgorithm compressionAlgorithm;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="An RFC2822 address to request a receipt or null if no receipt requested")})
    private String dispositionNotificationTo;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="EDI message to transport")})
    private Object ediMessage;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The charset of the EDI message")})
    private String ediMessageCharset;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="The content type of EDI message")})
    private String ediMessageContentType;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The transfer encoding used to transport EDI message")})
    private String ediMessageTransferEncoding;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The algorithm used to encrypt the message or null if sending EDI message unencrypted")})
    private AS2EncryptionAlgorithm encryptingAlgorithm;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The chain of certificates used to encrypt the message or null if sending EDI message unencrypted")})
    private Certificate[] encryptingCertificateChain;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="RFC2822 address of sender")})
    private String from;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The password that is used by the client for basic authentication")})
    private String password;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The return URL that the message receiver should send an asynchronous MDN to")})
    private String receiptDeliveryOption;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="Resource location to deliver message")})
    private String requestUri;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The senders list of signing algorithms for signing receipt, in preferred order, or null if requesting an unsigned receipt.")})
    private String signedReceiptMicAlgorithms;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The algorithm used to sign the message or null if sending EDI message unsigned")})
    private AS2SignatureAlgorithm signingAlgorithm;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The chain of certificates used to sign the message or null if sending EDI message unsigned")})
    private Certificate[] signingCertificateChain;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The private key used to sign EDI message")})
    private PrivateKey signingPrivateKey;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="send", description="Message subject")})
    private String subject;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="send", description="The user-name that is used for basic authentication")})
    private String userName;

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public String getAs2From() {
        return this.as2From;
    }

    @Override
    public void setAs2From(String as2From) {
        this.as2From = as2From;
    }

    @Override
    public AS2MessageStructure getAs2MessageStructure() {
        return this.as2MessageStructure;
    }

    @Override
    public void setAs2MessageStructure(AS2MessageStructure as2MessageStructure) {
        this.as2MessageStructure = as2MessageStructure;
    }

    @Override
    public String getAs2To() {
        return this.as2To;
    }

    @Override
    public void setAs2To(String as2To) {
        this.as2To = as2To;
    }

    @Override
    public String getAttachedFileName() {
        return this.attachedFileName;
    }

    @Override
    public void setAttachedFileName(String attachedFileName) {
        this.attachedFileName = attachedFileName;
    }

    @Override
    public AS2CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void setCompressionAlgorithm(AS2CompressionAlgorithm compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    @Override
    public String getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    @Override
    public void setDispositionNotificationTo(String dispositionNotificationTo) {
        this.dispositionNotificationTo = dispositionNotificationTo;
    }

    public Object getEdiMessage() {
        return this.ediMessage;
    }

    public void setEdiMessage(Object ediMessage) {
        this.ediMessage = ediMessage;
    }

    @Override
    public String getEdiMessageCharset() {
        return this.ediMessageCharset;
    }

    @Override
    public void setEdiMessageCharset(String ediMessageCharset) {
        this.ediMessageCharset = ediMessageCharset;
    }

    public String getEdiMessageContentType() {
        return this.ediMessageContentType;
    }

    public void setEdiMessageContentType(String ediMessageContentType) {
        this.ediMessageContentType = ediMessageContentType;
    }

    @Override
    public String getEdiMessageTransferEncoding() {
        return this.ediMessageTransferEncoding;
    }

    @Override
    public void setEdiMessageTransferEncoding(String ediMessageTransferEncoding) {
        this.ediMessageTransferEncoding = ediMessageTransferEncoding;
    }

    @Override
    public AS2EncryptionAlgorithm getEncryptingAlgorithm() {
        return this.encryptingAlgorithm;
    }

    @Override
    public void setEncryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
        this.encryptingAlgorithm = encryptingAlgorithm;
    }

    @Override
    public Certificate[] getEncryptingCertificateChain() {
        return this.encryptingCertificateChain;
    }

    @Override
    public void setEncryptingCertificateChain(Certificate[] encryptingCertificateChain) {
        this.encryptingCertificateChain = encryptingCertificateChain;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getReceiptDeliveryOption() {
        return this.receiptDeliveryOption;
    }

    @Override
    public void setReceiptDeliveryOption(String receiptDeliveryOption) {
        this.receiptDeliveryOption = receiptDeliveryOption;
    }

    @Override
    public String getRequestUri() {
        return this.requestUri;
    }

    @Override
    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    @Override
    public String getSignedReceiptMicAlgorithms() {
        return this.signedReceiptMicAlgorithms;
    }

    @Override
    public void setSignedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
        this.signedReceiptMicAlgorithms = signedReceiptMicAlgorithms;
    }

    @Override
    public AS2SignatureAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    @Override
    public void setSigningAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    @Override
    public Certificate[] getSigningCertificateChain() {
        return this.signingCertificateChain;
    }

    @Override
    public void setSigningCertificateChain(Certificate[] signingCertificateChain) {
        this.signingCertificateChain = signingCertificateChain;
    }

    @Override
    public PrivateKey getSigningPrivateKey() {
        return this.signingPrivateKey;
    }

    @Override
    public void setSigningPrivateKey(PrivateKey signingPrivateKey) {
        this.signingPrivateKey = signingPrivateKey;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }
}

