/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;

public class TextPlainEntity
extends MimeEntity {
    private String content;

    public TextPlainEntity(String content, String charset, String contentTransferEncoding, boolean isMainBody) {
        super(ContentType.create((String)"text/plain", (String)charset), contentTransferEncoding);
        this.content = (String)ObjectHelper.notNull((Object)content, (String)"Content");
        this.setMainBody(isMainBody);
    }

    public String getText() {
        return this.content;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
            if (!this.isMainBody()) {
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            outstream.write(this.content.getBytes(StandardCharsets.US_ASCII), 0, this.content.length());
        }
    }

    public void close() throws IOException {
    }
}

