/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.operator.OutputEncryptor;

public class ApplicationPkcs7MimeEnvelopedDataEntity
extends MimeEntity {
    private static final String CONTENT_DISPOSITION = "attachment; filename=\"smime.p7m\"";
    private byte[] encryptedData;

    public ApplicationPkcs7MimeEnvelopedDataEntity(MimeEntity entity2Encrypt, CMSEnvelopedDataGenerator dataGenerator, OutputEncryptor encryptor, String encryptedContentTransferEncoding, boolean isMainBody) throws HttpException {
        super(ContentType.create((String)"application/pkcs7-mime", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("smime-type", "enveloped-data"), new BasicNameValuePair("name", "smime.p7m")}), encryptedContentTransferEncoding);
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.setMainBody(isMainBody);
        try {
            this.encryptedData = this.createEncryptedData(entity2Encrypt, dataGenerator, encryptor);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create encrypted data");
        }
    }

    public ApplicationPkcs7MimeEnvelopedDataEntity(byte[] encryptedData, String encryptedContentTransferEncoding, boolean isMainBody) {
        super(ContentType.create((String)"application/pkcs7-mime", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("smime-type", "enveloped-data"), new BasicNameValuePair("name", "smime.p7m")}), encryptedContentTransferEncoding);
        this.encryptedData = (byte[])ObjectHelper.notNull((Object)encryptedData, (String)"encryptedData");
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.setMainBody(isMainBody);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        if (!this.isMainBody()) {
            try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
        }
        String transferEncoding = this.getContentTransferEncoding() == null ? null : this.getContentTransferEncoding().getValue();
        try (OutputStream transferEncodedStream = EntityUtils.encode(ncos, transferEncoding);){
            transferEncodedStream.write(this.encryptedData);
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }

    public MimeEntity getEncryptedEntity(PrivateKey privateKey) throws HttpException {
        return EntityParser.parseEnvelopedEntity(this.encryptedData, privateKey);
    }

    private byte[] createEncryptedData(MimeEntity entity2Encrypt, CMSEnvelopedDataGenerator envelopedDataGenerator, OutputEncryptor encryptor) throws IOException, CMSException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            entity2Encrypt.writeTo(bos);
            bos.flush();
            CMSProcessableByteArray contentData = new CMSProcessableByteArray(bos.toByteArray());
            CMSEnvelopedData envelopedData = envelopedDataGenerator.generate((CMSTypedData)contentData, encryptor);
            byte[] byArray = envelopedData.getEncoded();
            return byArray;
        }
    }

    public void close() throws IOException {
    }
}

