/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.camel.util.BufferCaster;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.io.HttpTransportMetrics;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public class AS2SessionInputBuffer
implements SessionInputBuffer {
    private static final int CR = 13;
    private static final int LF = 10;
    private final BasicHttpTransportMetrics metrics;
    private final byte[] buffer;
    private final ByteArrayBuffer linebuffer;
    private final int minChunkLimit;
    private CharsetDecoder decoder;
    private int bufferpos;
    private int bufferlen;
    private CharBuffer cbuf;
    private boolean lastLineReadEnrichedByCarriageReturn;
    private boolean lastLineReadTerminatedByLineFeed;

    public AS2SessionInputBuffer(BasicHttpTransportMetrics metrics, int buffersize, int minChunkLimit) {
        this.metrics = (BasicHttpTransportMetrics)ObjectHelper.notNull((Object)metrics, (String)"metrics");
        Args.positive((int)buffersize, (String)"buffersize");
        this.buffer = new byte[buffersize];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.minChunkLimit = minChunkLimit >= 0 ? minChunkLimit : 512;
        this.linebuffer = new ByteArrayBuffer(buffersize);
    }

    public AS2SessionInputBuffer(BasicHttpTransportMetrics metrics, int buffersize) {
        this(metrics, buffersize, buffersize);
    }

    public CharsetDecoder getCharsetDecoder() {
        return this.decoder;
    }

    public void setCharsetDecoder(CharsetDecoder chardecoder) {
        this.decoder = chardecoder;
    }

    public int length() {
        return this.bufferlen - this.bufferpos;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int available() {
        return this.capacity() - this.length();
    }

    public int fillBuffer(InputStream inputStream) throws IOException {
        int len;
        int off;
        int l;
        if (this.bufferpos > 0) {
            int len2 = this.bufferlen - this.bufferpos;
            if (len2 > 0) {
                System.arraycopy(this.buffer, this.bufferpos, this.buffer, 0, len2);
            }
            this.bufferpos = 0;
            this.bufferlen = len2;
        }
        if ((l = inputStream.read(this.buffer, off = this.bufferlen, len = this.buffer.length - off)) == -1) {
            return -1;
        }
        this.bufferlen = off + l;
        this.metrics.incrementBytesTransferred((long)l);
        return l;
    }

    public boolean hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    public int read(byte[] b, int off, int len, InputStream inputStream) throws IOException {
        if (b == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int chunk = Math.min(len, this.bufferlen - this.bufferpos);
            System.arraycopy(this.buffer, this.bufferpos, b, off, chunk);
            this.bufferpos += chunk;
            return chunk;
        }
        if (len > this.minChunkLimit) {
            int read = inputStream.read(b, off, len);
            if (read > 0) {
                this.metrics.incrementBytesTransferred((long)read);
            }
            return read;
        }
        while (!this.hasBufferedData()) {
            int noRead = this.fillBuffer(inputStream);
            if (noRead != -1) continue;
            return -1;
        }
        int chunk = Math.min(len, this.bufferlen - this.bufferpos);
        System.arraycopy(this.buffer, this.bufferpos, b, off, chunk);
        this.bufferpos += chunk;
        return chunk;
    }

    public int read(byte[] b, InputStream inputStream) throws IOException {
        if (b == null) {
            return 0;
        }
        return inputStream.read(b, 0, b.length);
    }

    public int read(InputStream inputStream) throws IOException {
        while (!this.hasBufferedData()) {
            int noRead = this.fillBuffer(inputStream);
            if (noRead != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    public int readLine(CharArrayBuffer charbuffer, InputStream inputStream) throws IOException {
        ObjectHelper.notNull((Object)charbuffer, (String)"Char array buffer");
        int noRead = 0;
        boolean retry = true;
        this.lastLineReadEnrichedByCarriageReturn = false;
        this.lastLineReadTerminatedByLineFeed = false;
        while (retry) {
            int pos = -1;
            for (int i = this.bufferpos; i < this.bufferlen; ++i) {
                if (this.buffer[i] != 10) continue;
                pos = i;
                this.lastLineReadTerminatedByLineFeed = true;
                if (i <= 0 || this.buffer[i - 1] != 13) break;
                this.lastLineReadEnrichedByCarriageReturn = true;
                break;
            }
            if (pos != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charbuffer, pos);
                }
                retry = false;
                this.addBytesToLinebuffer(pos);
                continue;
            }
            if (this.hasBufferedData()) {
                this.addBytesToLinebuffer(pos);
            }
            if ((noRead = this.fillBuffer(inputStream)) != -1) continue;
            retry = false;
        }
        if (noRead == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charbuffer);
    }

    public boolean isLastLineReadTerminatedByLineFeed() {
        return this.lastLineReadTerminatedByLineFeed;
    }

    public boolean isLastLineReadEnrichedByCarriageReturn() {
        return this.lastLineReadEnrichedByCarriageReturn;
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }

    private int lineFromLineBuffer(CharArrayBuffer charbuffer) throws IOException {
        int len = this.linebuffer.length();
        if (len > 0) {
            if (this.linebuffer.byteAt(len - 1) == 10) {
                --len;
            }
            if (len > 0 && this.linebuffer.byteAt(len - 1) == 13) {
                --len;
            }
        }
        if (this.decoder == null) {
            charbuffer.append(this.linebuffer, 0, len);
        } else {
            ByteBuffer bbuf = ByteBuffer.wrap(this.linebuffer.toByteArray(), 0, len);
            len = this.appendDecoded(charbuffer, bbuf);
        }
        this.linebuffer.clear();
        return len;
    }

    private int lineFromReadBuffer(CharArrayBuffer charbuffer, int position) throws IOException {
        int pos = position;
        int off = this.bufferpos;
        this.bufferpos = pos + 1;
        if (pos > off && this.buffer[pos - 1] == 13) {
            --pos;
        }
        int len = pos - off;
        if (this.decoder == null) {
            charbuffer.append(this.buffer, off, len);
        } else {
            ByteBuffer bbuf = ByteBuffer.wrap(this.buffer, off, len);
            len = this.appendDecoded(charbuffer, bbuf);
        }
        return len;
    }

    private int appendDecoded(CharArrayBuffer charbuffer, ByteBuffer bbuf) throws IOException {
        CoderResult result;
        if (!bbuf.hasRemaining()) {
            return 0;
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int len = 0;
        while (bbuf.hasRemaining()) {
            result = this.decoder.decode(bbuf, this.cbuf, true);
            len += this.handleDecodingResult(result, charbuffer);
        }
        result = this.decoder.flush(this.cbuf);
        BufferCaster.cast((Buffer)this.cbuf).clear();
        return len += this.handleDecodingResult(result, charbuffer);
    }

    private int handleDecodingResult(CoderResult result, CharArrayBuffer charbuffer) throws IOException {
        if (result.isError()) {
            result.throwException();
        }
        BufferCaster.cast((Buffer)this.cbuf).flip();
        int len = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charbuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return len;
    }

    private void addBytesToLinebuffer(int pos) throws IOException {
        try {
            int len = pos != -1 ? pos + 1 - this.bufferpos : this.bufferlen - this.bufferpos;
            this.linebuffer.append(this.buffer, this.bufferpos, len);
            this.bufferpos = pos != -1 ? pos + 1 : this.bufferlen;
        }
        catch (Exception e) {
            throw new IOException("failed to decode transfer encoding", e);
        }
    }
}

