/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

public enum DispositionMode {
    MANUAL_ACTION_MDN_SENT_MANUALLY("manual-action", "MDN-sent-manually"),
    MANUAL_ACTION_MDN_SENT_AUTOMATICALLY("manual-action", "MDN-sent-automatically"),
    AUTOMATIC_ACTION_MDN_SENT_MANUALLY("automatic-action", "MDN-sent-manually"),
    AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY("automatic-action", "MDN-sent-automatically");

    private final String actionMode;
    private final String sendingMode;

    private DispositionMode(String actionMode, String sendingMode) {
        this.actionMode = actionMode;
        this.sendingMode = sendingMode;
    }

    public String getActionMode() {
        return this.actionMode;
    }

    public String getSendingMode() {
        return this.sendingMode;
    }

    public String toString() {
        return this.actionMode + "/" + this.sendingMode;
    }

    public static DispositionMode parseDispositionMode(String dispositionModeString) {
        switch (dispositionModeString) {
            case "manual-action/MDN-sent-manually": {
                return MANUAL_ACTION_MDN_SENT_MANUALLY;
            }
            case "manual-actionMDN-sent-automatically": {
                return MANUAL_ACTION_MDN_SENT_AUTOMATICALLY;
            }
            case "automatic-action/MDN-sent-manually": {
                return AUTOMATIC_ACTION_MDN_SENT_MANUALLY;
            }
            case "automatic-action/MDN-sent-automatically": {
                return AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY;
            }
        }
        return null;
    }
}

