/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeCompressedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeEnvelopedDataEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.operator.InputExpanderProvider;

public final class HttpMessageUtils {
    private HttpMessageUtils() {
    }

    public static String getHeaderValue(HttpMessage message, String headerName) {
        Header header = message.getFirstHeader(headerName);
        return header == null ? null : header.getValue();
    }

    public static void setHeaderValue(HttpMessage message, String headerName, String headerValue) {
        ObjectHelper.notNull((Object)message, (String)"message");
        ObjectHelper.notNull((Object)headerName, (String)"headerName");
        if (headerValue == null) {
            message.removeHeaders(headerName);
        } else {
            message.setHeader(headerName, headerValue);
        }
    }

    public static <T> T getEntity(HttpMessage message, Class<T> type) {
        HttpEntity entity;
        ObjectHelper.notNull((Object)message, (String)"message");
        ObjectHelper.notNull(type, (String)"type");
        if (message instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity2 = ((HttpEntityEnclosingRequest)message).getEntity();
            if (entity2 != null && type.isInstance(entity2)) {
                return type.cast(entity2);
            }
        } else if (message instanceof HttpResponse && (entity = ((HttpResponse)message).getEntity()) != null && type.isInstance(entity)) {
            type.cast(entity);
        }
        return null;
    }

    public static String parseBodyPartContent(SessionInputBuffer inBuffer, String boundary) throws HttpException {
        try {
            CharArrayBuffer bodyPartContentBuffer = new CharArrayBuffer(1024);
            CharArrayBuffer lineBuffer = new CharArrayBuffer(1024);
            boolean foundMultipartEndBoundary = false;
            while (inBuffer.readLine(lineBuffer) != -1) {
                if (EntityParser.isBoundaryDelimiter(lineBuffer, null, boundary)) {
                    foundMultipartEndBoundary = true;
                    bodyPartContentBuffer.setLength(bodyPartContentBuffer.length() - 2);
                    lineBuffer.clear();
                    break;
                }
                lineBuffer.append("\r\n");
                bodyPartContentBuffer.append(lineBuffer);
                lineBuffer.clear();
            }
            if (!foundMultipartEndBoundary) {
                throw new HttpException("Failed to find end boundary delimiter for body part");
            }
            return bodyPartContentBuffer.toString();
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse body part content", (Throwable)e);
        }
    }

    public static String getParameterValue(HttpMessage message, String headerName, String parameterName) {
        ObjectHelper.notNull((Object)message, (String)"message");
        ObjectHelper.notNull((Object)headerName, (String)"headerName");
        ObjectHelper.notNull((Object)parameterName, (String)"parameterName");
        Header header = message.getFirstHeader(headerName);
        if (header == null) {
            return null;
        }
        for (HeaderElement headerElement : header.getElements()) {
            for (NameValuePair nameValuePair : headerElement.getParameters()) {
                if (!nameValuePair.getName().equalsIgnoreCase(parameterName)) continue;
                return nameValuePair.getValue();
            }
        }
        return null;
    }

    public static ApplicationEntity extractEdiPayload(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        String contentTypeString = HttpMessageUtils.getHeaderValue(message, "Content-Type");
        if (contentTypeString == null) {
            throw new HttpException("Failed to create MIC: content type missing from request");
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        EntityParser.parseAS2MessageEntity(message);
        ApplicationEntity ediEntity = null;
        block7 : switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                ediEntity = HttpMessageUtils.getEntity(message, ApplicationEntity.class);
                break;
            }
            case "multipart/signed": {
                ediEntity = HttpMessageUtils.extractMultipartSigned(message, decrpytingAndSigningInfo);
                break;
            }
            case "application/pkcs7-mime": {
                switch (contentType.getParameter("smime-type")) {
                    case "compressed-data": {
                        ediEntity = HttpMessageUtils.extractCompressedData(message, decrpytingAndSigningInfo);
                        break block7;
                    }
                    case "enveloped-data": {
                        ediEntity = HttpMessageUtils.extractEnvelopedData(message, decrpytingAndSigningInfo);
                        break block7;
                    }
                }
                throw new HttpException("Failed to extract EDI message: unknown application/pkcs7-mime smime-type: " + contentType.getParameter("smime-type"));
            }
            default: {
                throw new HttpException("Failed to extract EDI message: invalid content type '" + contentType.getMimeType() + "' for AS2 request message");
            }
        }
        return ediEntity;
    }

    private static ApplicationEntity extractEnvelopedData(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        if (decrpytingAndSigningInfo.getDecryptingPrivateKey() == null) {
            throw new HttpException("Failed to extract EDI payload: private key can not be null for AS2 enveloped message");
        }
        ApplicationPkcs7MimeEnvelopedDataEntity envelopedDataEntity = HttpMessageUtils.getEntity(message, ApplicationPkcs7MimeEnvelopedDataEntity.class);
        Objects.requireNonNull(envelopedDataEntity, "Failed to extract EDI payload: the enveloped data entity is null");
        ApplicationEntity ediEntity = HttpMessageUtils.extractEdiPayloadFromEnvelopedEntity(envelopedDataEntity, decrpytingAndSigningInfo);
        return ediEntity;
    }

    private static ApplicationEntity extractCompressedData(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = HttpMessageUtils.getEntity(message, ApplicationPkcs7MimeCompressedDataEntity.class);
        Objects.requireNonNull(compressedDataEntity, "Failed to extract the EDI payload: the compressed data entity is null");
        ApplicationEntity ediEntity = HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo);
        return ediEntity;
    }

    private static ApplicationEntity extractMultipartSigned(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        ApplicationEntity ediEntity;
        MultipartSignedEntity multipartSignedEntity = HttpMessageUtils.getEntity(message, MultipartSignedEntity.class);
        Objects.requireNonNull(multipartSignedEntity, "Failed to extract EDI payload: the multipart signed entity is null");
        if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null && !SigningUtils.isValid(multipartSignedEntity, decrpytingAndSigningInfo.getValidateSigningCertificateChain())) {
            throw new HttpException("Failed to validate the signature");
        }
        MimeEntity mimeEntity = multipartSignedEntity.getSignedDataEntity();
        if (mimeEntity instanceof ApplicationEntity) {
            ediEntity = (ApplicationEntity)mimeEntity;
        } else if (mimeEntity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
            ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)mimeEntity;
            ediEntity = HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo);
        } else {
            throw new HttpException("Failed to extract EDI payload: invalid content type '" + mimeEntity.getContentTypeValue() + "' for AS2 compressed and signed message");
        }
        return ediEntity;
    }

    private static ApplicationEntity extractEdiPayloadFromEnvelopedEntity(ApplicationPkcs7MimeEnvelopedDataEntity envelopedDataEntity, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        ApplicationEntity ediEntity = null;
        MimeEntity entity = envelopedDataEntity.getEncryptedEntity(decrpytingAndSigningInfo.getDecryptingPrivateKey());
        String contentTypeString = entity.getContentTypeValue();
        if (contentTypeString == null) {
            throw new HttpException("Failed to extract EDI message: content type missing from encrypted entity");
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                ediEntity = (ApplicationEntity)entity;
                break;
            }
            case "multipart/signed": {
                MultipartSignedEntity multipartSignedEntity = (MultipartSignedEntity)entity;
                if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null && !SigningUtils.isValid(multipartSignedEntity, decrpytingAndSigningInfo.getValidateSigningCertificateChain())) {
                    throw new HttpException("Failed to validate the signature");
                }
                MimeEntity mimeEntity = multipartSignedEntity.getSignedDataEntity();
                if (mimeEntity instanceof ApplicationEntity) {
                    ediEntity = (ApplicationEntity)mimeEntity;
                    break;
                }
                if (mimeEntity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
                    ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)mimeEntity;
                    ediEntity = HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo);
                    break;
                }
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + mimeEntity.getContentTypeValue() + "' for AS2 compressed and signed entity");
            }
            case "application/pkcs7-mime": {
                if (!"compressed-data".equals(contentType.getParameter("smime-type"))) {
                    throw new HttpException("Failed to extract EDI payload: invalid mime type '" + contentType.getParameter("smime-type") + "' for AS2 enveloped entity");
                }
                ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)entity;
                ediEntity = HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo);
                break;
            }
            default: {
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + contentType.getMimeType() + "' for AS2 enveloped entity");
            }
        }
        return ediEntity;
    }

    public static ApplicationEntity extractEdiPayloadFromCompressedEntity(ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        ApplicationEntity ediEntity = null;
        MimeEntity entity = compressedDataEntity.getCompressedEntity((InputExpanderProvider)new ZlibExpanderProvider());
        String contentTypeString = entity.getContentTypeValue();
        if (contentTypeString == null) {
            throw new HttpException("Failed to extract EDI payload: content type missing from compressed entity");
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                ediEntity = (ApplicationEntity)entity;
                break;
            }
            case "multipart/signed": {
                MultipartSignedEntity multipartSignedEntity = (MultipartSignedEntity)entity;
                if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null && !SigningUtils.isValid(multipartSignedEntity, decrpytingAndSigningInfo.getValidateSigningCertificateChain())) {
                    throw new HttpException("Failed to validate the signature");
                }
                MimeEntity mimeEntity = multipartSignedEntity.getSignedDataEntity();
                if (mimeEntity instanceof ApplicationEntity) {
                    ediEntity = (ApplicationEntity)mimeEntity;
                    break;
                }
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + mimeEntity.getContentTypeValue() + "' for AS2 compressed and signed entity");
            }
            default: {
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + contentType.getMimeType() + "' for AS2 compressed entity");
            }
        }
        return ediEntity;
    }

    public static class DecrpytingAndSigningInfo {
        private Certificate[] validateSigningCertificateChain;
        private PrivateKey decryptingPrivateKey;

        public DecrpytingAndSigningInfo(Certificate[] validateSigningCertificateChain, PrivateKey decryptingPrivateKey) {
            this.validateSigningCertificateChain = validateSigningCertificateChain;
            this.decryptingPrivateKey = decryptingPrivateKey;
        }

        public Certificate[] getValidateSigningCertificateChain() {
            return this.validateSigningCertificateChain;
        }

        public PrivateKey getDecryptingPrivateKey() {
            return this.decryptingPrivateKey;
        }
    }
}

