/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.Objects;
import org.apache.camel.util.ObjectHelper;

public final class TypeConvertible<F, T> {
    private final Class<F> from;
    private final Class<T> to;
    private final int hash;

    public TypeConvertible(Class<F> from, Class<T> to) {
        assert (from != null);
        assert (to != null);
        this.from = from;
        this.to = to;
        this.hash = this.calculateHash();
    }

    public boolean matches(TypeConvertible<?, ?> that) {
        return TypeConvertible.match(this.from, this.to, that.from, that.to);
    }

    public boolean matchesPrimitive(TypeConvertible<?, ?> that) {
        if (that != null && that.getTo() != null) {
            return TypeConvertible.match(this.from, this.to, that.from, ObjectHelper.convertPrimitiveTypeToWrapperType(that.to));
        }
        return false;
    }

    private static boolean match(Class<?> thisFrom, Class<?> thisTo, Class<?> thatFrom, Class<?> thatTo) {
        Class<?>[] interfaceTypes;
        if (thatFrom == null || thatTo == null) {
            return false;
        }
        if (TypeConvertible.directMatch(thisFrom, thisTo, thatFrom, thatTo)) {
            return true;
        }
        if (thisFrom == thatFrom) {
            return false;
        }
        for (Class<?> interfaceType : interfaceTypes = thatFrom.getInterfaces()) {
            if (!TypeConvertible.match(thisFrom, thisTo, interfaceType, thatTo)) continue;
            return true;
        }
        return TypeConvertible.match(thisFrom, thisTo, thatFrom.getSuperclass(), thatTo);
    }

    public boolean isAssignableMatch(TypeConvertible<?, ?> that) {
        return TypeConvertible.isAssignableMatch(this.from, this.to, that.from, that.to);
    }

    private static boolean isAssignableMatch(Class<?> thisFrom, Class<?> thisTo, Class<?> thatFrom, Class<?> thatTo) {
        if (thisFrom == Object.class) {
            return false;
        }
        if (thisTo.isAssignableFrom(thatTo)) {
            return thisFrom.isAssignableFrom(thatFrom);
        }
        return false;
    }

    private static boolean directMatch(Class<?> thisFrom, Class<?> thisTo, Class<?> thatFrom, Class<?> thatTo) {
        if (Objects.equals(thisFrom, thatFrom)) {
            return Objects.equals(thisTo, thatTo);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeConvertible that = (TypeConvertible)o;
        return TypeConvertible.directMatch(this.from, this.to, that.from, that.to);
    }

    public int hashCode() {
        return this.hash;
    }

    private int calculateHash() {
        int result = 1;
        result = 31 * result + this.from.hashCode();
        result = 31 * result + this.to.hashCode();
        return result;
    }

    public Class<F> getFrom() {
        return this.from;
    }

    public Class<T> getTo() {
        return this.to;
    }

    public String toString() {
        return "TypeConvertible{from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + "}";
    }
}

