/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.service;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService {
    protected static final byte NEW = 0;
    protected static final byte BUILT = 1;
    protected static final byte INITIALIZING = 2;
    protected static final byte INITIALIZED = 3;
    protected static final byte STARTING = 4;
    protected static final byte STARTED = 5;
    protected static final byte SUSPENDING = 6;
    protected static final byte SUSPENDED = 7;
    protected static final byte STOPPING = 8;
    protected static final byte STOPPED = 9;
    protected static final byte SHUTTING_DOWN = 10;
    protected static final byte SHUTDOWN = 11;
    protected static final byte FAILED = 12;
    protected final Lock lock = new ReentrantLock();
    protected volatile byte status = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        block12: {
            if (this.status == 0) {
                this.lock.lock();
                try {
                    if (this.status != 0) break block12;
                    try (AutoCloseable ignored = this.doLifecycleChange();){
                        this.doBuild();
                    }
                    catch (Exception e) {
                        this.doFail(e);
                    }
                    this.status = 1;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        block12: {
            if (this.status <= 1 || this.status >= 9) {
                this.lock.lock();
                try {
                    if (this.status > 1 && this.status < 9) break block12;
                    this.build();
                    try (AutoCloseable ignored = this.doLifecycleChange();){
                        this.status = (byte)2;
                        this.doInit();
                        this.status = (byte)3;
                    }
                    catch (Exception e) {
                        BaseService.logger().trace("Error while initializing service: {}", (Object)this, (Object)e);
                        this.fail(e);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (this.status == 5) {
                BaseService.logger().trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 4) {
                BaseService.logger().trace("Service: {} already starting", (Object)this);
                return;
            }
            this.init();
            if (this.status == 12) {
                BaseService.logger().trace("Init failed");
                return;
            }
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.status = (byte)4;
                BaseService.logger().trace("Starting service: {}", (Object)this);
                this.doStart();
                this.status = (byte)5;
                BaseService.logger().trace("Started service: {}", (Object)this);
            }
            catch (Exception e) {
                try {
                    this.stop();
                }
                catch (Exception e2) {
                    BaseService.logger().trace("Error while stopping service after it failed to start: {}. This exception is ignored", (Object)this, (Object)e);
                }
                BaseService.logger().trace("Error while starting service: {}", (Object)this, (Object)e);
                this.fail(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            if (this.status == 12) {
                BaseService.logger().trace("Service: {} failed and regarded as already stopped", (Object)this);
                return;
            }
            if (this.status == 9 || this.status == 10 || this.status == 11) {
                BaseService.logger().trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 8) {
                BaseService.logger().trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = (byte)8;
            BaseService.logger().trace("Stopping service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doStop();
                this.status = (byte)9;
                BaseService.logger().trace("Stopped: {} service", (Object)this);
            }
            catch (Exception e) {
                BaseService.logger().trace("Error while stopping service: {}", (Object)this, (Object)e);
                this.fail(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        this.lock.lock();
        try {
            if (this.status == 7) {
                BaseService.logger().trace("Service: {} already suspended", (Object)this);
                return;
            }
            if (this.status == 6) {
                BaseService.logger().trace("Service: {} already suspending", (Object)this);
                return;
            }
            this.status = (byte)6;
            BaseService.logger().trace("Suspending service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doSuspend();
                this.status = (byte)7;
                BaseService.logger().trace("Suspended service: {}", (Object)this);
            }
            catch (Exception e) {
                BaseService.logger().trace("Error while suspending service: {}", (Object)this, (Object)e);
                this.fail(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.lock.lock();
        try {
            if (this.status != 7) {
                BaseService.logger().trace("Service is not suspended: {}", (Object)this);
                return;
            }
            this.status = (byte)4;
            BaseService.logger().trace("Resuming service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doResume();
                this.status = (byte)5;
                BaseService.logger().trace("Resumed service: {}", (Object)this);
            }
            catch (Exception e) {
                BaseService.logger().trace("Error while resuming service: {}", (Object)this, (Object)e);
                this.fail(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.status == 11) {
                BaseService.logger().trace("Service: {} already shutdown", (Object)this);
                return;
            }
            if (this.status == 10) {
                BaseService.logger().trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = (byte)11;
            BaseService.logger().trace("Shutting down service: {}", (Object)this);
            try (AutoCloseable ignored = this.doLifecycleChange();){
                this.doShutdown();
                BaseService.logger().trace("Shutdown service: {}", (Object)this);
                this.status = (byte)11;
            }
            catch (Exception e) {
                BaseService.logger().trace("Error shutting down service: {}", (Object)this, (Object)e);
                this.fail(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ServiceStatus getStatus() {
        switch (this.status) {
            case 2: {
                return ServiceStatus.Initializing;
            }
            case 3: {
                return ServiceStatus.Initialized;
            }
            case 4: {
                return ServiceStatus.Starting;
            }
            case 5: {
                return ServiceStatus.Started;
            }
            case 6: {
                return ServiceStatus.Suspending;
            }
            case 7: {
                return ServiceStatus.Suspended;
            }
            case 8: {
                return ServiceStatus.Stopping;
            }
        }
        return ServiceStatus.Stopped;
    }

    public boolean isNew() {
        return this.status == 0;
    }

    public boolean isBuild() {
        return this.status == 1;
    }

    public boolean isInit() {
        return this.status == 3;
    }

    public boolean isStarted() {
        return this.status == 5;
    }

    public boolean isStarting() {
        return this.status == 4;
    }

    public boolean isStopping() {
        return this.status == 8;
    }

    public boolean isStopped() {
        return this.status < 4 || this.status >= 9;
    }

    public boolean isSuspending() {
        return this.status == 6;
    }

    public boolean isSuspended() {
        return this.status == 7;
    }

    public boolean isRunAllowed() {
        return this.status >= 4 && this.status <= 7;
    }

    public boolean isShutdown() {
        return this.status == 11;
    }

    public boolean isStoppingOrStopped() {
        return this.status < 4 || this.status > 7;
    }

    public boolean isSuspendingOrSuspended() {
        return this.status == 6 || this.status == 7;
    }

    public boolean isStartingOrStarted() {
        return this.status == 4 || this.status == 5;
    }

    protected void fail(Exception e) {
        try {
            this.doFail(e);
        }
        finally {
            this.status = (byte)12;
        }
    }

    protected void doBuild() throws Exception {
    }

    protected void doInit() throws Exception {
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }

    protected void doFail(Exception e) {
        throw RuntimeCamelException.wrapRuntimeException(e);
    }

    protected AutoCloseable doLifecycleChange() {
        return null;
    }

    private static Logger logger() {
        return Holder.LOG;
    }

    private static final class Holder {
        static final Logger LOG = LoggerFactory.getLogger(Holder.class);

        private Holder() {
        }
    }
}

